"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectSpread4 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _reactMarkdownPreview = _interopRequireDefault(require("@uiw/react-markdown-preview"));

var _TextArea = _interopRequireDefault(require("./components/TextArea"));

var _Toolbar = _interopRequireDefault(require("./components/Toolbar"));

var _DragBar = _interopRequireDefault(require("./components/DragBar"));

var _commands = require("./commands");

function setGroupPopFalse(data) {
  Object.keys(data).forEach(function (keyname) {
    data[keyname] = false;
  });
  return data;
}

var InternalMDEditor = function InternalMDEditor(props, ref) {
  var _classnames;

  var _ref = props || {},
      _ref$prefixCls = _ref.prefixCls,
      prefixCls = _ref$prefixCls === void 0 ? 'w-md-editor' : _ref$prefixCls,
      className = _ref.className,
      propsValue = _ref.value,
      _ref$commands = _ref.commands,
      commands = _ref$commands === void 0 ? (0, _commands.getCommands)() : _ref$commands,
      _ref$height = _ref.height,
      heightWarp = _ref$height === void 0 ? 200 : _ref$height,
      _ref$visiableDragbar = _ref.visiableDragbar,
      visiableDragbar = _ref$visiableDragbar === void 0 ? true : _ref$visiableDragbar,
      _ref$preview = _ref.preview,
      previewType = _ref$preview === void 0 ? 'live' : _ref$preview,
      isfullscreen = _ref.fullscreen,
      previewOptions = _ref.previewOptions,
      textareaProps = _ref.textareaProps,
      _ref$maxHeight = _ref.maxHeight,
      maxHeight = _ref$maxHeight === void 0 ? 1200 : _ref$maxHeight,
      _ref$minHeight = _ref.minHeight,
      minHeight = _ref$minHeight === void 0 ? 100 : _ref$minHeight,
      autoFocus = _ref.autoFocus,
      _ref$tabSize = _ref.tabSize,
      tabSize = _ref$tabSize === void 0 ? 2 : _ref$tabSize,
      onChange = _ref.onChange,
      hideToolbar = _ref.hideToolbar,
      other = (0, _objectWithoutProperties2.default)(_ref, ["prefixCls", "className", "value", "commands", "height", "visiableDragbar", "preview", "fullscreen", "previewOptions", "textareaProps", "maxHeight", "minHeight", "autoFocus", "tabSize", "onChange", "hideToolbar"]);

  var _useState = (0, _react.useState)(propsValue || ''),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];

  var _useState3 = (0, _react.useState)(previewType),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      preview = _useState4[0],
      setPreview = _useState4[1];

  var _useState5 = (0, _react.useState)(isfullscreen || false),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      isFullscreen = _useState6[0],
      setIsFullscreen = _useState6[1];

  var _useState7 = (0, _react.useState)({}),
      _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
      groupPop = _useState8[0],
      setGroupPop = _useState8[1];

  var leftScroll = (0, _react.useRef)(false);

  var previewRef = /*#__PURE__*/_react.default.createRef();

  var _useState9 = (0, _react.useState)(heightWarp),
      _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
      height = _useState10[0],
      setHeight = _useState10[1];

  var textarea = /*#__PURE__*/_react.default.createRef();

  var commandOrchestrator = (0, _react.useRef)();
  var selectionRange = (0, _react.useRef)({
    count: 0,
    scrollTop: 0
  });
  var cls = (0, _classnames2.default)(className, prefixCls, (_classnames = {}, (0, _defineProperty2.default)(_classnames, "".concat(prefixCls, "-show-").concat(preview), preview), (0, _defineProperty2.default)(_classnames, "".concat(prefixCls, "-fullscreen"), isFullscreen), _classnames));

  var commandOrchestratorHandle = function commandOrchestratorHandle() {
    if (textarea.current && textarea.current.text) {
      commandOrchestrator.current = new _commands.TextAreaCommandOrchestrator(textarea.current.text || null);
    }

    return commandOrchestrator.current;
  };

  (0, _react.useMemo)(function () {
    return preview !== props.preview && props.preview && setPreview(props.preview);
  }, [props.preview]);
  (0, _react.useMemo)(function () {
    return value !== props.value && setValue(props.value);
  }, [props.value]);
  (0, _react.useMemo)(function () {
    return height !== props.height && setHeight(heightWarp);
  }, [heightWarp]);

  function handleTextAreaMount(isMount) {
    if (textarea.current && textarea.current.text && textarea.current.warp && isMount) {
      if (autoFocus) {
        textarea.current.text.blur();
        textarea.current.text.focus();
      }

      textarea.current.text.selectionStart = selectionRange.current.count;
      textarea.current.text.selectionEnd = selectionRange.current.count;
      textarea.current.warp.scrollTo(0, selectionRange.current.scrollTop);
    }
  }

  function modifySelectionRange() {
    if (textarea.current && textarea.current.text && textarea.current.warp) {
      selectionRange.current.count = textarea.current.text.selectionStart;
      selectionRange.current.scrollTop = textarea.current.warp.scrollTop;
    }
  }

  function handleChange(event) {
    modifySelectionRange();
    setValue(event.target.value);
    onChange && onChange(event.target.value || '');
  }

  function handleCommand(command, groupName) {
    commandOrchestratorHandle();
    modifySelectionRange();

    if (command.keyCommand === 'preview') {
      setPreview(command.value);
    }

    if (command.keyCommand === 'fullscreen') {
      setIsFullscreen(!isFullscreen);
      document.body.style.overflow = isFullscreen ? 'initial' : 'hidden';
    }

    if (command.keyCommand === 'group') {
      setGroupPop((0, _objectSpread4.default)((0, _objectSpread4.default)({}, setGroupPopFalse(groupPop)), {}, (0, _defineProperty2.default)({}, "".concat(groupName), true)));
    }

    if (groupName && command.keyCommand !== 'group') {
      setGroupPop((0, _objectSpread4.default)((0, _objectSpread4.default)({}, groupPop), {}, (0, _defineProperty2.default)({}, "".concat(groupName), false)));
    }

    commandOrchestrator.current && commandOrchestrator.current.executeCommand(command);
  }

  function handleScroll(e) {
    if (!textarea.current || !previewRef.current || !previewRef.current.mdp.current || !textarea.current.warp) {
      return;
    }

    var previewDom = previewRef.current.mdp.current;
    var textareaDom = textarea.current.warp;

    if (textareaDom && previewDom) {
      var scale = (textareaDom.scrollHeight - textareaDom.offsetHeight) / (previewDom.scrollHeight - previewDom.offsetHeight);

      if (e.target === textareaDom && leftScroll.current) {
        previewDom.scrollTop = textareaDom.scrollTop / scale;
      }

      if (e.target === previewDom && !leftScroll.current) {
        textareaDom.scrollTop = previewDom.scrollTop * scale;
      }
    }
  }

  var chestratorObj = (0, _react.useMemo)(function () {
    return commandOrchestratorHandle();
  }, [textarea.current, commandOrchestrator.current]);
  var mdProps = (0, _objectSpread4.default)((0, _objectSpread4.default)({}, previewOptions), {}, {
    ref: previewRef,
    onScroll: handleScroll,
    source: value || ''
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: cls,
    onClick: function onClick() {
      return setGroupPop((0, _objectSpread4.default)({}, setGroupPopFalse(groupPop)));
    },
    style: {
      height: isFullscreen ? '100%' : hideToolbar ? Number(height) - 29 : height
    }
  }, other), !hideToolbar && /*#__PURE__*/_react.default.createElement(_Toolbar.default, {
    active: (0, _objectSpread4.default)({
      fullscreen: isFullscreen,
      preview: preview
    }, groupPop),
    prefixCls: prefixCls,
    commands: commands,
    commandHelp: (0, _objectSpread4.default)({
      getState: commandOrchestrator.current && commandOrchestrator.current.getState,
      textApi: commandOrchestrator.current && commandOrchestrator.current.textApi
    }, chestratorObj),
    onCommand: handleCommand
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefixCls, "-content"),
    style: {
      height: isFullscreen ? 'calc(100% - 29px)' : Number(height) - 29
    }
  }, /(edit|live)/.test(preview) && /*#__PURE__*/_react.default.createElement(_TextArea.default, (0, _extends2.default)({
    ref: textarea,
    tabSize: tabSize,
    className: "".concat(prefixCls, "-input"),
    prefixCls: prefixCls,
    value: value || '',
    autoFocus: autoFocus
  }, textareaProps, {
    onScroll: handleScroll,
    onMouseOver: function onMouseOver() {
      return leftScroll.current = true;
    },
    onMouseLeave: function onMouseLeave() {
      return leftScroll.current = false;
    },
    onMount: handleTextAreaMount,
    onChange: handleChange
  })), /(live|preview)/.test(preview) && /*#__PURE__*/_react.default.createElement(_reactMarkdownPreview.default, (0, _extends2.default)({}, mdProps, {
    className: "".concat(prefixCls, "-preview")
  }))), visiableDragbar && !isFullscreen && /*#__PURE__*/_react.default.createElement(_DragBar.default, {
    prefixCls: prefixCls,
    height: height,
    maxHeight: maxHeight,
    minHeight: minHeight,
    onChange: function onChange(newHeight) {
      setHeight(newHeight);
    }
  })));
};

var MDEditor = /*#__PURE__*/_react.default.forwardRef(InternalMDEditor);

MDEditor.Markdown = _reactMarkdownPreview.default;
var _default = MDEditor;
exports.default = _default;
module.exports = exports.default; 
//# sourceMappingURL=Editor.js.map