"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.title1 = void 0;

var _react = _interopRequireDefault(require("react"));

var title1 = {
  name: 'title1',
  keyCommand: 'title1',
  buttonProps: {
    'aria-label': 'Insert title 1'
  },
  icon: /*#__PURE__*/_react.default.createElement("div", {
    style: {
      fontSize: 18,
      textAlign: 'left'
    }
  }, "Title 1"),
  execute: function execute(state, api) {
    var modifyText = "# ".concat(state.selectedText, "\n");

    if (!state.selectedText) {
      modifyText = "# ";
    }

    api.replaceSelection(modifyText);
  }
};
exports.title1 = title1; 
//# sourceMappingURL=title1.js.map