"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var DragBar = function DragBar(props) {
  var _ref = props || {},
      prefixCls = _ref.prefixCls,
      onChange = _ref.onChange;

  var dragRef = (0, _react.useRef)();

  function handleMouseMove(event) {
    if (dragRef.current) {
      var newHeight = dragRef.current.height + event.clientY - dragRef.current.dragY;

      if (newHeight >= props.minHeight && newHeight <= props.maxHeight) {
        onChange && onChange(dragRef.current.height + (event.clientY - dragRef.current.dragY));
      }
    }
  }

  function handleMouseUp() {
    dragRef.current = undefined;
  }

  function handleMouseDown(event) {
    dragRef.current = {
      height: props.height,
      dragY: event.clientY
    };
  }

  (0, _react.useEffect)(function () {
    document.addEventListener('mousemove', handleMouseMove);
    document.addEventListener('mouseup', handleMouseUp);
    return function () {
      document.removeEventListener('mousemove', handleMouseMove);
      document.removeEventListener('mouseup', handleMouseUp);
    };
  }, []);
  var svg = (0, _react.useMemo)(function () {
    return /*#__PURE__*/_react.default.createElement("svg", {
      viewBox: "0 0 512 512",
      height: "100%"
    }, /*#__PURE__*/_react.default.createElement("path", {
      fill: "currentColor",
      d: "M304 256c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48 48 21.5 48 48zm120-48c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48zm-336 0c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48z"
    }));
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefixCls, "-bar"),
    onMouseDown: handleMouseDown
  }, svg);
};

var _default = DragBar;
exports.default = _default;
module.exports = exports.default; 
//# sourceMappingURL=index.js.map