"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _prismjs = _interopRequireDefault(require("prismjs"));

require("prismjs/components/prism-markdown.js");

var _hotkeys = _interopRequireDefault(require("./hotkeys"));

var _this = void 0;

var _default = /*#__PURE__*/_react.default.forwardRef(function (props, ref) {
  var _ref = props || {},
      prefixCls = _ref.prefixCls,
      className = _ref.className,
      _onChange = _ref.onChange,
      onMount = _ref.onMount,
      onScroll = _ref.onScroll,
      tabSize = _ref.tabSize,
      style = _ref.style,
      otherProps = (0, _objectWithoutProperties2.default)(_ref, ["prefixCls", "className", "onChange", "onMount", "onScroll", "tabSize", "style"]);

  var warp = /*#__PURE__*/_react.default.createRef();

  var preElm = /*#__PURE__*/_react.default.createRef();

  var textElm = /*#__PURE__*/_react.default.createRef();

  (0, _react.useImperativeHandle)(ref, function () {
    return {
      text: textElm.current,
      warp: warp.current
    };
  }, [warp.current, textElm.current]);

  var _useState = (0, _react.useState)(props.value),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];

  var highlight = function highlight() {
    var pre = preElm.current;

    var html = _prismjs.default.highlight(value, _prismjs.default.languages.markdown, 'markdown');

    pre.innerHTML = "".concat(html, "<br />");
  };

  (0, _react.useEffect)(function () {
    onMount && onMount(true);
    return function () {
      onMount && onMount(false);
    };
  }, []);
  (0, _react.useEffect)(function () {
    if (props.value !== value) {
      setValue(props.value);
    }
  }, [props.value]);
  (0, _react.useEffect)(function () {
    return highlight();
  }, [value]);
  (0, _react.useEffect)(function () {
    if (props.autoFocus && textElm.current) {
      textElm.current.focus();
    }
  }, [props.autoFocus]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: warp,
    className: (0, _classnames.default)("".concat(prefixCls, "-aree"), className),
    onScroll: onScroll
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)("".concat(prefixCls, "-text"))
  }, /*#__PURE__*/_react.default.createElement("pre", {
    ref: preElm,
    className: (0, _classnames.default)("".concat(prefixCls, "-text-pre"), 'wmde-markdown-color')
  }), /*#__PURE__*/_react.default.createElement("textarea", (0, _extends2.default)({}, otherProps, {
    ref: textElm,
    onKeyDown: _hotkeys.default.bind(_this, {
      tabSize: tabSize
    }),
    className: "".concat(prefixCls, "-text-input"),
    value: value,
    onChange: function onChange(e) {
      setValue(e.target.value);
      _onChange && _onChange(e);
    }
  }))));
});

exports.default = _default;
module.exports = exports.default; 
//# sourceMappingURL=index.js.map