"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Toolbar;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Child = _interopRequireDefault(require("./Child"));

function Toolbar() {
  var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var prefixCls = props.prefixCls,
      _props$commands = props.commands,
      commands = _props$commands === void 0 ? [] : _props$commands,
      _props$commandHelp = props.commandHelp,
      commandHelp = _props$commandHelp === void 0 ? {} : _props$commandHelp,
      active = props.active,
      groupName = props.groupName;

  function handleClick(command, name) {
    var onCommand = props.onCommand;
    onCommand && onCommand(command, groupName || name);
  }

  return /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefixCls, "-toolbar")
  }, /*#__PURE__*/_react.default.createElement("ul", null, commands.map(function (item, idx) {
    if (item.keyCommand === 'divider') {
      return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
        key: idx
      }, item.liProps, {
        className: "".concat(prefixCls, "-toolbar-divider")
      }));
    }

    if (!item.keyCommand) return;
    var activeBtn = active && (item.value ? active[item.keyCommand] && active[item.keyCommand] === item.value : active[item.keyCommand]);
    var childNode = typeof item.children === 'function' ? item.children((0, _objectSpread2.default)({
      close: function close() {
        return handleClick({}, item.groupName);
      },
      execute: function execute() {
        return handleClick({
          execute: item.execute
        });
      }
    }, commandHelp)) : undefined;
    return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
      key: idx
    }, item.liProps, {
      className: (0, _classnames.default)({
        active: activeBtn
      })
    }), !item.buttonProps && item.icon, item.buttonProps && /*#__PURE__*/_react.default.createElement('button', (0, _objectSpread2.default)((0, _objectSpread2.default)({
      type: 'button',
      disabled: active && active.preview && active.preview === 'preview' && !/(preview|fullscreen)/.test(item.keyCommand),
      'data-name': item.name
    }, item.buttonProps), {}, {
      onClick: function onClick(evn) {
        evn.stopPropagation();
        handleClick(item, item.groupName);
      }
    }), item.icon), item.children && /*#__PURE__*/_react.default.createElement(_Child.default, {
      active: active,
      groupName: item.groupName,
      prefixCls: prefixCls,
      onCommand: props.onCommand,
      children: childNode,
      commands: Array.isArray(item.children) && typeof item.children !== 'function' ? item.children : undefined
    }));
  })));
}

module.exports = exports.default; 
//# sourceMappingURL=index.js.map