import React, { useEffect, useMemo, useRef } from 'react';
import "./index.css";

var DragBar = function DragBar(props) {
  var _ref = props || {},
      prefixCls = _ref.prefixCls,
      onChange = _ref.onChange;

  var dragRef = useRef();

  function handleMouseMove(event) {
    if (dragRef.current) {
      var newHeight = dragRef.current.height + event.clientY - dragRef.current.dragY;

      if (newHeight >= props.minHeight && newHeight <= props.maxHeight) {
        onChange && onChange(dragRef.current.height + (event.clientY - dragRef.current.dragY));
      }
    }
  }

  function handleMouseUp() {
    dragRef.current = undefined;
  }

  function handleMouseDown(event) {
    dragRef.current = {
      height: props.height,
      dragY: event.clientY
    };
  }

  useEffect(function () {
    document.addEventListener('mousemove', handleMouseMove);
    document.addEventListener('mouseup', handleMouseUp);
    return function () {
      document.removeEventListener('mousemove', handleMouseMove);
      document.removeEventListener('mouseup', handleMouseUp);
    };
  }, []);
  var svg = useMemo(function () {
    return /*#__PURE__*/React.createElement("svg", {
      viewBox: "0 0 512 512",
      height: "100%"
    }, /*#__PURE__*/React.createElement("path", {
      fill: "currentColor",
      d: "M304 256c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48 48 21.5 48 48zm120-48c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48zm-336 0c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48z"
    }));
  }, []);
  return /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefixCls, "-bar"),
    onMouseDown: handleMouseDown
  }, svg);
};

export default DragBar; 
//# sourceMappingURL=index.js.map