import _extends from "@babel/runtime/helpers/esm/extends";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";

var _this = this;

import React, { useEffect, useImperativeHandle, useState } from 'react';
import classnames from 'classnames';
import Prism from 'prismjs';
import 'prismjs/components/prism-markdown.js';
import hotkeys from './hotkeys';
import "./index.css";
export default /*#__PURE__*/React.forwardRef(function (props, ref) {
  var _ref = props || {},
      prefixCls = _ref.prefixCls,
      className = _ref.className,
      _onChange = _ref.onChange,
      onMount = _ref.onMount,
      onScroll = _ref.onScroll,
      tabSize = _ref.tabSize,
      style = _ref.style,
      otherProps = _objectWithoutProperties(_ref, ["prefixCls", "className", "onChange", "onMount", "onScroll", "tabSize", "style"]);

  var warp = /*#__PURE__*/React.createRef();
  var preElm = /*#__PURE__*/React.createRef();
  var textElm = /*#__PURE__*/React.createRef();
  useImperativeHandle(ref, function () {
    return {
      text: textElm.current,
      warp: warp.current
    };
  }, [warp.current, textElm.current]);

  var _useState = useState(props.value),
      _useState2 = _slicedToArray(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];

  var highlight = function highlight() {
    var pre = preElm.current;
    var html = Prism.highlight(value, Prism.languages.markdown, 'markdown');
    pre.innerHTML = "".concat(html, "<br />");
  };

  useEffect(function () {
    onMount && onMount(true);
    return function () {
      onMount && onMount(false);
    };
  }, []);
  useEffect(function () {
    if (props.value !== value) {
      setValue(props.value);
    }
  }, [props.value]);
  useEffect(function () {
    return highlight();
  }, [value]);
  useEffect(function () {
    if (props.autoFocus && textElm.current) {
      textElm.current.focus();
    }
  }, [props.autoFocus]);
  return /*#__PURE__*/React.createElement("div", {
    ref: warp,
    className: classnames("".concat(prefixCls, "-aree"), className),
    onScroll: onScroll
  }, /*#__PURE__*/React.createElement("div", {
    className: classnames("".concat(prefixCls, "-text"))
  }, /*#__PURE__*/React.createElement("pre", {
    ref: preElm,
    className: classnames("".concat(prefixCls, "-text-pre"), 'wmde-markdown-color')
  }), /*#__PURE__*/React.createElement("textarea", _extends({}, otherProps, {
    ref: textElm,
    onKeyDown: hotkeys.bind(_this, {
      tabSize: tabSize
    }),
    className: "".concat(prefixCls, "-text-input"),
    value: value,
    onChange: function onChange(e) {
      setValue(e.target.value);
      _onChange && _onChange(e);
    }
  }))));
}); 
//# sourceMappingURL=index.js.map