import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import React from 'react';
import classnames from 'classnames';
import Child from './Child';
import "./index.css";
export default function Toolbar() {
  var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var prefixCls = props.prefixCls,
      _props$commands = props.commands,
      commands = _props$commands === void 0 ? [] : _props$commands,
      _props$commandHelp = props.commandHelp,
      commandHelp = _props$commandHelp === void 0 ? {} : _props$commandHelp,
      active = props.active,
      groupName = props.groupName;

  function handleClick(command, name) {
    var onCommand = props.onCommand;
    onCommand && onCommand(command, groupName || name);
  }

  return /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefixCls, "-toolbar")
  }, /*#__PURE__*/React.createElement("ul", null, commands.map(function (item, idx) {
    if (item.keyCommand === 'divider') {
      return /*#__PURE__*/React.createElement("li", _extends({
        key: idx
      }, item.liProps, {
        className: "".concat(prefixCls, "-toolbar-divider")
      }));
    }

    if (!item.keyCommand) return;
    var activeBtn = active && (item.value ? active[item.keyCommand] && active[item.keyCommand] === item.value : active[item.keyCommand]);
    var childNode = typeof item.children === 'function' ? item.children(_objectSpread({
      close: function close() {
        return handleClick({}, item.groupName);
      },
      execute: function execute() {
        return handleClick({
          execute: item.execute
        });
      }
    }, commandHelp)) : undefined;
    return /*#__PURE__*/React.createElement("li", _extends({
      key: idx
    }, item.liProps, {
      className: classnames({
        active: activeBtn
      })
    }), !item.buttonProps && item.icon, item.buttonProps && /*#__PURE__*/React.createElement('button', _objectSpread(_objectSpread({
      type: 'button',
      disabled: active && active.preview && active.preview === 'preview' && !/(preview|fullscreen)/.test(item.keyCommand),
      'data-name': item.name
    }, item.buttonProps), {}, {
      onClick: function onClick(evn) {
        evn.stopPropagation();
        handleClick(item, item.groupName);
      }
    }), item.icon), item.children && /*#__PURE__*/React.createElement(Child, {
      active: active,
      groupName: item.groupName,
      prefixCls: prefixCls,
      onCommand: props.onCommand,
      children: childNode,
      commands: Array.isArray(item.children) && typeof item.children !== 'function' ? item.children : undefined
    }));
  })));
} 
//# sourceMappingURL=index.js.map