'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
const chevronIcon = require('./chevron-icon-3bf07531.js');
require('./types-dc22e301.js');

const icAccordionCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block;border-bottom:var(--ic-border-default)}:host ic-typography,:host .expand-chevron{color:var(--ic-color-primary-text)}:host(.light) ic-typography,:host(.light) .expanded-content,:host(.light) .icon-container,:host(.light) .expand-chevron{color:var(--ic-color-white-text)}:host(.disabled) ic-typography,:host(.disabled) .icon-container,:host(.disabled) .expand-chevron{color:var(--ic-architectural-500)}.section-button.small{padding:var(--ic-space-xxs) var(--ic-space-xs)}.section-button.large{padding:var(--ic-space-sm) var(--ic-space-xs)}:host(:first-of-type){border-top:var(--ic-border-default)}:focus{outline:none}.section-button{background-color:transparent;display:flex;align-items:center;width:100%;padding:var(--ic-space-xs);font-weight:var(--ic-font-weight-bold);border:none}.section-header{text-align:left;flex:1 0}button:hover:enabled{background-color:var(--ic-action-dark-bg-hover);cursor:pointer}button:active{background-color:var(--ic-action-dark-bg-active)}button:focus{box-shadow:var(--ic-border-focus);border-radius:var(--ic-border-radius);transition:var(--ic-transition-duration-fast)}button:disabled{pointer-events:none}.icon-container{margin:0 var(--ic-space-xs) 0 0;display:flex;align-items:center;width:var(--ic-space-lg);height:var(--ic-space-lg)}::slotted(svg){width:var(--ic-space-md);height:var(--ic-space-md)}.expand-chevron{width:var(--ic-space-lg);height:var(--ic-space-lg);margin-left:calc(var(--ic-space-xl) + var(--ic-space-xs));transform:rotate(90deg);justify-self:end}.content-expanded-chevron{transform:rotate(-90deg)}.expanded-content{height:0;overflow:hidden;display:flex;flex-direction:column;visibility:var(--ic-expanded-content-visibility, hidden)}.expanded-content-inner{padding:var(--ic-space-xs)}.expanded-content-opened{overflow:visible}@media (forced-colors: active){button:focus{border:var(--ic-hc-border) !important}}";

let accordionIds = 0;
const Accordion = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.accordionClicked = index.createEvent(this, "accordionClicked", 7);
        this.accordionId = `ic-accordion-${accordionIds++}`;
        this.CONTENT_VISIBILITY_PROPERTY = "--ic-expanded-content-visibility";
        this.toggleExpanded = () => {
            this.expanded = !this.expanded;
            this.accordionClicked.emit({ id: this.accordionId });
        };
        // Set accordion animation
        this.setAccordionAnimation = (el, duration, property, delay) => {
            el.style.transitionDuration = `${duration}ms`;
            el.style.transitionProperty = property;
            el.style.transitionDelay = delay;
        };
        this.setExpandedContentStyle = (ev, expandedContent) => {
            if (ev.propertyName === "height" && expandedContent.clientHeight > 0) {
                expandedContent.classList.add("expanded-content-opened");
                expandedContent.style.height = "auto";
            }
        };
        this.hideExpandedContent = (ev, expandedContent) => {
            if (ev.propertyName === "height" && expandedContent.clientHeight === 0) {
                expandedContent.style.setProperty(this.CONTENT_VISIBILITY_PROPERTY, "hidden");
            }
        };
        this.animateExpandedContent = () => {
            const elementHeight = this.expandedContentEl.scrollHeight;
            if (elementHeight > 0 && this.expanded) {
                this.expandedContentEl.style.setProperty(this.CONTENT_VISIBILITY_PROPERTY, "visible");
                this.expandedContentEl.style.height = `${elementHeight}px`;
                this.setAccordionAnimation(this.expandedContentEl, "300", "height", "ease-out");
                this.expandedContentEl.addEventListener("transitionend", (e) => {
                    this.setExpandedContentStyle(e, this.expandedContentEl);
                });
            }
            else if (!this.expanded) {
                this.expandedContentEl.style.height = `${this.expandedContentEl.scrollHeight}px`;
                if (this.expandedContentEl.scrollHeight > 0 && !this.expanded) {
                    this.expandedContentEl.style.height = "0";
                    this.setAccordionAnimation(this.expandedContentEl, "300", "height", "ease-in");
                    this.expandedContentEl.classList.remove("expanded-content-opened");
                }
                this.expandedContentEl.addEventListener("transitionend", (e) => {
                    this.hideExpandedContent(e, this.expandedContentEl);
                });
            }
        };
        this.appearance = "default";
        this.disabled = false;
        this.expanded = false;
        this.heading = "";
        this.message = "";
        this.size = "default";
    }
    // Every time expanded is set via toggleExpanded or accordionGroup, animate to open or close
    handleExpandedWatch() {
        this.animateExpandedContent();
    }
    /**
     * Sets focus on accordion heading.
     */
    async setFocus() {
        if (this.accordionBtnHeading) {
            this.accordionBtnHeading.focus();
        }
    }
    disconnectedCallback() {
        if (this.expandedContentEl) {
            this.expandedContentEl.removeEventListener("transitionend", (e) => this.setExpandedContentStyle(e, this.expandedContentEl), true);
            this.expandedContentEl.removeEventListener("transitionend", (e) => this.hideExpandedContent(e, this.expandedContentEl), true);
        }
    }
    componentDidLoad() {
        // So accordion opens by default if expanded set to true
        if (this.expanded) {
            this.expandedContentEl.style.height = "auto";
            this.expandedContentEl.style.setProperty(this.CONTENT_VISIBILITY_PROPERTY, "visible");
        }
    }
    render() {
        const { appearance, size, disabled, expanded } = this;
        return (index.h(index.Host, { id: this.accordionId, class: {
                [`${appearance}`]: true,
                ["disabled"]: disabled,
            }, "aria-disabled": disabled ? "true" : "false" }, index.h("button", { ref: (el) => (this.accordionBtnHeading = el), id: `${this.accordionId}-button`, disabled: disabled, tabindex: disabled ? -1 : 0, class: {
                [`${size}`]: true,
                ["section-button"]: true,
                ["section-button-open"]: expanded && !disabled,
            }, "aria-expanded": `${expanded}`, "aria-controls": "expanded-content-area", onClick: this.toggleExpanded }, helpers.isSlotUsed(this.el, "icon") && (index.h("div", { class: "icon-container" }, index.h("slot", { name: "icon" }))), index.h("ic-typography", { variant: "subtitle-large", class: "section-header" }, helpers.isSlotUsed(this.el, "heading") ? (index.h("slot", { name: "heading" })) : (this.heading)), index.h("span", { class: {
                ["expand-chevron"]: true,
                ["content-expanded-chevron"]: expanded && !disabled,
            }, "aria-hidden": "true", innerHTML: chevronIcon.Chevron })), index.h("div", { class: {
                ["expanded-content"]: true,
            }, "aria-labelledby": `${this.accordionId}-button`, role: "region", "aria-hidden": `${!expanded}`, id: "expanded-content-area", ref: (el) => (this.expandedContentEl = el) }, index.h("div", { class: "expanded-content-inner" }, this.message ? (index.h("ic-typography", { variant: "body" }, this.message)) : (index.h("slot", null))))));
    }
    get el() { return index.getElement(this); }
    static get watchers() { return {
        "expanded": ["handleExpandedWatch"]
    }; }
};
Accordion.style = icAccordionCss;

exports.ic_accordion = Accordion;

//# sourceMappingURL=ic-accordion.cjs.entry.js.map