'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
require('./types-dc22e301.js');

const ArrowUpward = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" aria-hidden="true">
    <path d="M0 8L1.41 9.41L7 3.83V16H9V3.83L14.58 9.42L16 8L8 0L0 8Z"/>
</svg>
`;

const icBackToTopCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block;position:absolute;right:0}.positioning{position:fixed;right:var(--ic-space-md);bottom:var(--ic-space-md);transition:visibility 0s linear var(--ic-transition-duration-slow),\n    opacity var(--ic-transition-duration-slow);z-index:var(--ic-z-index-back-to-top)}.icon-only{width:2.5rem;padding:var(--ic-space-xs) var(--ic-space-xs) var(--ic-space-xs)\n    var(--ic-space-xs)}.icon-only .ic-back-to-top-icon{padding-left:calc(var(--ic-space-xxxs) + var(--ic-space-1px))}button{height:2.5rem;align-items:center;padding:var(--ic-space-xs) var(--ic-space-md) var(--ic-space-xs)\n    var(--ic-space-sm);margin:0;gap:var(--ic-space-xs);display:flex;background-color:var(--ic-architectural-white);border:var(--ic-border-width) solid var(--ic-action-default);outline-width:inherit;box-sizing:border-box;box-shadow:var(--ic-elevation-overlay);border-radius:5rem;text-decoration:none;visibility:hidden;opacity:0;cursor:pointer}button:hover{text-decoration:none;background-color:var(--ic-action-default-bg-hover-no-alpha);border:var(--ic-border-width) solid var(--ic-action-default-hover)}button:active{text-decoration:none;background-color:var(--ic-action-default-bg-active-no-alpha);border:var(--ic-border-width) solid var(--ic-action-default-active)}button:focus{box-shadow:var(--ic-border-focus)}.ic-back-to-top-link.show{visibility:visible;opacity:1;transition:visibility 0s linear 0s,\n    opacity var(--ic-transition-duration-slow),\n    box-shadow var(--ic-easing-transition-fast)}.ic-back-to-top-link.by-footer{position:relative;right:var(--ic-space-md);bottom:3.5rem}.ic-back-to-top-link.offset-banner{margin-bottom:var(--ic-space-lg)}.ic-back-to-top-icon{fill:var(--ic-action-default);padding-left:var(--ic-space-xxs);padding-top:var(--ic-space-xxxs)}.ic-back-to-top-icon>svg{height:var(--ic-space-md);width:var(--ic-space-md);display:inline-block}.ic-back-to-top-link span{color:var(--ic-action-default)}.ic-back-to-top-link:hover .ic-back-to-top-icon{fill:var(--ic-action-default-hover)}.ic-back-to-top-link:hover span{color:var(--ic-action-default-hover)}@media (forced-colors: active){.ic-back-to-top-icon{fill:currentcolor}}";

const backToTopLabel = "Back to top";
const BackToTop = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.topObserver = null;
        this.getObservedEl = () => {
            return document.querySelector("#ic-back-to-top-target");
        };
        this.setTargetElVisible = (visible) => {
            this.targetElVisible = visible;
        };
        this.setFooterVisible = (visible) => {
            this.checkForClassificationBanner();
            this.footerVisible =
                typeof window !== "undefined" && window.scrollY === 0 ? false : visible;
        };
        this.targetElObserverCallback = (entries) => {
            this.setTargetElVisible(entries[0].isIntersecting);
        };
        this.footerObserverCallback = (entries) => {
            this.setFooterVisible(entries[0].isIntersecting);
        };
        this.findTargetEl = (target) => {
            let targetElement = null;
            if (target === null || target === undefined) {
                console.log("Error: No target ID specified for back to top component - defaulting to top of page");
            }
            else {
                targetElement = document.querySelector(`${target.startsWith("#") ? "" : "#"}${target}`);
                if (targetElement === null) {
                    console.log(`Error: Back to top target element '${target}' not found - defaulting to top of page`);
                }
            }
            return targetElement;
        };
        this.createTopObserver = (target) => {
            this.targetEl = this.findTargetEl(target);
            let objParent;
            //remove old element & observer
            if (this.topObserver !== null) {
                const observedEl = this.getObservedEl();
                if (observedEl !== null) {
                    this.topObserver.unobserve(observedEl);
                    observedEl.remove();
                }
            }
            if (this.targetEl === null) {
                objParent = document.body;
                this.targetEl = objParent.firstElementChild;
                this.isTargetElNull = true;
            }
            else {
                objParent = this.targetEl.parentNode;
                this.isTargetElNull = false;
            }
            //insert a new 0px height element before specified target that can be used to determine when page is scrolled
            const objBackToTopTargetEl = document.createElement("div");
            objBackToTopTargetEl.setAttribute("id", "ic-back-to-top-target");
            objBackToTopTargetEl.setAttribute("tabindex", "-1"); // Needed for virtual cursor behaviour to work
            objParent.insertBefore(objBackToTopTargetEl, this.targetEl);
            // resize observer needs to factor in any top margin on the target el
            const marginTop = getComputedStyle(this.targetEl).marginTop;
            this.topObserver = new IntersectionObserver(this.targetElObserverCallback, {
                threshold: [0],
                rootMargin: `${marginTop} 0px 0px 0px`,
            });
            this.topObserver.observe(objBackToTopTargetEl);
        };
        this.handleClick = () => {
            if (this.isTargetElNull) {
                window.scrollTo(0, 0);
            }
            else {
                this.targetEl.scrollIntoView();
            }
            // Get virtual cursor to move
            this.getObservedEl().focus();
        };
        this.checkForClassificationBanner = () => {
            //adjust position for classification banner at bottom
            const banners = document.querySelectorAll("ic-classification-banner:not([inline='true'])");
            this.bannerOffset = banners.length > 0;
        };
        this.buildButton = () => {
            const { bannerOffset, targetElVisible, footerVisible, variant } = this;
            return (index.h("button", { class: {
                    ["ic-back-to-top-link"]: true,
                    ["offset-banner"]: bannerOffset,
                    ["show"]: !targetElVisible,
                    ["by-footer"]: footerVisible,
                    ["positioning"]: variant !== "icon",
                    ["icon-only"]: variant === "icon",
                }, "aria-label": backToTopLabel, onClick: this.handleClick }, index.h("span", { class: "ic-back-to-top-icon", innerHTML: ArrowUpward }), this.variant !== "icon" && (index.h("ic-typography", { variant: "subtitle-small" }, index.h("span", null, backToTopLabel)))));
        };
        this.bannerOffset = false;
        this.footerVisible = false;
        this.targetElVisible = true;
        this.target = undefined;
        this.variant = "default";
    }
    watchPropHandler(newValue, oldValue) {
        //added for gatsby rehydration issue where prop is initially undefined but then changes to actual value
        helpers.onComponentPropUndefinedChange(oldValue, newValue, () => {
            this.createTopObserver(newValue);
        });
    }
    componentWillLoad() {
        this.createTopObserver(this.target);
        this.checkForClassificationBanner();
        //observer for when footer scrolls into view
        let footers = document.querySelectorAll("ic-footer");
        if (footers.length === 0) {
            footers = document.querySelectorAll("footer");
        }
        if (footers.length) {
            const footerEl = footers[footers.length - 1];
            const threshold = this.bannerOffset ? 0.15 : 0;
            const footerObserver = new IntersectionObserver(this.footerObserverCallback, { threshold: [threshold] });
            footerObserver.observe(footerEl);
        }
    }
    componentDidLoad() {
        helpers.onComponentRequiredPropUndefined([{ prop: this.target, propName: "target" }], "Back to Top");
    }
    render() {
        const { variant, buildButton } = this;
        return variant === "icon" ? (index.h("ic-tooltip", { label: backToTopLabel, placement: "top", class: "positioning" }, buildButton())) : (buildButton());
    }
    static get delegatesFocus() { return true; }
    get el() { return index.getElement(this); }
    static get watchers() { return {
        "target": ["watchPropHandler"]
    }; }
};
BackToTop.style = icBackToTopCss;

exports.ic_back_to_top = BackToTop;

//# sourceMappingURL=ic-back-to-top.cjs.entry.js.map