'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
const types = require('./types-dc22e301.js');

const icDividerCss = "hr.sc-ic-divider{padding:0;margin:0;border:none;height:var(--ic-space-1px);background-color:var(--ic-keyline-darken-rgb)}hr.light.sc-ic-divider{background-color:var(--ic-keyline-lighten-rgb)}";

const Divider = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.foregroundColor = helpers.getThemeForegroundColor();
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    render() {
        return (index.h(index.Host, { "aria-hidden": "true" }, index.h("hr", { class: {
                ["light"]: this.foregroundColor === types.IcThemeForegroundEnum.Light,
            } })));
    }
};
Divider.style = icDividerCss;

exports.ic_divider = Divider;

//# sourceMappingURL=ic-divider.cjs.entry.js.map