'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
require('./types-dc22e301.js');

const icEmptyStateCss = ":host{gap:var(--ic-space-xs);padding:var(--ic-space-xs)}:host,.action-area{display:flex;flex-direction:column}.action-area{gap:var(--ic-space-md)}:host ::slotted(svg),:host ::slotted(img){border-radius:var(--ic-space-xxs)}:host(.right),:host(.right) .action-area{align-items:flex-end;text-align:right}:host(.center),:host(.center) .action-area{align-items:center;text-align:center}:host(.image-default) ::slotted(svg),:host(.image-default) ::slotted(img){height:calc(3 * var(--ic-space-lg)) !important;width:calc(3 * var(--ic-space-lg)) !important}:host(.image-small) ::slotted(svg),:host(.image-small) ::slotted(img){height:var(--ic-space-xxl) !important;width:var(--ic-space-xxl) !important}:host(.image-large) ::slotted(svg),:host(.image-large) ::slotted(img){height:calc(4 * var(--ic-space-xl)) !important;width:calc(4 * var(--ic-space-xl)) !important}";

const EmptyState = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.hostMutationObserver = null;
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? helpers.checkSlotInChildMutations(addedNodes, removedNodes, [
                    "image",
                    "actions",
                ])
                : false)) {
                index.forceUpdate(this);
            }
        };
        this.aligned = "left";
        this.body = undefined;
        this.bodyMaxLines = undefined;
        this.heading = undefined;
        this.imageSize = "default";
        this.subheading = undefined;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentDidLoad() {
        !helpers.isSlotUsed(this.el, "heading") &&
            helpers.onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Empty State");
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    render() {
        const { aligned, body, bodyMaxLines, heading, imageSize, subheading } = this;
        return (index.h(index.Host, { class: {
                [`${aligned}`]: true,
                [`image-${imageSize}`]: helpers.isSlotUsed(this.el, "image"),
            } }, helpers.isSlotUsed(this.el, "image") && index.h("slot", { name: "image" }), index.h("div", null, index.h("slot", { name: "heading" }, index.h("ic-typography", { variant: "h4" }, heading)), index.h("slot", { name: "subheading" }, index.h("ic-typography", { variant: "subtitle-small" }, subheading)), index.h("slot", { name: "body" }, index.h("ic-typography", { maxLines: bodyMaxLines }, body))), helpers.isSlotUsed(this.el, "actions") && (index.h("div", { class: "action-area" }, index.h("slot", { name: "actions" })))));
    }
    get el() { return index.getElement(this); }
};
EmptyState.style = icEmptyStateCss;

exports.ic_empty_state = EmptyState;

//# sourceMappingURL=ic-empty-state.cjs.entry.js.map