'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
const types = require('./types-dc22e301.js');

const icFooterCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block;--footer-compliance-padding:1rem 0}:host(.footer-sparse){--footer-links-padding:1.5rem 0;--footer-logo-margin-bottom:var(--ic-space-lg);--footer-link-inner-flex-direction:row}:host(.footer-small){--footer-links-padding:0 0;--footer-logo-margin-bottom:var(--ic-space-md);--footer-link-inner-flex-direction:column}:host(.footer-light){--footer-theme-secondary:var(--ic-theme-secondary);--footer-theme-tertiary:var(--ic-theme-tertiary);--footer-keyline:var(--ic-keyline-lighten)}:host(.footer-dark){--footer-theme-secondary:var(--ic-theme-secondary-light);--footer-theme-tertiary:var(--ic-theme-tertiary-light);--footer-keyline:var(--ic-keyline-darken)}:host(.footer-small.footer-ungrouped){--footer-links-padding:var(--ic-space-md) 0 0 0}footer{display:flex;flex-direction:column;width:100%}.footer-description{background-color:var(--footer-theme-secondary);color:var(--ic-theme-text);border-bottom:var(--footer-keyline)}.footer-description-inner{padding:1rem 0}.footer-links{padding:var(--footer-links-padding);background-color:var(--footer-theme-secondary);color:var(--ic-theme-text)}.footer-links-inner{display:flex;flex-direction:var(--footer-link-inner-flex-direction)}.footer-compliance{background-color:var(--footer-theme-tertiary);color:var(--ic-theme-text)}.footer-compliance-inner{padding:var(--footer-compliance-padding)}.footer-logo{margin-bottom:var(--footer-logo-margin-bottom);display:flex;gap:var(--ic-space-xxl)}.footer-logo>::slotted(){margin-right:var(--ic-space-md)}.footer-caption{margin-bottom:var(--ic-space-md)}.classification-spacing{margin-bottom:var(--ic-space-lg)}@media (forced-colors: active){footer{border-top:var(--ic-hc-border)}}";

const Footer = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.footerResized = index.createEvent(this, "footerResized", 7);
        this.resizeObserver = null;
        this.resizeObserverCallback = (currSize) => {
            if (currSize !== this.deviceSize) {
                this.deviceSize = currSize;
            }
            this.footerResized.emit();
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                const currSize = helpers.getCurrentDeviceSize();
                this.resizeObserverCallback(currSize);
            });
            this.resizeObserver.observe(this.footerEl);
        };
        this.deviceSize = helpers.IC_DEVICE_SIZES.XL;
        this.foregroundColor = helpers.getThemeForegroundColor();
        this.aligned = "left";
        this.breakpoint = "medium";
        this.caption = undefined;
        this.copyright = true;
        this.description = undefined;
        this.groupLinks = false;
    }
    disconnectedCallback() {
        if (this.resizeObserver !== null) {
            this.resizeObserver.disconnect();
        }
    }
    componentWillLoad() {
        this.deviceSize = helpers.getCurrentDeviceSize();
    }
    componentDidLoad() {
        helpers.checkResizeObserver(this.runResizeObserver);
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    isSmall() {
        const bp = this.breakpoint;
        return bp === "extra small"
            ? this.deviceSize < helpers.IC_DEVICE_SIZES.XS
            : bp === "small"
                ? this.deviceSize < helpers.IC_DEVICE_SIZES.S
                : bp === "medium"
                    ? this.deviceSize < helpers.IC_DEVICE_SIZES.M
                    : bp === "large"
                        ? this.deviceSize < helpers.IC_DEVICE_SIZES.L
                        : bp === "extra large"
                            ? this.deviceSize < helpers.IC_DEVICE_SIZES.XL
                            : false;
    }
    render() {
        const { aligned, caption, copyright, description, groupLinks, foregroundColor, } = this;
        const small = this.isSmall();
        return (index.h(index.Host, { class: {
                footer: true,
                [`footer-${small ? "small" : "sparse"}`]: true,
                [`footer-${groupLinks ? "grouped" : "ungrouped"}`]: true,
                [`footer-${foregroundColor}`]: true,
                // Slots will be able to infer their own color
                [types.IcThemeForegroundEnum.Dark]: foregroundColor === types.IcThemeForegroundEnum.Dark,
                [types.IcThemeForegroundEnum.Light]: foregroundColor === types.IcThemeForegroundEnum.Light,
            } }, index.h("footer", { ref: (footerEl) => (this.footerEl = footerEl) }, (helpers.isSlotUsed(this.el, "description") || description) && (index.h("div", { class: "footer-description" }, index.h("ic-section-container", { aligned: aligned, fullHeight: true }, index.h("div", { class: "footer-description-inner" }, index.h("ic-typography", { variant: "body" }, index.h("slot", { name: "description" }, description)))))), helpers.isSlotUsed(this.el, "link") && (index.h("div", { class: "footer-links" }, groupLinks && small ? (index.h("div", { class: "footer-links-inner", role: "list" }, index.h("slot", { name: "link" }))) : (index.h("ic-section-container", { fullHeight: true, aligned: aligned }, index.h("div", { class: "footer-links-inner", role: "list" }, index.h("slot", { name: "link" })))))), index.h("div", { class: "footer-compliance" }, index.h("ic-section-container", { aligned: aligned, fullHeight: true }, index.h("div", { class: "footer-compliance-inner" }, helpers.isSlotUsed(this.el, "logo") && (index.h("div", { class: "footer-logo" }, index.h("slot", { name: "logo" }))), (helpers.isSlotUsed(this.el, "caption") || caption) && (index.h("div", { class: "footer-caption" }, index.h("ic-typography", { variant: this.deviceSize <= helpers.IC_DEVICE_SIZES.M
                ? "caption"
                : "body" }, index.h("slot", { name: "caption" }, caption)))), copyright && (index.h("div", { class: {
                ["footer-copyright"]: true,
                ["classification-spacing"]: helpers.hasClassificationBanner(),
            } }, index.h("ic-typography", { variant: this.deviceSize <= helpers.IC_DEVICE_SIZES.M
                ? "caption-uppercase"
                : "label-uppercase" }, "\u00A9 Crown Copyright")))))))));
    }
    get el() { return index.getElement(this); }
};
Footer.style = icFooterCss;

exports.ic_footer = Footer;

//# sourceMappingURL=ic-footer.cjs.entry.js.map