'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
const types = require('./types-dc22e301.js');

const icInputLabelCss = "ic-input-label{margin-bottom:var(--ic-space-xs)}ic-input-label.with-helper{margin-bottom:var(--ic-space-xxxs)}ic-input-label.readonly{color:var(--ic-color-tertiary-text)}ic-input-label .helpertext{margin-top:var(--ic-space-xxxs)}ic-input-label .helpertext-normal{color:var(--ic-color-secondary-text)}ic-input-label .helpertext-readonly{color:var(--ic-color-tertiary-text)}ic-input-label .readonly-label{color:var(--ic-color-secondary-text)}ic-input-label .error-label{color:var(--ic-status-error)}ic-input-label .dark{color:var(--ic-architectural-white)}";

const InputLabel = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.appearance = "default";
        this.dark = false;
        this.disabled = false;
        this.error = false;
        this.for = undefined;
        this.helperText = "";
        this.label = undefined;
        this.readonly = false;
        this.required = false;
    }
    componentDidLoad() {
        helpers.onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Input Label");
    }
    render() {
        const { disabled, readonly, label, required, helperText, error, dark, appearance, } = this;
        const labelText = required ? label + " *" : label;
        const labelContent = readonly ? (`${labelText}`) : (index.h("label", { htmlFor: this.for }, labelText));
        const id = helpers.getInputHelperTextID(this.for);
        return (index.h(index.Host, { class: {
                ["disabled"]: disabled,
                ["readonly"]: readonly,
                ["with-helper"]: helperText !== "",
            } }, index.h("ic-typography", { variant: "label", class: {
                ["readonly-label"]: readonly,
                ["error-label"]: error && !(readonly || disabled),
                ["dark"]: dark || appearance === "dark",
            } }, labelContent), helperText !== "" && (index.h("ic-typography", { variant: "caption", class: {
                ["helpertext"]: true,
                ["helpertext-normal"]: !disabled && !readonly,
                ["helpertext-readonly"]: readonly,
            } }, index.h("span", { id: id }, helperText)))));
    }
};
InputLabel.style = icInputLabelCss;

const icInputValidationCss = "ic-input-validation{width:var(--input-width, 20rem);margin-top:var(--ic-space-xs);display:flex}ic-input-validation.fullwidth{width:100%}ic-input-validation span.status-icon{padding-right:var(--ic-space-xxs)}ic-input-validation span.status-icon>svg{height:1.25rem;width:1.25rem}ic-input-validation span.icon-success>svg{fill:var(--ic-status-success)}ic-input-validation span.icon-error>svg{fill:var(--ic-status-error)}ic-input-validation span.icon-warning>svg{fill:var(--ic-status-warning)}ic-input-validation .statustext{flex-grow:1}";

const icon = {
    [types.IcInformationStatus.Warning]: helpers.warningIcon,
    [types.IcInformationStatus.Error]: helpers.errorIcon,
    [types.IcInformationStatus.Success]: helpers.successIcon,
};
const InputValidation = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.ariaLiveMode = "polite";
        this.for = undefined;
        this.fullWidth = false;
        this.message = undefined;
        this.status = "";
    }
    componentDidLoad() {
        helpers.onComponentRequiredPropUndefined([{ prop: this.message, propName: "message" }], "Input Validation");
    }
    render() {
        const displayIcon = this.status !== "" ? icon[this.status] : "";
        const id = helpers.getInputValidationTextID(this.for);
        return (index.h(index.Host, { class: {
                [this.status]: this.status !== "",
                ["fullwidth"]: this.fullWidth,
            } }, displayIcon !== "" && (index.h("span", { class: {
                ["status-icon"]: true,
                [`icon-${this.status}`]: true,
            }, innerHTML: displayIcon })), index.h("ic-typography", { variant: "caption", class: "statustext" }, index.h("span", { "aria-live": this.ariaLiveMode, id: id }, this.message)), index.h("slot", { name: "validation-message-adornment" })));
    }
    get el() { return index.getElement(this); }
};
InputValidation.style = icInputValidationCss;

exports.ic_input_label = InputLabel;
exports.ic_input_validation = InputValidation;

//# sourceMappingURL=ic-input-label_2.cjs.entry.js.map