'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
const checkIcon = require('./check-icon-7225d79b.js');
const chevronIcon = require('./chevron-icon-3bf07531.js');
require('./types-dc22e301.js');

const icMenuItemCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}li{list-style:none;padding:0}:host ::part(button){color:var(--ic-color-primary-text);padding:calc(var(--ic-space-xxxs) / 2);display:flex;align-items:flex-start;gap:var(--ic-space-xs);border-radius:0;min-height:2.5rem;height:auto}.focus-border{display:flex;align-items:flex-start;gap:var(--ic-space-xs);border-radius:var(--ic-border-radius);margin:calc(var(--ic-space-xxxs) / 2);padding:var(--ic-space-xxs);border:var(--ic-space-xxxs) dashed transparent;--icon-height:auto}:host(.disabled) ::part(button){color:var(--ic-architectural-200) !important;pointer-events:none}:host(.disabled) .menu-item-label,:host(.disabled) .shortcut,:host(.disabled) .menu-item-description{color:var(--ic-architectural-200) !important}:host([variant=\"destructive\"]) ::part(button){color:var(--ic-action-destructive)}:host ::part(button):hover{background-color:var(--ic-action-dark-bg-hover)}:host ::part(button):focus-visible,:host ::part(button):focus{color:var(--ic-color-white-text);background-color:var(--ic-focus-blue);box-shadow:none}:host(.disabled) ::part(button):focus-visible,:host(.disabled) ::part(button):focus{color:var(--ic-theme-lighten-40) !important}:host([variant=\"destructive\"]) ::part(button):focus-visible,:host([variant=\"destructive\"]) ::part(button):focus{background-color:var(--ic-action-destructive)}ic-button:focus-within .menu-item-label,ic-button:focus-within .shortcut,ic-button:focus-within .menu-item-description{color:var(--ic-color-white-text)}:host(.disabled) ic-button:focus-within .focus-border{border-color:var(--ic-architectural-white)}:host(.disabled) ic-button:focus-within .menu-item-label,:host(.disabled) ic-button:focus-within .shortcut,:host(.disabled) ic-button:focus-within .menu-item-description{color:var(--ic-theme-lighten-40) !important}:host ::part(button):active{background-color:var(--ic-action-dark-bg-active);color:var(--ic-color-primary-text) !important}:host([variant=\"destructive\"]) ::part(button):active{background-color:var(--ic-action-dark-bg-active);color:var(--ic-action-destructive) !important}.menu-item-info{display:flex;flex-direction:column;flex:1;align-items:baseline;white-space:pre-line;text-align:left}.menu-labels{display:flex;align-items:baseline;gap:var(--ic-space-xs)}.menu-item-description{color:var(--ic-color-secondary-text)}.shortcut{color:var(--ic-color-tertiary-text);display:flex;flex:min-content}:host([variant=\"destructive\"]) .menu-item-label{text-transform:uppercase;font-weight:600;letter-spacing:0.025em}ic-button:active .menu-item-label{color:var(--ic-color-primary-text)}ic-button:active .menu-item-description{color:var(--ic-color-secondary-text)}ic-button:active .shortcut{color:var(--ic-color-tertiary-text)}:host([variant=\"destructive\"]) ic-button:active .menu-item-label{color:var(--ic-action-destructive) !important}.icon,.check-icon,.submenu-icon,.icon ::slotted(svg),.check-icon svg,.submenu-icon svg{width:var(--ic-space-lg);height:var(--ic-space-lg)}.check-icon.hide{visibility:hidden}@media (forced-colors: active){:host ::part(button){border:canvas}:host ::part(button):focus-visible{outline:var(--ic-space-xxxs) solid transparent}.focus-border{border-color:canvas}:host(.disabled) ic-button:focus-within .focus-border{border-color:GrayText}:host(.disabled) .menu-item-info,:host(.disabled) .menu-item-label,:host(.disabled) .shortcut,:host(.disabled) .menu-item-description,:host(.disabled) ic-button:focus-within .menu-item-info,:host(.disabled) ic-button:focus-within .menu-item-label,:host(.disabled) ic-button:focus-within .shortcut,:host(.disabled) ic-button:focus-within .menu-item-description{color:GrayText !important}:host(.disabled) ::part(button):focus-visible,:host(.disabled) ::part(button):focus{outline-color:GrayText !important}}";

const MenuItem = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.childBlur = index.createEvent(this, "childBlur", 7);
        this.handleMenuItemClick = index.createEvent(this, "handleMenuItemClick", 7);
        this.triggerPopoverMenuInstance = index.createEvent(this, "triggerPopoverMenuInstance", 7);
        this.handleClick = (e) => {
            if (helpers.isPropDefined(this.submenuTriggerFor)) {
                this.triggerPopoverMenuInstance.emit();
            }
            else if (this.variant === "toggle") {
                e.preventDefault();
                this.toggleChecked = !this.toggleChecked;
            }
            this.handleMenuItemClick.emit({
                label: this.label,
                hasSubMenu: !!this.el.submenuTriggerFor,
            });
        };
        this.getMenuItemAriaLabel = () => {
            let ariaLabel = this.label;
            if (helpers.isPropDefined(this.description)) {
                ariaLabel = `${ariaLabel}, ${this.description}`;
            }
            if (helpers.isPropDefined(this.keyboardShortcut)) {
                ariaLabel = `${ariaLabel}, ${this.keyboardShortcut}`;
            }
            if (this.variant === "destructive") {
                ariaLabel = `${ariaLabel}, destructive`;
            }
            if (helpers.isPropDefined(this.submenuTriggerFor)) {
                ariaLabel = `${ariaLabel}, triggers submenu`;
            }
            if (this.el.classList.contains("ic-popover-submenu-back-button")) {
                ariaLabel = "Go back to parent menu";
            }
            const parentEl = this.el.parentElement;
            if (parentEl.tagName === "IC-MENU-GROUP" &&
                parentEl.label) {
                return `${ariaLabel}, ${parentEl.label} menu group`;
            }
            else {
                return ariaLabel;
            }
        };
        this.toggleChecked = false;
        this.description = undefined;
        this.disabled = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.keyboardShortcut = undefined;
        this.label = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.submenuTriggerFor = undefined;
        this.target = undefined;
        this.variant = "default";
    }
    componentWillLoad() {
        // This ensures that trigger menu items are always set to the default variant
        if (helpers.isPropDefined(this.submenuTriggerFor) && this.variant !== "default") {
            this.variant = "default";
        }
        helpers.removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        helpers.onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Menu Item");
    }
    handleHostClick(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
    }
    render() {
        // A sub-component to layout the menu information correctly in ic-button
        const MenuItemInformation = () => {
            return (index.h("div", { class: "menu-item-info" }, index.h("div", { class: "menu-labels" }, index.h("ic-typography", { class: "menu-item-label" }, this.label), this.keyboardShortcut && (index.h("ic-typography", { variant: "caption", class: "shortcut" }, this.keyboardShortcut))), this.description && (index.h("ic-typography", { class: "menu-item-description", variant: "caption" }, this.description))));
        };
        return (index.h(index.Host, { class: {
                ["disabled"]: this.disabled,
            } }, index.h("li", { role: this.variant === "toggle" ? "menuitemcheckbox" : "menuitem", "aria-disabled": `${this.disabled}`, "aria-checked": this.variant === "toggle" ? this.toggleChecked : undefined }, index.h("ic-button", { fullWidth: true, variant: "tertiary", onClick: this.handleClick, href: helpers.isPropDefined(this.href), hreflang: helpers.isPropDefined(this.hreflang), target: helpers.isPropDefined(this.target), rel: helpers.isPropDefined(this.rel), referrerpolicy: this.referrerpolicy !== undefined ? this.referrerpolicy : null, "aria-disabled": `${this.disabled}`, "aria-label": this.getMenuItemAriaLabel(), ariaControlsId: helpers.isPropDefined(this.submenuTriggerFor)
                ? `ic-popover-submenu-${this.submenuTriggerFor}`
                : false, "aria-haspopup": helpers.isPropDefined(this.submenuTriggerFor) ||
                this.el.classList.contains("ic-popover-submenu-back-button")
                ? "menu"
                : false, ariaOwnsId: helpers.isPropDefined(this.submenuTriggerFor)
                ? `ic-popover-submenu-${this.submenuTriggerFor}`
                : false }, index.h("div", { class: "focus-border" }, helpers.isSlotUsed(this.el, "icon") && (index.h("span", { class: "icon" }, index.h("slot", { name: "icon" }))), index.h(MenuItemInformation, null), this.variant === "toggle" && (index.h("span", { class: {
                ["check-icon"]: true,
                ["hide"]: !this.toggleChecked,
            }, "aria-hidden": "true", innerHTML: checkIcon.Check })), helpers.isPropDefined(this.submenuTriggerFor) && (index.h("span", { class: { ["submenu-icon"]: true }, "aria-hidden": "true", innerHTML: chevronIcon.Chevron })))))));
    }
    static get delegatesFocus() { return true; }
    get el() { return index.getElement(this); }
};
MenuItem.style = icMenuItemCss;

exports.ic_menu_item = MenuItem;

//# sourceMappingURL=ic-menu-item.cjs.entry.js.map