'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
const chevronIcon = require('./chevron-icon-3bf07531.js');
const OpenInNew = require('./OpenInNew-d5d30e77.js');
require('./types-dc22e301.js');

const icNavigationItemCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block}:host(:focus-within){z-index:var(--ic-z-index-navigation-item)}svg{width:var(--ic-space-xl);fill:var(--ic-theme-text)}.svg{margin-left:auto}.chevron-container svg,.chevron-container .svg{width:var(--ic-space-lg);height:var(--ic-space-lg)}.chevron-container{flex-grow:1}:host(.expandable.navigation-item) .link,:host(.expandable.navigation-item) ::slotted(a){padding-right:0}:host(.navigation-item) .link,:host(.navigation-item) ::slotted(a){height:calc(100% - var(--ic-space-xxs));width:-moz-fit-content;width:fit-content;color:var(--ic-theme-text);display:flex;align-items:center;justify-content:center;padding:0 var(--ic-space-md) var(--ic-space-xxs);text-decoration:none;transition:var(--ic-easing-transition-fast);position:relative;white-space:nowrap}:host(.navigation-item) ::slotted(a){height:100%;font:var(--ic-font-label) !important;letter-spacing:var(--ic-font-letter-spacing-0pt025) !important;padding:0 var(--ic-space-md) !important}:host(.navigation-item-selected) .link::after,:host(.navigation-item-selected) ::slotted(a.active)::after,:host(.navigation-item-top-nav) ::slotted(a.active)::after{content:\"\";height:0.25rem;width:100%;position:absolute;bottom:0;background-color:var(--ic-theme-text)}:host(.navigation-item-selected.navigation-item-page-header) ::slotted(a.active)::after,:host(.navigation-item-selected.navigation-item-page-header) .link::after,:host(.navigation-item.navigation-item-page-header) ::slotted(a.active)::after,:host(.navigation-item-top-nav-child) ::slotted(a.active)::after{content:none}:host(.navigation-item-side-menu-selected) .link,:host(.navigation-item-side-menu) ::slotted(a.active),:host(.navigation-item-top-nav-child) ::slotted(a.active){box-shadow:none}:host(.navigation-item) .link:hover:not(:focus){background-color:var(--ic-theme-hover);cursor:pointer}:host(.navigation-item:not(.navigation-item-page-header,.navigation-item-side-menu)) ::slotted(a:hover:not(:focus)){background-color:var(--ic-theme-hover) !important}:host(.navigation-item:not(.navigation-item-top-nav-child,.navigation-item-side-menu,.navigation-item-top-nav-child-selected .navigation-item-side-menu-selected)) .focus-indicator:focus-within{box-shadow:var(--ic-border-focus);border-radius:var(--ic-border-radius)}:host(.navigation-item) .link:focus,:host(.navigation-item) ::slotted(a:focus){box-shadow:var(--ic-border-focus);border-radius:var(--ic-border-radius);outline:var(--ic-hc-focus-outline)}:host(.navigation-item-selected) .link:focus,:host(.navigation-item) ::slotted(a.active:focus){box-shadow:var(--ic-border-focus);border-radius:var(--ic-border-radius);outline:var(--ic-hc-focus-outline)}:host(.navigation-item-selected.dark) .link:focus,:host(.navigation-item.dark) ::slotted(a.active:focus){box-shadow:var(--ic-border-focus);border-radius:var(--ic-border-radius);outline:var(--ic-hc-focus-outline)}:host(.navigation-item) .link:active:not(:focus),:host(.navigation-item) ::slotted(a:active:not(:focus)){background-color:var(--ic-theme-active)}:host(.navigation-item-side-menu) .link,:host(.navigation-item-side-menu) ::slotted(a){min-height:2.5rem;height:auto;width:100%;box-sizing:border-box;color:var(--ic-color-primary-text);display:flex;align-items:center;justify-content:flex-start;text-decoration:none;text-wrap:wrap;white-space:normal;transition:box-shadow var(--ic-transition-duration-fast),\n    border-radius var(--ic-transition-duration-fast)}:host(.navigation-item-side-menu) ::slotted(a){font:var(--ic-font-body) !important;letter-spacing:var(--ic-font-letter-spacing-0pt005) !important;transition:box-shadow var(--ic-easing-transition-fast),\n    background-color var(--ic-easing-transition-fast)}:host(.navigation-item-side-menu) .link:hover:not(:focus){background-color:var(--ic-action-dark-bg-hover)}:host(.navigation-item-side-menu) ::slotted(a:hover:not(:focus)){background-color:var(--ic-action-dark-bg-hover) !important}:host(.navigation-item-side-menu) .focus-indicator:focus-within{box-shadow:none}:host(.navigation-item-side-menu) .link:focus,:host(.navigation-item-side-menu) ::slotted(a:focus){box-shadow:var(--ic-border-focus-inset) !important;width:auto;border-radius:var(--ic-border-radius-inset) !important}:host(.navigation-item-side-menu-selected) .link,:host(.navigation-item-side-menu-selected) ::slotted(a){transition:box-shadow var(--ic-easing-transition-slow),\n    background-color var(--ic-easing-transition-slow)}:host(.navigation-item-side-menu-selected) .link:focus,:host(.navigation-item-side-menu) ::slotted(a.active:focus),:host(.navigation-item-top-nav-child) ::slotted(a.active:focus){margin-left:var(--ic-space-xs) !important;padding-left:var(--ic-space-xs) !important}:host(.navigation-item-top-nav-child) .link,:host(.navigation-item-top-nav-child) ::slotted(a){height:2.5rem;width:-moz-fit-content;width:fit-content;min-width:9.063rem;color:var(--ic-color-primary-text);display:flex;align-items:center;justify-content:flex-start;padding:0 var(--ic-space-md) !important;text-decoration:none;position:relative;transition:box-shadow var(--ic-transition-duration-fast),\n    border-radius var(--ic-transition-duration-slow)}:host(.navigation-item-top-nav-child) ::slotted(a){font:var(--ic-font-body) !important;letter-spacing:var(--ic-font-letter-spacing-0pt005) !important}:host(.navigation-item-top-nav-child) .link:hover:not(:focus){background-color:var(--ic-action-dark-bg-hover) !important}:host(.navigation-item-top-nav-child) ::slotted(a:hover):not(:focus){background-color:var(--ic-action-dark-bg-hover) !important}:host(.navigation-item-top-nav-child) .link:focus,:host(.navigation-item-top-nav-child) ::slotted(a:focus){z-index:1;outline:var(--ic-hc-focus-outline);border-radius:var(--ic-border-radius-inset);box-shadow:var(--ic-border-focus-inset);transition:border-radius 0s, box-shadow var(--ic-transition-duration-fast)}:host(.navigation-item-top-nav-child) ::slotted(a.active:focus){box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset)}:host(.navigation-item-side-menu) .link:active:not(:focus){background-color:var(--ic-action-dark-bg-active)}:host(.navigation-item-top-nav-child) .link:active:not(:focus),:host(.navigation-item-top-nav-child) ::slotted(a:active):not(:focus){outline:var(--ic-hc-focus-outline);background-color:var(--ic-action-dark-bg-active)}:host(.navigation-item-top-nav-child) ::slotted(a:active):not(:focus),:host(.navigation-item-side-menu) ::slotted(a:active):not(:focus){background-color:var(--ic-action-dark-bg-active) !important}:host(.navigation-item-side-menu-selected) *,:host(.navigation-item-top-nav-child-selected) *,:host(.navigation-item-side-menu) ::slotted(a.active),:host(.navigation-item-top-nav-child) ::slotted(a.active){font-weight:700 !important}:host(.navigation-item-top-nav-child) ::slotted(a.active)::before,:host(.navigation-item-top-nav-child-selected) .link::before,:host(.navigation-item-side-menu-selected) .link::before,:host(.navigation-item-side-menu) ::slotted(a.active)::before,:host(.navigation-item-side-menu-selected) .link:focus::before,:host(.navigation-item-side-menu) ::slotted(a.active:focus)::before{content:\"\";position:absolute;left:0;width:var(--ic-space-xs);height:inherit;min-height:2.5rem;background-color:var(--ic-action-default);transition:left 0s}:host(.navigation-item-top-nav-child-selected) .link::before,:host(.navigation-item-side-menu-selected) .link::before,:host(.navigation-item-side-menu-selected) .link:focus::before{margin-top:0.25rem}:host(.navigation-item-top-nav-child-selected) .link:focus{margin-left:var(--ic-space-xs);margin-right:calc(-1 * var(--ic-space-xs));padding-left:var(--ic-space-xs) !important}:host(.navigation-item-top-nav-child-selected) .link:focus::before{left:calc(-1 * var(--ic-space-xs));z-index:1}:host(.navigation-item-side-menu-selected) .link::before,:host(.navigation-item-side-menu) ::slotted(a.active)::before,:host(.navigation-item-side-menu-selected) .link:focus::before,:host(.navigation-item-side-menu) ::slotted(a.active:focus)::before{z-index:1}:host(.navigation-item-side-menu-selected) .link:focus::before,:host(.navigation-item-side-menu) ::slotted(a.active:focus)::before,:host(.navigation-item-top-nav-child) ::slotted(a.active:focus)::before{left:calc(-1 * var(--ic-space-xs))}:host(.navigation-item-side-menu-selected) .link::after{display:none}:host(.navigation-item-side-nav-collapsed) .link{height:100%}:host(.navigation-item-side-nav-collapsed) ::slotted(svg),:host(.navigation-item-side-nav-collapsed-with-label) ::slotted(svg){margin:auto;pointer-events:none}:host(.navigation-item-side-nav-collapsed) .icon,:host(.navigation-item-side-nav-collapsed-with-label) .icon,:host(.navigation-item-side-nav-collapsed-with-label) ic-typography{align-items:center;padding:0;margin:auto 0;width:-moz-fit-content;width:fit-content;pointer-events:none}:host(.navigation-item-side-nav-collapsed-with-label) ic-typography{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;width:100%;text-align:center}:host(.navigation-item-side-nav-collapsed-with-label) .link,:host(.navigation-item-side-nav-collapsed-with-label) ::slotted(a){display:flex;flex-direction:column;height:-moz-fit-content;height:fit-content;padding:var(--ic-space-xs) !important;gap:var(--ic-space-xxs)}:host(.navigation-item-side-nav.navigation-item-side-nav-collapsed-with-label) .link,:host(.navigation-item-side-nav.navigation-item-side-nav-collapsed-with-label) ::slotted(a){height:auto !important;gap:0;width:auto;padding:var(--ic-space-xs) !important}:host(.navigation-item-side-nav.navigation-item-side-nav-collapsed-with-label) ::slotted(a){display:block;text-align:center}:host(.navigation-item-side-nav.navigation-item-side-nav-collapsed-with-label) .link ic-typography{opacity:1;min-width:-moz-min-content;min-width:min-content}:host(.navigation-item-side-nav-collapsed) svg,:host(.navigation-item-side-nav-collapsed-with-label) svg{display:none}::slotted(svg){fill:var(--ic-theme-text);width:var(--ic-space-lg);margin-left:var(--ic-space-md)}.icon{height:var(--ic-space-lg);width:var(--ic-space-xxl);margin-left:calc(-1 * var(--ic-space-md));flex:0 1 0%;position:relative}.icon>::slotted(*){margin-left:var(--ic-space-md) !important}:host(.navigation-item-side-nav-collapsed) .icon>::slotted(*){margin:auto !important}:host(.navigation-item-side-nav) .link,:host(.navigation-item-side-nav) ::slotted(a){height:var(--navigation-item-height, 56px);min-height:var(--navigation-item-min-height);width:var(--navigation-item-width, auto);justify-content:var(--navigation-item-justify-content);display:flex;gap:var(--ic-space-xs);box-sizing:border-box;color:var(--navigation-item-child-color) !important;text-decoration:none !important;white-space:nowrap;padding-top:var(--ic-space-md) !important;padding-bottom:var(--ic-space-md) !important;text-wrap:wrap}:host(.navigation-item-side-nav.navigation-item-top-nav-child) .link,:host(.navigation-item-side-nav.navigation-item-top-nav-child) ::slotted(a){height:var(--navigation-item-child-height);width:var(--navigation-group-width);color:var(--navigation-item-child-color) !important;display:flex;gap:0.625rem;box-sizing:border-box;min-width:0;transition:box-shadow var(--ic-easing-transition-fast);text-decoration:none !important;white-space:nowrap}:host(.navigation-item-side-nav.navigation-item-top-nav-child) .link:focus,:host(.navigation-item-side-nav.navigation-item-top-nav-child) ::slotted(a:focus){box-shadow:var(--ic-border-focus-dark)}:host(.navigation-item-side-nav.navigation-item-side-menu) .link:active{background-color:var(--navigation-item-child-active)}:host(.navigation-item-side-nav.navigation-item-top-nav-child) .link:active,:host(.navigation-item-side-nav.navigation-item-top-nav-child) ::slotted(a:active){background-color:var(--navigation-item-child-active)}:host(.navigation-item-side-nav) a.link ic-typography,:host(.navigation-item-side-nav.navigation-item-top-nav-child) a.link ic-typography,:host(.navigation-item-side-nav) div.link ic-typography,:host(.navigation-item-side-nav.navigation-item-top-nav-child) div.link ic-typography,.navigation-item-side-nav-slotted-text{opacity:var(--navigation-item-label-opacity);transition:opacity var(--ic-easing-transition-slow);white-space:wrap;text-overflow:ellipsis;overflow:hidden}:host(.navigation-item-side-nav.navigation-item-selected) .link,:host(.navigation-item-side-nav.navigation-item) ::slotted(a.active){box-shadow:inset 0.313rem 0 0 var(--ic-theme-text)}:host(.navigation-item-side-nav.navigation-item-selected) .link::before,:host(.navigation-item-side-nav) ::slotted(a.active)::before{content:\"\";display:block;position:absolute;inset:0 0 0 0.313rem;border-radius:0.688rem !important;transition:var(--ic-easing-transition-slow)}:host(.navigation-item-side-nav.navigation-item-selected) .link:focus::before,:host(.navigation-item-side-nav) ::slotted(a.active:focus)::before{box-shadow:var(--ic-border-focus-inset)}:host(:not(.navigation-item-side-nav-collapsed).navigation-item-side-nav.navigation-item-side-nav-collapsed-with-label) .link{opacity:var(--navigation-item-label-opacity);height:auto}:host(.navigation-item-top-nav-child.navigation-item-side-nav-collapsed-with-label) .link,:host(.navigation-item-top-nav-child.navigation-item-side-nav-collapsed-with-label) ::slotted(a){min-width:var(--navigation-group-item-min-width);padding:var(--ic-space-xs) !important;height:auto;gap:0}:host(.navigation-item-top-nav-child.navigation-item-side-nav-collapsed-with-label) ::slotted(a){display:block}:host(.navigation-item-side-nav.navigation-item-selected) .link::after,:host(.navigation-item-side-nav) ::slotted(a.active)::after{display:none}:host(.navigation-item-side-nav.navigation-item) .link:focus,:host(.navigation-item-side-nav.navigation-item) ::slotted(a:focus){box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset);background-color:transparent}:host(.navigation-item-side-nav.navigation-item-selected) .link:focus,:host(.navigation-item-side-nav) ::slotted(a.active:focus){margin:0 auto;box-shadow:inset 0.313rem 0 0 var(--ic-theme-text);border-radius:0}:host(.navigation-item-side-nav.navigation-item) .link:hover:not(:focus){background-color:var(--ic-theme-hover) !important}:host(.navigation-item-page-header).link,:host(.navigation-item-page-header) a,:host(.navigation-item-page-header) ::slotted(a){height:2.5rem !important;color:var(--ic-color-primary-text) !important;transition:all var(--ic-easing-transition-fast) !important;box-shadow:rgba(23 89 188 / 0%) !important}:host(.navigation-item-page-header.navigation-item-selected) .link::after,:host(.navigation-item-page-header) ::slotted(a.active)::after{content:\" \" !important;position:absolute;bottom:0;left:0;right:0;height:var(--ic-space-xxs);background-color:var(--ic-action-default) !important}:host(.navigation-item-page-header) .link:hover,:host(.navigation-item-page-header) ::slotted(.link:hover),:host(.navigation-item-page-header) ::slotted(a:hover),:host(.navigation-item-page-header) .link:hover:not(:focus){background-color:var(--ic-action-default-bg-hover) !important;cursor:pointer}:host(.navigation-item-page-header) .link:focus,:host(.navigation-item-page-header) ::slotted(a:focus){box-shadow:var(--ic-border-focus)}:host(.navigation-item-page-header) .link:active,:host(.navigation-item-page-header) ::slotted(a:active){background-color:var(--ic-action-default-bg-active) !important}:host(.navigation-item-page-header.navigation-item-selected) .link:focus::after,:host(.navigation-item-page-header) ::slotted(a.active:focus)::after{border-bottom-left-radius:var(--ic-border-radius);border-bottom-right-radius:var(--ic-border-radius)}:host(.navigation-item-page-header.navigation-item-selected.with-transition) .link,:host(.navigation-item-page-header.navigation-item-selected.with-transition) ::slotted(a.active){transition:all var(--ic-easing-transition-fast),\n    border-color var(--ic-transition-duration-fast)}:host(.navigation-item-page-header) ::slotted(a.active)::before,:host(.navigation-item-page-header) ::slotted(a.active:focus)::before,:host(.navigation-item-page-header.navigation-item-selected) .link:focus::before{display:none}.open-in-new-icon{flex:1}.open-in-new-icon svg{margin-top:var(--ic-space-xxs);padding-left:var(--ic-space-xxs)}:host(.navigation-item-side-nav) .open-in-new-icon{margin-left:calc(-1 * var(--ic-space-xs))}:host(.navigation-item-top-nav) .open-in-new-icon svg,:host(.navigation-item-page-header) .open-in-new-icon svg,:host(.navigation-item-side-nav) .open-in-new-icon svg{height:0.875rem;width:0.875rem}:host(.navigation-item-side-menu) .open-in-new-icon svg,:host(.navigation-item-top-nav-child) .open-in-new-icon svg{height:var(--ic-space-md);width:var(--ic-space-md)}:host(.navigation-item-page-header) .open-in-new-icon svg,:host(.navigation-item-top-nav-child) .open-in-new-icon svg,:host(.navigation-item-side-menu) .open-in-new-icon svg{fill:var(--ic-color-primary-text)}@media (forced-colors: active){.open-in-new-icon svg{fill:currentcolor}}";

const NavigationItem = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.childBlur = index.createEvent(this, "childBlur", 7);
        this.navItemClicked = index.createEvent(this, "navItemClicked", 7);
        this.isInitialRender = true;
        this.displayDefaultNavigationItem = (href, hreflang, target, rel, referrerpolicy, download, label) => {
            const variant = this.isTopNavChild || this.inTopNavSideMenu ? "body" : "label";
            const ChevronIconComponent = this.expandable && (index.h("div", { class: { svg: true }, innerHTML: chevronIcon.Chevron }));
            const IconComponent = this.el.querySelector('[slot="icon"]') && (index.h("div", { class: "icon" }, index.h("slot", { name: "icon" }), helpers.isSlotUsed(this.el, "badge") && index.h("slot", { name: "badge" })));
            if (href !== "") {
                return (index.h("a", { href: href, target: target, rel: rel, hreflang: hreflang, referrerPolicy: referrerpolicy, download: download !== false ? download : null, class: "link", ref: (el) => (this.itemEl = el), part: "link" }, IconComponent, index.h("ic-typography", { variant: variant }, label), index.h("div", { class: "chevron-container" }, ChevronIconComponent), target === "_blank" && (index.h("span", { class: "open-in-new-icon", innerHTML: OpenInNew.OpenInNew }))));
            }
            return (index.h("div", { tabindex: "0", class: "link", ref: (el) => (this.itemEl = el) }, IconComponent, index.h("ic-typography", { variant: variant }, label), ChevronIconComponent));
        };
        this.topNavResizedHandler = ({ detail, }) => {
            var _a;
            const { size } = detail;
            if (size !== this.deviceSize) {
                this.deviceSize = size;
                this.inTopNavSideMenu =
                    size <=
                        (((_a = this.parentEl) === null || _a === void 0 ? void 0 : _a.customMobileBreakpoint) || helpers.DEVICE_SIZES.L);
            }
        };
        this.sideNavExpandHandler = ({ detail, }) => {
            const { sideNavExpanded, sideNavMobile } = detail;
            this.sideNavExpanded = sideNavExpanded;
            this.isSideNavMobile = sideNavMobile;
        };
        this.handleBlur = ({ relatedTarget }) => {
            if (relatedTarget === null ||
                relatedTarget.tagName !== "IC-NAVIGATION-ITEM") {
                this.childBlur.emit();
            }
        };
        this.handleClick = () => {
            this.navItemClicked.emit();
        };
        this.generateTooltipLabel = () => {
            if (this.label) {
                return this.label;
            }
            if (this.navigationSlot) {
                return this.navigationSlot.textContent;
            }
            if (this.el.children[0]) {
                return this.el.children[0].textContent;
            }
            return "";
        };
        this.renderNavigationItemContent = () => {
            if (this.label) {
                return this.displayDefaultNavigationItem(this.href, this.hreflang, this.target, this.rel, this.referrerpolicy, this.download, this.label);
            }
            if (this.navigationSlot) {
                return index.h("slot", { name: "navigation-item" });
            }
            return index.h("slot", null);
        };
        this.deviceSize = helpers.DEVICE_SIZES.XL;
        this.focusStyle = helpers.getThemeForegroundColor();
        this.inTopNavSideMenu = false;
        this.isSideNavMobile = false;
        this.isTopNavChild = false;
        this.navigationType = undefined;
        this.parentEl = undefined;
        this.sideNavExpanded = false;
        this.collapsedIconLabel = false;
        this.displayNavigationTooltip = false;
        this.download = false;
        this.expandable = false;
        this.href = "";
        this.hreflang = undefined;
        this.label = undefined;
        this.rel = undefined;
        this.referrerpolicy = undefined;
        this.selected = false;
        this.target = undefined;
    }
    disconnectedCallback() {
        if (this.navigationType === "side") {
            this.parentEl.removeEventListener("sideNavExpanded", this.sideNavExpandHandler);
        }
        else if (this.navigationType === "top") {
            this.parentEl.removeEventListener("topNavResized", this.topNavResizedHandler);
        }
    }
    componentWillLoad() {
        const { navType, parent } = helpers.getNavItemParentDetails(this.el);
        this.navigationType = navType;
        this.parentEl = parent;
        this.deviceSize = helpers.getCurrentDeviceSize();
        if (this.navigationType === "side") {
            this.parentEl.addEventListener("sideNavExpanded", this.sideNavExpandHandler);
        }
        else if (this.navigationType === "top") {
            this.parentEl.addEventListener("topNavResized", this.topNavResizedHandler);
            if (this.el.parentElement.tagName === "IC-NAVIGATION-GROUP")
                this.isTopNavChild = true;
            if (this.deviceSize <=
                this.parentEl.customMobileBreakpoint)
                this.inTopNavSideMenu = true;
        }
        this.navigationSlot = this.el.querySelector('[slot="navigation-item"]');
        if (this.navigationSlot) {
            this.navigationSlot.ariaLabel = this.navigationSlot.textContent.trim();
        }
    }
    componentDidUpdate() {
        this.isInitialRender = false;
    }
    themeChangeHandler({ detail }) {
        this.focusStyle = detail.mode;
    }
    /**
     * Sets focus on the nav item.
     */
    async setFocus() {
        var _a;
        (_a = this.itemEl) === null || _a === void 0 ? void 0 : _a.focus();
    }
    render() {
        const { inTopNavSideMenu, isTopNavChild, selected } = this;
        return (index.h(index.Host, { class: {
                ["navigation-item"]: true,
                ["navigation-item-top-nav"]: !inTopNavSideMenu && this.navigationType === "top",
                ["navigation-item-top-nav-child-selected"]: isTopNavChild && !inTopNavSideMenu && selected,
                [this.focusStyle]: (!inTopNavSideMenu && !isTopNavChild) ||
                    (this.navigationType === "side" && isTopNavChild),
                ["navigation-item-selected"]: !isTopNavChild && selected,
                ["navigation-item-side-menu"]: inTopNavSideMenu,
                ["navigation-item-side-menu-selected"]: inTopNavSideMenu && selected,
                ["navigation-item-top-nav-child"]: isTopNavChild && !inTopNavSideMenu,
                ["navigation-item-page-header"]: this.navigationType === "page-header",
                ["with-transition"]: !this.isInitialRender,
                ["navigation-item-side-nav"]: this.navigationType === "side",
                ["navigation-item-side-nav-collapsed"]: (!this.sideNavExpanded || this.displayNavigationTooltip) &&
                    this.navigationType === "side",
                ["navigation-item-side-nav-collapsed-with-label"]: !this.sideNavExpanded &&
                    this.navigationType === "side" &&
                    this.collapsedIconLabel &&
                    !this.isSideNavMobile,
                ["expandable"]: this.expandable,
            }, onBlur: isTopNavChild && !inTopNavSideMenu ? this.handleBlur : null, onClick: this.handleClick, "aria-current": selected ? "page" : null, role: "listitem" }, index.h("ic-tooltip", { label: this.generateTooltipLabel(), target: "navigation-item", placement: "right", class: {
                ["tooltip-navigation-item"]: true,
                ["tooltip-navigation-item-side-nav-collapsed"]: (!this.sideNavExpanded || this.displayNavigationTooltip) &&
                    this.navigationType === "side",
                ["tooltip-long-label-navigation-item-side-nav-expanded"]: this.el.hasAttribute("[display-navigation-tooltip = 'true']"),
            } }, this.renderNavigationItemContent())));
    }
    static get delegatesFocus() { return true; }
    get el() { return index.getElement(this); }
};
NavigationItem.style = icNavigationItemCss;

exports.ic_navigation_item = NavigationItem;

//# sourceMappingURL=ic-navigation-item.cjs.entry.js.map