'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
require('./types-dc22e301.js');

const icPaginationItemCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}a{text-align:center}.item-container{display:flex;justify-content:center;align-items:center;width:calc(var(--ic-space-xl) + var(--ic-space-sm));height:var(--ic-space-xl);margin:var(--ic-space-xxs) var(--ic-space-xxxs);cursor:pointer;text-decoration:none}button{background:none;border:none;outline:inherit;position:relative}.ellipsis{pointer-events:none;color:var(--ic-color-secondary-text)}.item-container:focus{box-shadow:var(--ic-border-focus);outline:var(--ic-hc-focus-outline);border-radius:var(--ic-border-radius);transition:var(--ic-easing-transition-fast)}.page{color:var(--ic-action-default)}.simple-current{min-width:calc(var(--ic-space-xxl) + var(--ic-space-md));height:var(--ic-space-lg);cursor:default}.item-container.page:hover:not(.selected):not(:focus){border-radius:var(--ic-border-radius);background-color:var(--ic-action-default-bg-hover)}.item-container.page:active:not(.selected):not(:focus){background-color:var(--ic-action-default-bg-active)}.selected{pointer-events:none;outline:none}.selected::after{content:\"\";height:var(--ic-space-xxs);width:100%;position:absolute;bottom:0;background-color:var(--ic-action-default)}.page-selected{color:var(--ic-color-primary-text)}.item-container.page.light:hover:not(.selected):not(:focus){background-color:var(--ic-action-light-bg-hover)}.item-container.page.light:active:not(.selected):not(:focus){background-color:var(--ic-action-light-bg-active)}ic-typography.light{color:var(--ic-color-white-text)}.selected.light::after{content:\"\";height:var(--ic-space-xxs);width:100%;position:absolute;bottom:0;background-color:var(--ic-action-light)}.item-container.page.dark:hover:not(.selected):not(:focus){background-color:var(--ic-action-dark-bg-hover)}.item-container.page.dark:active:not(.selected):not(:focus){background-color:var(--ic-action-dark-bg-active)}ic-typography.dark{color:var(--ic-color-primary-text)}.selected.dark::after{content:\"\";height:var(--ic-space-xxs);width:100%;position:absolute;bottom:0;background-color:var(--ic-action-dark)}.disabled{color:var(--ic-architectural-200);pointer-events:none;cursor:none;-webkit-user-select:none;-moz-user-select:none;user-select:none}@media (forced-colors: active){.selected::after{background-color:Highlight}.selected.light::after{background-color:Highlight}.selected.dark::after{background-color:Highlight}.disabled{color:GrayText}}";

const PaginationItem = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.paginationItemClick = index.createEvent(this, "paginationItemClick", 7);
        this.handleClick = () => {
            this.paginationItemClick.emit({ page: this.page });
        };
        this.capitalizedLabel = undefined;
        this.appearance = "default";
        this.disabled = false;
        this.label = "Page";
        this.page = undefined;
        this.selected = false;
        this.type = undefined;
    }
    watchLabelHandler() {
        this.capitalizedLabel = helpers.capitalize(this.label);
    }
    componentWillLoad() {
        this.watchLabelHandler();
        helpers.removeDisabledFalse(this.disabled, this.el);
    }
    render() {
        const { page, selected, type, disabled, appearance, label, capitalizedLabel, } = this;
        return (index.h("a", null, type === "ellipsis" ? (index.h("div", { class: {
                ["item-container"]: true,
                ["ellipsis"]: true,
                ["disabled"]: disabled,
            } }, index.h("ic-typography", { class: {
                [`${appearance}`]: true,
            }, variant: "label" }, "..."))) : type === "page" ? (index.h("button", { disabled: disabled, onClick: this.handleClick, tabindex: selected ? "-1" : "0", role: "button", "aria-current": selected && "page", "aria-label": selected ? `${label}: ${page}` : `Go to ${label} ${page}`, class: {
                ["selected"]: !disabled && selected,
                ["disabled"]: disabled,
                ["item-container"]: true,
                [`${appearance}`]: true,
                ["page"]: type === "page",
            } }, index.h("ic-typography", { variant: "label", class: {
                ["page-selected"]: selected,
                ["disabled"]: disabled,
                [`${appearance}`]: true,
            } }, page))) : (index.h("ic-typography", { "aria-live": "polite", class: {
                [`simple-current ${appearance}`]: true,
                ["disabled"]: disabled,
            }, variant: "label" }, capitalizedLabel, " ", page))));
    }
    get el() { return index.getElement(this); }
    static get watchers() { return {
        "label": ["watchLabelHandler"]
    }; }
};
PaginationItem.style = icPaginationItemCss;

exports.ic_pagination_item = PaginationItem;

//# sourceMappingURL=ic-pagination-item.cjs.entry.js.map