'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
require('./types-dc22e301.js');

const icRadioOptionCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:flex;flex-direction:column;width:-moz-fit-content;width:fit-content}:host([additional-field-display=\"static\"]) ::slotted(ic-text-field){margin-top:calc(var(--ic-space-sm) / 2);margin-left:var(--ic-space-xl)}:host(.disabled){color:var(--ic-architectural-200)}.container input:focus+span.checkmark,:host(:focus) .container input:checked+span.checkmark{box-shadow:var(--ic-border-focus)}.container{display:grid;grid-template-columns:min-content auto;position:relative;cursor:pointer;align-items:center;margin:var(--ic-space-xxs) 0 var(--ic-space-xxs) var(--ic-space-xxs)}.container.disabled,.container.disabled input:disabled{cursor:default}.container input{-webkit-appearance:none;-moz-appearance:none;appearance:none;display:inline-block;position:absolute;cursor:pointer;height:var(--ic-space-lg);width:var(--ic-space-lg);border-radius:50%;border:none}.checkmark{display:block;position:relative;top:0;left:0;height:var(--ic-space-lg);width:var(--ic-space-lg);background-color:var(--ic-architectural-white);border:var(--ic-border-default);border-radius:50%;transition:var(--ic-easing-transition-fast);box-sizing:border-box}.container input:checked~.checkmark::after{display:inline-block}.container:hover input~.checkmark{background-color:var(--ic-action-default-bg-hover-no-alpha);box-shadow:0 0 0 0.25rem var(--ic-action-default-bg-hover);border:var(--ic-border-width) solid var(--ic-action-default)}.container:active input~.checkmark{background-color:var(--ic-action-default-bg-active-no-alpha);border:var(--ic-border-width) solid var(--ic-action-default-active);box-shadow:0 0 0 0.25rem var(--ic-action-default-bg-active)}.container:active input:checked~.checkmark{background-color:var(--ic-action-default-bg-active);border:0.125rem solid var(--ic-action-default-active);box-shadow:0 0 0 0.25rem var(--ic-action-default-bg-active)}.container:active input:checked~.checkmark::after{background-color:var(--ic-action-default-active)}.container input:checked~.checkmark{border:0.125rem solid var(--ic-action-default)}.container input:checked:disabled~.checkmark{background-color:var(--ic-architectural-white);border:0.125rem solid var(--ic-architectural-200)}.container input:disabled~.checkmark{border:var(--ic-border-width) dashed var(--ic-architectural-200)}.container input:disabled~.checkmark::after{background:var(--ic-architectural-200)}.container:hover input:disabled~.checkmark{background-color:var(--ic-architectural-white);box-shadow:none;border:0.125rem solid none}.container:active input:disabled~.checkmark::after{background-color:var(--ic-architectural-200)}.container .checkmark::after{content:\"\";position:absolute;display:none;top:calc(50% - var(--ic-space-xs));left:calc(50% - var(--ic-space-xs));width:var(--ic-space-md);height:var(--ic-space-md);border-radius:50%;background:var(--ic-action-default)}.radio-label{margin-left:var(--ic-space-md)}.additional-field-wrapper{margin-left:var(--ic-space-xs)}.branch-corner{color:var(--ic-action-default);height:var(--ic-space-md);width:var(--ic-space-xl);border-radius:0 0 0 0.188rem;border-bottom:0.125rem solid var(--ic-action-default);border-left:0.125rem solid var(--ic-action-default);margin-left:calc(-1 * var(--ic-space-1px))}.dynamic-container{display:flex;position:relative;margin:var(--ic-space-xxxs) 0 var(--ic-space-xxs) var(--ic-space-md);gap:var(--ic-space-xs)}.dynamic-container.hidden{display:none}.dynamic-text{color:var(--ic-action-default);margin-top:calc(var(--ic-space-sm) / 2);margin-bottom:var(--ic-space-xs);border-radius:2%}@media (max-width: 576px){::slotted(ic-text-field){--input-width:100%}}@media (forced-colors: active){.container input:checked~.checkmark,.container:active input:checked~.checkmark{border-color:Highlight}.container input:checked~.checkmark::after,.container:active input:checked~.checkmark::after{background-color:Highlight}.container input:disabled~.checkmark,.container input:checked:disabled~.checkmark{border-color:GrayText}.container input:disabled~.checkmark::after,.container:active input:disabled~.checkmark::after{background-color:GrayText}}";

const ADDITIONAL_FIELD = "additional-field";
const TEXT_FIELD_SELECTOR = "ic-text-field";
const RadioOption = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.icCheck = index.createEvent(this, "icCheck", 7);
        this.radioOptionSelect = index.createEvent(this, "radioOptionSelect", 7);
        this.icSelectedChange = index.createEvent(this, "icSelectedChange", 7);
        this.defaultRadioValue = "";
        this.hasAdditionalField = false;
        this.skipFocus = false;
        this.handleClick = () => {
            if (!this.disabled) {
                if (this.skipFocus === false) {
                    this.radioElement.focus();
                }
                this.skipFocus = false;
                if (this.hasAdditionalField) {
                    this.value =
                        this.el.querySelector(TEXT_FIELD_SELECTOR).value ||
                            this.defaultRadioValue;
                }
                this.icCheck.emit({
                    value: this.value,
                });
                this.radioOptionSelect.emit({
                    value: this.value,
                });
            }
        };
        this.swallowClick = (event) => {
            event.stopPropagation();
        };
        this.handleFormReset = () => {
            this.skipFocus = true;
            this.selected = this.initiallySelected;
        };
        this.additionalFieldDisplay = "static";
        this.disabled = false;
        this.dynamicText = "This selection requires additional answers";
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.groupLabel = undefined;
        this.label = undefined;
        this.name = undefined;
        this.value = undefined;
        this.selected = false;
        this.initiallySelected = this.selected;
    }
    watchSelectedHandler() {
        this.icSelectedChange.emit();
    }
    disconnectedCallback() {
        helpers.removeFormResetListener(this.el, this.handleFormReset);
    }
    componentWillLoad() {
        if (helpers.isSlotUsed(this.el, ADDITIONAL_FIELD)) {
            this.hasAdditionalField = true;
            const textField = this.el.querySelector(TEXT_FIELD_SELECTOR);
            if (textField)
                textField.hiddenInput = false;
        }
        this.defaultRadioValue = this.value;
        helpers.addFormResetListener(this.el, this.handleFormReset);
        helpers.removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        helpers.onComponentRequiredPropUndefined([{ prop: this.value, propName: "value" }], "Radio Option");
    }
    componentWillRender() {
        const hasSlot = helpers.isSlotUsed(this.el, ADDITIONAL_FIELD);
        if (hasSlot && !this.hasAdditionalField) {
            this.hasAdditionalField = true;
            const textField = this.el.querySelector(TEXT_FIELD_SELECTOR);
            if (textField)
                textField.hiddenInput = false;
        }
        else if (!hasSlot && this.hasAdditionalField) {
            this.hasAdditionalField = false;
        }
    }
    componentDidRender() {
        if (this.additionalFieldDisplay === "static") {
            const textfield = this.el.querySelector(TEXT_FIELD_SELECTOR);
            if (!this.selected || this.disabled) {
                textfield === null || textfield === void 0 ? void 0 : textfield.setAttribute("disabled", "");
            }
            else {
                textfield === null || textfield === void 0 ? void 0 : textfield.removeAttribute("disabled");
            }
        }
    }
    textfieldValueHandler(event) {
        if (this.selected) {
            this.value = event.detail.value || this.defaultRadioValue;
            this.icCheck.emit({
                value: this.value,
            });
            this.radioOptionSelect.emit({
                value: this.value,
            });
        }
        event.stopImmediatePropagation();
    }
    /**
     * Sets focus on the radio option.
     */
    async setFocus() {
        var _a;
        (_a = this.radioElement) === null || _a === void 0 ? void 0 : _a.focus();
    }
    /**
     * @internal Sets the tabIndex of the radio option.
     */
    async setTabIndex(value) {
        this.radioElement.tabIndex = value;
    }
    render() {
        const { additionalFieldDisplay, disabled, dynamicText, form, formaction, formenctype, formmethod, formnovalidate, formtarget, groupLabel, handleClick, hasAdditionalField, label, name, selected, swallowClick, value, } = this;
        const id = `ic-radio-option-${helpers.isPropDefined(label) || value}-${groupLabel}`;
        return (index.h(index.Host, { onClick: handleClick, class: { disabled } }, index.h("div", { class: { ["container"]: true, disabled } }, index.h("div", null, index.h("input", { role: "radio", tabindex: selected ? "0" : "-1", type: "radio", name: name, id: id, value: value, disabled: disabled ? true : null, checked: selected, ref: (el) => (this.radioElement = el), form: form, formaction: formaction, formenctype: formenctype, formmethod: formmethod, formnovalidate: formnovalidate, formtarget: formtarget }), index.h("span", { class: "checkmark" })), index.h("ic-typography", { class: "radio-label", variant: "body" }, index.h("label", { htmlFor: id }, label))), hasAdditionalField && (index.h("div", { onClick: swallowClick, class: {
                "dynamic-container": true,
                hidden: additionalFieldDisplay === "dynamic" && !selected,
            } }, additionalFieldDisplay === "dynamic" && (index.h("div", { class: "branch-corner" })), index.h("div", null, additionalFieldDisplay === "dynamic" && (index.h("ic-typography", { variant: "caption" }, index.h("p", { class: "dynamic-text" }, dynamicText))), index.h("div", { class: {
                "additional-field-wrapper": additionalFieldDisplay === "static",
            } }, index.h("slot", { name: ADDITIONAL_FIELD })))))));
    }
    static get delegatesFocus() { return true; }
    get el() { return index.getElement(this); }
    static get watchers() { return {
        "selected": ["watchSelectedHandler"]
    }; }
};
RadioOption.style = icRadioOptionCss;

exports.ic_radio_option = RadioOption;

//# sourceMappingURL=ic-radio-option.cjs.entry.js.map