'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const types = require('./types-dc22e301.js');
const helpers = require('./helpers-94b33ab0.js');

const clearIcon = `<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M15.8327 5.34199L14.6577 4.16699L9.99935 8.82533L5.34102 4.16699L4.16602 5.34199L8.82435 10.0003L4.16602 14.6587L5.34102 15.8337L9.99935 11.1753L14.6577 15.8337L15.8327 14.6587L11.1743 10.0003L15.8327 5.34199Z" fill="currentColor"/>
</svg>
`;

const searchIcon = `<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
    <path d="M13.1292 11.8792H12.4708L12.2375 11.6542C13.0542 10.7042 13.5458 9.47083 13.5458 8.12916C13.5458 5.13749 11.1208 2.71249 8.12916 2.71249C5.13749 2.71249 2.71249 5.13749 2.71249 8.12916C2.71249 11.1208 5.13749 13.5458 8.12916 13.5458C9.47083 13.5458 10.7042 13.0542 11.6542 12.2375L11.8792 12.4708V13.1292L16.0458 17.2875L17.2875 16.0458L13.1292 11.8792ZM8.12916 11.8792C6.05416 11.8792 4.37916 10.2042 4.37916 8.12916C4.37916 6.05416 6.05416 4.37916 8.12916 4.37916C10.2042 4.37916 11.8792 6.05416 11.8792 8.12916C11.8792 10.2042 10.2042 11.8792 8.12916 11.8792Z" fill="currentColor"/>
</svg>`;

const icSearchBarCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host(.search){--divider-height:1.5rem}:host(.search.small){--divider-height:1rem}:host(.fullwidth){width:100%}:host(.search) .disabled:hover{border-color:var(--ic-architectural-200)}:host(.search.disabled) .disabled svg{color:var(--ic-architectural-200)}:host(.search) .disabled svg{color:var(--ic-architectural-400)}.clear-button-container{align-items:center;margin-right:var(--ic-space-1px);display:none;visibility:hidden}.clear-button{border-radius:var(--ic-border-radius);transition:box-shadow var(--ic-easing-transition),\n    border-radius var(--ic-easing-transition)}.clear-button:focus,.clear-button:active{background-color:var(--ic-focus-blue);box-shadow:inset 0 0 0 0.125rem var(--ic-focus-glow);border-radius:0.25rem}.clear-button:focus,.clear-button:active *{fill:white}.clear-button-visible{visibility:visible;display:flex}.search-submit-button-container{display:flex;align-items:center}.search-submit-button-disabled .ic-tooltip-container{display:none !important}.search-submit-button:focus,.search-submit-button:active{background-color:var(--ic-focus-blue) !important;box-shadow:inset 0 0 0 0.125rem var(--ic-focus-glow) !important;border-radius:var(--ic-space-xxs)}.search-submit-button:focus,.search-submit-button:active *{fill:white}.divider{width:var(--ic-border-width);background-color:var(--ic-action-dark-active);height:var(--divider-height)}:host(.dark) .divider{background-color:var(--ic-architectural-200)}.menu-container{width:var(--input-width, 20rem);position:relative;top:var(--ic-space-xxxs)}.menu-container.fullwidth{width:100%}.no-results{cursor:not-allowed}.search-results-status{border:0;clip:rect(0, 0, 0, 0, 0);height:var(--ic-space-1px);margin-bottom:calc(-1 * var(--ic-space-1px));margin-right:calc(-1 * var(--ic-space-1px));overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:var(--ic-space-1px)}";

let inputIds = 0;
const SearchBar = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.icChange = index.createEvent(this, "icChange", 7);
        this.icClear = index.createEvent(this, "icClear", 7);
        this.icInput = index.createEvent(this, "icInput", 7);
        this.icInputBlur = index.createEvent(this, "icInputBlur", 7);
        this.icInputFocus = index.createEvent(this, "icInputFocus", 7);
        this.icOptionSelect = index.createEvent(this, "icOptionSelect", 7);
        this.icMenuChange = index.createEvent(this, "icMenuChange", 7);
        this.icClearBlur = index.createEvent(this, "icClearBlur", 7);
        this.icRetryLoad = index.createEvent(this, "icRetryLoad", 7);
        this.icSubmitSearch = index.createEvent(this, "icSubmitSearch", 7);
        this.icSubmitSearchBlur = index.createEvent(this, "icSubmitSearchBlur", 7);
        this.icSearchBarBlur = index.createEvent(this, "icSearchBarBlur", 7);
        this.icSearchBarFocus = index.createEvent(this, "icSearchBarFocus", 7);
        this.assistiveHintEl = null;
        this.hasTimedOut = false;
        this.inputId = `ic-search-bar-input-${inputIds++}`;
        this.menuCloseFromMenuChangeEvent = false;
        this.menuId = `${this.inputId}-menu`;
        this.preLoad = true;
        this.preventSubmit = false;
        this.prevNoOption = false;
        this.retryButtonClick = false;
        this.truncateValue = false;
        this.handleClear = (ev) => {
            const keyboardEvent = ev;
            const mouseEvent = ev;
            if (mouseEvent.type === "click" ||
                keyboardEvent.code === "Enter" ||
                keyboardEvent.code === "Space") {
                this.value = "";
                this.inputEl.value = "";
                this.loading = false;
                clearTimeout(this.timeoutTimer);
                this.filteredOptions = this.options;
                this.el.setFocus();
                this.icClear.emit();
                ev.preventDefault();
                this.preventSubmit = true;
            }
        };
        this.onInput = (ev) => {
            this.value = ev.target.value;
            const noOptions = [
                { [this.labelField]: this.emptyOptionListText, [this.valueField]: "" },
            ];
            if (this.options.length > 0) {
                this.setMenuChange(true);
                this.preLoad = false;
                if (this.disableFilter === false) {
                    const rawFilteredOptions = helpers.getFilteredMenuOptions(this.options, false, this.value, "anywhere", this.labelField);
                    this.filteredOptions =
                        rawFilteredOptions.length > 0 ? rawFilteredOptions : noOptions;
                }
            }
            if (!this.showClearButton) {
                this.handleShowClearButton(true);
            }
            this.debounceAriaLiveUpdate();
        };
        this.onInputBlur = (ev) => {
            const value = ev.target.value;
            const nextFocus = ev.relatedTarget;
            this.icInputBlur.emit({ value: value, relatedTarget: nextFocus });
        };
        this.onInputFocus = (ev) => {
            const value = ev.target.value;
            this.icInputFocus.emit({ value: value });
            this.handleShowClearButton(true);
        };
        this.handleClearBlur = (ev) => {
            const nextFocus = ev.relatedTarget;
            this.icClearBlur.emit({ relatedTarget: nextFocus });
            this.clearButtonFocused = false;
        };
        this.handleSubmitSearchBlur = (ev) => {
            const nextFocus = ev.relatedTarget;
            this.icSubmitSearchBlur.emit({ relatedTarget: nextFocus });
            this.searchSubmitFocused = false;
        };
        this.handleMouseDown = (ev) => {
            ev.preventDefault();
        };
        this.handleSubmitSearchFocus = () => {
            this.searchSubmitFocused = true;
        };
        this.handleSubmitSearch = () => {
            this.highlightedValue && (this.value = this.highlightedValue);
            this.highlightedValue = undefined;
            this.icSubmitSearch.emit({ value: this.value });
            const form = this.el.closest("FORM");
            if (this.searchSubmitButton && !!form && !this.preventSubmit) {
                helpers.handleHiddenFormButtonClick(form, this.searchSubmitButton);
            }
        };
        this.handleSubmitSearchKeyDown = (ev) => {
            if (ev.key === " ") {
                ev.preventDefault();
                this.handleSubmitSearch();
            }
        };
        this.handleRetry = (ev) => {
            this.retryViaKeyPress = ev.detail.keyPressed === "Enter";
            this.icRetryLoad.emit({ value: ev.detail.value });
            this.triggerLoading();
            this.retryButtonClick = true;
        };
        this.triggerLoading = () => {
            const loadingOption = [
                {
                    [this.labelField]: this.loadingLabel,
                    [this.valueField]: "",
                    loading: true,
                },
            ];
            if (this.filteredOptions !== loadingOption)
                this.filteredOptions = loadingOption;
            if (this.timeout) {
                this.timeoutTimer = window.setTimeout(() => {
                    this.filteredOptions = [
                        {
                            [this.labelField]: this.loadingErrorLabel,
                            [this.valueField]: "",
                            timedOut: true,
                        },
                    ];
                }, this.timeout);
            }
        };
        this.handleOptionSelect = (ev) => {
            if (ev.detail.label === this.emptyOptionListText) {
                this.el.setFocus();
                return;
            }
            this.value = ev.detail.value;
            this.icOptionSelect.emit({ value: this.value });
        };
        this.handleMenuOptionHighlight = (ev) => {
            var _a;
            const optionValue = (_a = ev.detail.optionId) === null || _a === void 0 ? void 0 : _a.replace(`${this.menuId}-`, "");
            optionValue && (this.highlightedValue = optionValue);
            if (ev.detail.optionId) {
                this.ariaActiveDescendant = ev.detail.optionId;
            }
            else {
                this.ariaActiveDescendant = undefined;
            }
        };
        this.handleMenuChange = (ev) => {
            this.setMenuChange(ev.detail.open);
            if (!ev.detail.open) {
                this.handleMenuCloseFromMenuChange(true);
                if (ev.detail.focusInput === undefined || ev.detail.focusInput) {
                    this.el.setFocus();
                }
            }
        };
        this.setMenuChange = (open) => {
            if (this.open !== open) {
                this.open = open;
                this.icMenuChange.emit({ open });
            }
        };
        this.handleHostFocus = () => {
            if (this.options && this.value && !this.menuCloseFromMenuChangeEvent) {
                this.setMenuChange(true);
            }
            this.handleTruncateValue(false);
            this.icSearchBarFocus.emit();
        };
        this.handleHostBlur = (ev) => {
            const nextFocus = ev.relatedTarget;
            if (this.open &&
                this.options &&
                nextFocus !== this.menu &&
                !this.retryViaKeyPress &&
                !this.retryButtonClick) {
                this.setMenuChange(false);
            }
            if (this.retryButtonClick || this.retryViaKeyPress) {
                this.inputEl.setFocus();
            }
            this.handleShowClearButton(false);
            this.handleMenuCloseFromMenuChange(false);
            this.handleTruncateValue(true);
            this.icSearchBarBlur.emit({ relatedTarget: nextFocus, value: this.value });
            this.retryViaKeyPress = false;
            this.retryButtonClick = false;
        };
        this.handleShowClearButton = (visible) => {
            this.showClearButton = visible;
        };
        this.handleFocusClearButton = () => {
            this.clearButtonFocused = true;
        };
        this.handleMenuCloseFromMenuChange = (fromEvent) => {
            this.menuCloseFromMenuChangeEvent = fromEvent;
        };
        this.handleTruncateValue = (truncate) => {
            this.truncateValue = truncate;
        };
        this.renderAssistiveHintEl = () => {
            var _a, _b;
            const input = (_b = (_a = this.el.shadowRoot
                .querySelector("ic-text-field")) === null || _a === void 0 ? void 0 : _a.shadowRoot) === null || _b === void 0 ? void 0 : _b.querySelector(`#${this.inputId}`);
            if (input &&
                Object.keys(input).length > 0 &&
                this.hasOptionsOrFilterDisabled()) {
                this.assistiveHintEl = document.createElement("span");
                this.assistiveHintEl.innerText = this.hintText;
                this.assistiveHintEl.id = `${this.inputId}-assistive-hint`;
                this.assistiveHintEl.style.display = "none";
                if (input.after !== undefined) {
                    input.after(this.assistiveHintEl);
                }
            }
        };
        this.updateSearchResultAriaLive = () => {
            const searchResultsStatusEl = this.el.shadowRoot.querySelector(".search-results-status");
            if (searchResultsStatusEl) {
                if (!this.open ||
                    this.value === "" ||
                    this.value.length < this.charactersUntilSuggestion) {
                    searchResultsStatusEl.innerText = "";
                }
                else if (this.hasOptionsOrFilterDisabled() &&
                    this.filteredOptions.length > 0 &&
                    this.open &&
                    !this.filteredOptions[0].loading) {
                    if (this.hadNoOptions()) {
                        searchResultsStatusEl.innerText = this.emptyOptionListText;
                    }
                    else {
                        searchResultsStatusEl.innerText = `${this.filteredOptions.length} result${this.filteredOptions.length > 1 ? "s" : ""} available`;
                    }
                }
            }
        };
        this.hasOptionsOrFilterDisabled = () => this.options.length > 0 || this.disableFilter;
        this.hadNoOptions = () => this.filteredOptions.length === 1 &&
            this.filteredOptions[0][this.labelField] === this.emptyOptionListText &&
            this.searchMode === "navigation";
        this.isSubmitDisabled = () => {
            const valueNotSet = this.value === undefined || this.value === null || this.value === "";
            const valueLengthLess = this.value.length < this.charactersUntilSuggestion;
            return (valueNotSet ||
                valueLengthLess ||
                this.disabled ||
                this.hadNoOptions() ||
                this.hasTimedOut ||
                this.loading);
        };
        this.highlightFirstOptionAfterNoResults = () => {
            if (this.prevNoOption && this.menu && !this.hasTimedOut) {
                this.menu.handleSetFirstOption();
                this.prevNoOption = false;
            }
            const prevNoOptionsList = this.filteredOptions.find((filteredOption) => filteredOption[this.labelField] === this.emptyOptionListText ||
                filteredOption[this.labelField] === this.loadingErrorLabel ||
                filteredOption[this.labelField] === this.loadingLabel);
            if (prevNoOptionsList) {
                this.prevNoOption = true;
            }
        };
        this.ariaActiveDescendant = undefined;
        this.clearButtonFocused = false;
        this.highlightedValue = undefined;
        this.open = false;
        this.searchSubmitFocused = false;
        this.showClearButton = false;
        this.autocapitalize = "off";
        this.autocomplete = "off";
        this.autocorrect = "off";
        this.autofocus = false;
        this.charactersUntilSuggestion = 2;
        this.disabled = false;
        this.disableFilter = false;
        this.debounce = 0;
        this.emptyOptionListText = "No results found";
        this.focusOnLoad = false;
        this.fullWidth = false;
        this.helperText = "";
        this.hideLabel = false;
        this.hintText = "When autocomplete results are available use the up and down arrows to choose and press enter to select";
        this.label = undefined;
        this.labelField = "label";
        this.loading = false;
        this.loadingErrorLabel = "Loading Error";
        this.loadingLabel = "Loading...";
        this.name = this.inputId;
        this.placeholder = "Search";
        this.readonly = false;
        this.required = false;
        this.searchMode = "navigation";
        this.size = "default";
        this.small = false;
        this.spellcheck = false;
        this.timeout = undefined;
        this.valueField = "value";
        this.filteredOptions = [];
        this.options = [];
        this.value = "";
    }
    loadingHandler(newValue) {
        if (newValue && !this.hasTimedOut) {
            this.preLoad = false;
            this.triggerLoading();
        }
    }
    filteredOptionsHandler(newOptions) {
        this.hasTimedOut = newOptions.some((opt) => opt.timedOut);
    }
    watchOptionsHandler(newOptions) {
        if (this.disableFilter && !this.hasTimedOut) {
            this.loading = false;
            clearTimeout(this.timeoutTimer);
            if (newOptions.length > 0) {
                this.filteredOptions = newOptions;
            }
            else {
                if (this.hadNoOptions()) {
                    return;
                }
                this.setMenuChange(true);
                !this.preLoad &&
                    (this.filteredOptions = [
                        {
                            [this.labelField]: this.emptyOptionListText,
                            [this.valueField]: "",
                        },
                    ]);
                this.preLoad = true;
            }
        }
        this.debounceAriaLiveUpdate();
    }
    watchValueHandler(newValue) {
        if (this.inputEl &&
            this.options &&
            !!helpers.getLabelFromValue(newValue, this.options, this.valueField, this.labelField)) {
            this.inputEl.value = helpers.getLabelFromValue(newValue, this.options, this.valueField, this.labelField);
        }
        else if (this.inputEl && this.inputEl.value !== newValue) {
            this.inputEl.value = newValue;
        }
    }
    disconnectedCallback() {
        if (this.assistiveHintEl) {
            this.assistiveHintEl.remove();
        }
    }
    componentWillLoad() {
        this.watchValueHandler(this.value);
        helpers.removeDisabledFalse(this.disabled, this.el);
        if (this.small) {
            this.size = "small";
        }
    }
    componentDidLoad() {
        if (this.focusOnLoad) {
            this.el.setFocus();
        }
        if (this.hasOptionsOrFilterDisabled()) {
            this.renderAssistiveHintEl();
            if (this.disableFilter) {
                this.filteredOptions = this.options;
            }
        }
        helpers.onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Search Bar");
        if (this.inputEl !== undefined) {
            this.anchorEl = this.inputEl.shadowRoot.querySelector("ic-input-component-container");
        }
    }
    componentWillRender() {
        this.highlightFirstOptionAfterNoResults();
    }
    handleKeyDown(ev) {
        const keyEv = ev.detail.event;
        if (this.menu && this.open) {
            this.menu.handleKeyboardOpen(keyEv);
        }
    }
    handleKeyUp(ev) {
        if (ev.key === "Enter") {
            if (this.preventSubmit || this.isSubmitDisabled()) {
                return;
            }
            this.handleSubmitSearch();
            this.setMenuChange(false);
        }
        if (ev.key === "Escape") {
            this.setMenuChange(false);
        }
        if (this.preventSubmit) {
            this.preventSubmit = false;
        }
    }
    /**
     * Sets focus on the native `input`.
     */
    async setFocus() {
        this.retryViaKeyPress = false;
        this.retryButtonClick = false;
        if (this.inputEl) {
            this.inputEl.setFocus();
        }
    }
    debounceAriaLiveUpdate() {
        clearTimeout(this.debounceAriaLive);
        this.debounceAriaLive = window.setTimeout(() => {
            this.updateSearchResultAriaLive();
        }, 500);
    }
    render() {
        const { inputId, name, label, required, small, size, placeholder, helperText, disabled, value, readonly, spellcheck, fullWidth, options, open, hideLabel, menuId, ariaActiveDescendant, truncateValue, autofocus, autocapitalize, autocomplete, filteredOptions, } = this;
        const disabledMode = readonly || disabled;
        const describedBy = helpers.getInputDescribedByText(inputId, helperText !== "", false).trim();
        let describedById;
        if (describedBy !== "" && this.hasOptionsOrFilterDisabled()) {
            describedById = `${describedBy} ${this.inputId}-assistive-hint`;
        }
        else if (this.hasOptionsOrFilterDisabled()) {
            describedById = `${this.inputId}-assistive-hint`;
        }
        else if (describedBy !== "") {
            describedById = describedBy;
        }
        else {
            describedById = undefined;
        }
        const hasSuggestedSearch = !!value && this.hasOptionsOrFilterDisabled();
        const menuOpen = hasSuggestedSearch && open && filteredOptions.length > 0;
        const menuRendered = menuOpen && value.length >= this.charactersUntilSuggestion;
        const labelValue = helpers.getLabelFromValue(value, options, this.valueField, this.labelField);
        helpers.renderHiddenInput(true, this.el, name, value, disabledMode);
        return (index.h(index.Host, { class: {
                search: true,
                fullwidth: fullWidth,
                disabled,
                small: size === "small",
            }, onFocus: this.handleHostFocus, onBlur: this.handleHostBlur }, index.h("ic-text-field", { ref: (el) => (this.inputEl = el), inputId: inputId, label: label, helperText: helperText, required: required, disabled: disabledMode && !readonly, readonly: readonly, size: size, hideLabel: hideLabel, fullWidth: fullWidth, name: name, truncateValue: truncateValue, value: options && !!labelValue ? labelValue : value, placeholder: placeholder, onInput: this.onInput, onBlur: this.onInputBlur, onFocus: this.onInputFocus, "aria-label": hideLabel ? label : "", "aria-describedby": describedById, "aria-owns": menuRendered ? menuId : undefined, "aria-controls": menuRendered ? menuId : undefined, "aria-haspopup": options.length > 0 ? "listbox" : undefined, ariaExpanded: options.length > 0 ? `${menuOpen}` : undefined, ariaActiveDescendant: ariaActiveDescendant, "aria-autocomplete": hasSuggestedSearch ? "list" : undefined, role: options.length > 0 ? "combobox" : undefined, autocomplete: autocomplete, autocapitalize: autocapitalize, autoFocus: autofocus, spellcheck: spellcheck, inputmode: "search", debounce: this.debounce }, index.h("div", { class: {
                "clear-button-container": true,
                "clear-button-visible": value && !disabledMode && this.showClearButton,
            }, slot: "clear-button" }, index.h("ic-button", { id: "clear-button", class: "clear-button", "aria-label": "Clear", innerHTML: clearIcon, onClick: this.handleClear, onMouseDown: this.handleMouseDown, size: size, onFocus: this.handleFocusClearButton, onBlur: this.handleClearBlur, onKeyDown: this.handleClear, type: "submit", variant: "icon", appearance: this.clearButtonFocused
                ? types.IcThemeForegroundEnum.Light
                : types.IcThemeForegroundEnum.Dark }), index.h("div", { class: "divider" })), index.h("div", { class: {
                "search-submit-button-container": true,
                "search-submit-button-disabled": this.isSubmitDisabled(),
            }, slot: "search-submit-button" }, index.h("ic-button", { id: "search-submit-button", "aria-label": "Search", ref: (el) => (this.searchSubmitButton = el), class: {
                ["search-submit-button"]: true,
                ["search-submit-button-small"]: !!small,
            }, disabled: this.isSubmitDisabled(), innerHTML: searchIcon, size: size, onClick: this.handleSubmitSearch, onMouseDown: this.handleMouseDown, onBlur: this.handleSubmitSearchBlur, onFocus: this.handleSubmitSearchFocus, onKeyDown: this.handleSubmitSearchKeyDown, type: "submit", variant: "icon", appearance: this.searchSubmitFocused
                ? types.IcThemeForegroundEnum.Light
                : types.IcThemeForegroundEnum.Default })), index.h("div", { class: {
                "menu-container": true,
                fullwidth: fullWidth,
            }, slot: "menu" }, menuRendered && (index.h("ic-menu", { class: {
                "no-results": this.hadNoOptions() ||
                    (filteredOptions.length === 1 &&
                        (filteredOptions[0][this.labelField] ===
                            this.loadingLabel ||
                            filteredOptions[0][this.labelField] ===
                                this.loadingErrorLabel)),
            }, activationType: "manual", anchorEl: this.anchorEl, autoFocusOnSelected: false, searchMode: this.searchMode, inputEl: this.inputEl, inputLabel: label, ref: (el) => (this.menu = el), small: size === "small", fullWidth: fullWidth, menuId: menuId, open: !!menuRendered, options: filteredOptions, onMenuOptionSelect: this.handleOptionSelect, onMenuStateChange: this.handleMenuChange, onMenuOptionId: this.handleMenuOptionHighlight, onRetryButtonClicked: this.handleRetry, parentEl: this.el, value: value, labelField: this.labelField, valueField: this.valueField })))), index.h("div", { "aria-live": "polite", role: "status", class: "search-results-status" })));
    }
    static get delegatesFocus() { return true; }
    get el() { return index.getElement(this); }
    static get watchers() { return {
        "loading": ["loadingHandler"],
        "filteredOptions": ["filteredOptionsHandler"],
        "options": ["watchOptionsHandler"],
        "value": ["watchValueHandler"]
    }; }
};
SearchBar.style = icSearchBarCss;

exports.ic_search_bar = SearchBar;

//# sourceMappingURL=ic-search-bar.cjs.entry.js.map