'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
const types = require('./types-dc22e301.js');

const icTabGroupCss = ":host{--border-bottom-color:var(--ic-architectural-300);display:block;margin-bottom:var(--ic-space-md);border-bottom:var(--ic-border-default)}:host(.inline){margin-bottom:0;border-bottom:none}.light{border-bottom:var(--ic-border-width) solid var(--ic-architectural-white)}.tabs-container{display:flex;flex-direction:row}.tabs-container::-webkit-scrollbar{display:none}";

const TabGroup = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.appearance = "dark";
        this.contextId = "default";
        this.inline = false;
        this.label = undefined;
    }
    componentDidLoad() {
        helpers.onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Tab Group");
    }
    render() {
        const { appearance, label } = this;
        return (index.h(index.Host, { role: "tablist", "aria-label": label, class: {
                ["light"]: appearance === types.IcThemeForegroundEnum.Light,
                ["inline"]: this.inline,
            } }, index.h("ic-horizontal-scroll", { appearance: appearance === types.IcThemeForegroundEnum.Dark
                ? types.IcThemeForegroundEnum.Default
                : appearance, "focus-trigger": "tabFocus" }, index.h("div", { class: "tabs-container" }, index.h("slot", null)))));
    }
    static get delegatesFocus() { return true; }
};
TabGroup.style = icTabGroupCss;

exports.ic_tab_group = TabGroup;

//# sourceMappingURL=ic-tab-group.cjs.entry.js.map