'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const helpers = require('./helpers-94b33ab0.js');
require('./types-dc22e301.js');

const Theme = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.themeChange = index.createEvent(this, "themeChange", 7);
        this.checkThemeColorContrast = () => {
            if (helpers.getThemeColorBrightness() < helpers.BLACK_MIN_COLOR_BRIGHTNESS &&
                helpers.getThemeColorBrightness() > helpers.WHITE_MAX_COLOR_BRIGHTNESS) {
                console.warn(`The theme colour does not provide enough contrast with either of the ICDS black or white foreground colours. Consider choosing a colour with a different brightness to achieve sufficient colour contrast for good visibility. See https://www.w3.org/TR/AERT/#color-contrast for more information about colour contrast.`);
            }
        };
        this.setThemeColor = () => {
            const colorRGBA = helpers.convertToRGBA(this.color);
            if (colorRGBA) {
                const { r, g, b, a } = colorRGBA;
                const { style } = document.documentElement;
                style.setProperty("--ic-theme-primary-r", `${r}`);
                style.setProperty("--ic-theme-primary-g", `${g}`);
                style.setProperty("--ic-theme-primary-b", `${b}`);
                style.setProperty("--ic-theme-primary-a", `${a}`);
                this.checkThemeColorContrast();
                this.themeChange.emit({
                    mode: helpers.getThemeForegroundColor(),
                    color: colorRGBA,
                });
            }
        };
        this.color = null;
    }
    watchColorPropHandler() {
        this.setThemeColor();
    }
    componentWillLoad() {
        this.setThemeColor();
    }
    render() {
        return index.h(index.Host, null);
    }
    static get watchers() { return {
        "color": ["watchColorPropHandler"]
    }; }
};

exports.ic_theme = Theme;

//# sourceMappingURL=ic-theme.cjs.entry.js.map