'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-f982899d.js');
const closeIcon = require('./close-icon-7f6ef8e4.js');
const helpers = require('./helpers-94b33ab0.js');
const types = require('./types-dc22e301.js');

const icToastCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}@media (prefers-reduced-motion: no-preference){:host{animation:fadein var(--ic-transition-duration-slow) ease-in-out}:host(.hidden){animation:fadeout var(--ic-transition-duration-slow) ease-in-out}}:host{--bottom-position:var(--ic-space-xl);position:fixed;bottom:var(--bottom-position);left:50%;transform:translate(-50%);z-index:var(--ic-z-index-toast)}:host(.hidden){display:none}.container{max-width:32.5rem;min-width:18rem;box-shadow:var(--ic-elevation-overlay);min-height:3.5rem;background-color:var(--ic-architectural-800);color:var(--ic-color-white-text);display:flex;align-items:center;position:relative;border-radius:var(--ic-border-radius)}.toast-icon-container{height:100%;display:flex;align-items:center}.divider{height:100%;width:var(--ic-space-xs);position:absolute;border-radius:var(--ic-space-xxxs) 0 0 var(--ic-space-xxxs)}.divider-neutral{background-color:var(--ic-status-unknown)}.divider-info{background-color:var(--ic-status-info-contrast)}.divider-warning{background-color:var(--ic-status-warning-contrast)}.divider-error{background-color:var(--ic-status-error-contrast)}.divider-success{background-color:var(--ic-status-success-contrast)}.toast-icon,::slotted(svg){height:var(--ic-space-lg);width:var(--ic-space-lg);margin-left:var(--ic-space-md)}:host([variant=\"neutral\"]) .toast-icon svg,::slotted(svg){fill:var(--ic-status-unknown)}:host([variant=\"info\"]) .toast-icon svg{fill:var(--ic-status-info-contrast)}:host([variant=\"warning\"]) .toast-icon svg{fill:var(--ic-status-warning-contrast)}:host([variant=\"error\"]) .toast-icon svg{fill:var(--ic-status-error-contrast)}:host([variant=\"success\"]) .toast-icon svg{fill:var(--ic-status-success-contrast)}.toast-content{margin-left:var(--ic-space-xs);width:100%}.no-icon{margin-left:var(--ic-space-md)}.toast-message{padding:var(--ic-space-xs) var(--ic-space-xs) var(--ic-space-xs) 0}.toast-action-container{padding-bottom:var(--ic-space-md)}ic-button,.toast-dismiss-timer{padding:var(--ic-space-xs)}@media (max-width: 576px){:host{--bottom-position:var(--ic-space-lg);width:calc(100% - 2 * var(--ic-space-md))}}@media (min-width: 993px){:host{--bottom-position:calc(var(--ic-space-xl) + var(--ic-space-xs))}}@media (forced-colors: active){.container{border:var(--ic-hc-border)}}@keyframes fadein{from{bottom:0;opacity:0}to{bottom:var(--bottom-position);opacity:1}}@keyframes fadeout{from{bottom:var(--bottom-position);opacity:1}to{bottom:0;opacity:0}}";

const AUTO_DISMISS_TIMER_REFRESH_RATE_MS = 1000;
const TOAST_HEADING_CHAR_LIMIT = 70;
const TOAST_MESSAGE_CHAR_LIMIT = 140;
const Toast = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.icDismiss = index.createEvent(this, "icDismiss", 7);
        this.interactiveElements = [];
        this.dismissAction = () => {
            this.icDismiss.emit();
        };
        this.handleProgressChange = () => {
            this.timerProgress -=
                (AUTO_DISMISS_TIMER_REFRESH_RATE_MS / this.autoDismissTimeout) * 100;
        };
        this.timerProgress = 100;
        this.visible = false;
        this.autoDismissTimeout = 5000;
        this.dismissButtonAriaLabel = "dismiss";
        this.dismissMode = "manual";
        this.heading = undefined;
        this.message = undefined;
        this.neutralIconAriaLabel = undefined;
        this.variant = undefined;
    }
    dismissModeChangeHandler(newValue) {
        this.isManual = newValue === "manual";
    }
    disconnectedCallback() {
        window.clearTimeout(this.dismissTimeout);
        window.clearInterval(this.timerRefreshInterval);
    }
    componentWillLoad() {
        var _a, _b;
        this.handleLongText(this.heading.length > TOAST_HEADING_CHAR_LIMIT, ((_a = this.message) === null || _a === void 0 ? void 0 : _a.length) > TOAST_MESSAGE_CHAR_LIMIT);
        if (this.autoDismissTimeout < 5000)
            this.autoDismissTimeout = 5000;
        if (helpers.isSlotUsed(this.el, "action"))
            this.dismissMode = "manual";
        this.isManual = this.dismissMode === "manual";
        if (helpers.isSlotUsed(this.el, "neutral-icon"))
            this.variant = "neutral";
        if (this.variant === "neutral") {
            this.neutralVariantLabel =
                (_b = this.neutralIconAriaLabel) !== null && _b !== void 0 ? _b : helpers.VARIANT_ICONS[this.variant].ariaLabel;
        }
        if (this.isManual) {
            const toastMessage = helpers.isPropDefined(this.message)
                ? `. ${this.message}`
                : "";
            this.el.setAttribute("aria-label", this.variant
                ? this.neutralVariantLabel || helpers.VARIANT_ICONS[this.variant].ariaLabel
                : this.heading);
            (this.variant || this.message) &&
                this.el.setAttribute("aria-description", this.variant ? `${this.heading}${toastMessage}` : this.message);
        }
    }
    componentDidLoad() {
        helpers.onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Toast");
        const actionContent = helpers.getSlot(this.el, "action");
        const dismissButton = this.el.shadowRoot.querySelector("ic-button");
        if (actionContent)
            this.interactiveElements.push(actionContent);
        if (dismissButton)
            this.interactiveElements.push(dismissButton);
    }
    handleDismiss() {
        this.visible = false;
        clearInterval(this.timerRefreshInterval);
        this.timerProgress = 100;
    }
    handleKeyboard(ev) {
        if (this.isManual && this.visible) {
            switch (ev.key) {
                case "Tab":
                    ev.preventDefault();
                    this.findNextInteractiveElement(ev.shiftKey).setFocus();
                    break;
                case "Escape":
                    !ev.repeat && this.dismissAction();
                    ev.stopImmediatePropagation();
                    break;
            }
        }
    }
    handleTimer(ev) {
        if (!this.isManual) {
            switch (ev.type) {
                case "mouseenter":
                    window.clearTimeout(this.dismissTimeout);
                    window.clearInterval(this.timerRefreshInterval);
                    this.timerProgress = 100;
                    break;
                case "mouseleave":
                    this.dismissTimeout = window.setTimeout(this.dismissAction, this.autoDismissTimeout);
                    this.timerRefreshInterval = window.setInterval(this.handleProgressChange, AUTO_DISMISS_TIMER_REFRESH_RATE_MS);
                    break;
            }
        }
    }
    /**
     * @internal Used to display the individual toast.
     * @returns The element that previously had focus before the toast appeared
     */
    async setVisible() {
        if (!this.visible)
            this.visible = true;
        if (!this.isManual) {
            this.dismissTimeout = window.setTimeout(this.dismissAction, this.autoDismissTimeout);
            this.timerRefreshInterval = window.setInterval(this.handleProgressChange, AUTO_DISMISS_TIMER_REFRESH_RATE_MS);
            return null;
        }
        else {
            window.setTimeout(() => this.interactiveElements[0].setFocus(), 200);
            return document.activeElement;
        }
    }
    handleLongText(headingTooLong, messageTooLong) {
        if (messageTooLong || headingTooLong) {
            console.error(`Too many characters in toast ${headingTooLong ? "heading" : ""}${headingTooLong && messageTooLong ? " and " : ""}${messageTooLong ? "message" : ""}. Refer to character limits specified in the prop description`);
        }
    }
    findNextInteractiveElement(isBackwards) {
        const firstEl = this.interactiveElements[0];
        const lastEl = this.interactiveElements[this.interactiveElements.length - 1];
        if (this.isActive(isBackwards ? firstEl : lastEl))
            return isBackwards ? lastEl : firstEl;
        let currentIndex;
        return this.interactiveElements.some((el, index) => {
            if (!this.isActive(el))
                return false;
            currentIndex = index;
            return true;
        })
            ? this.interactiveElements[currentIndex + (isBackwards ? -1 : 1)]
            : firstEl;
    }
    isActive(targetEl) {
        return targetEl === this.el
            ? !!this.el.shadowRoot.activeElement
            : document.activeElement === targetEl;
    }
    render() {
        const { variant, heading, message, visible, isManual, dismissButtonAriaLabel, } = this;
        return (index.h(index.Host, { class: { ["hidden"]: !visible }, role: isManual ? "dialog" : "status" }, index.h("div", { class: "container" }, variant && visible && (index.h("div", { class: "toast-icon-container" }, index.h("div", { class: {
                ["divider"]: true,
                [`divider-${variant}`]: true,
            } }), variant === "neutral" ? (index.h("slot", { name: "neutral-icon" })) : (index.h("span", { class: "toast-icon", innerHTML: helpers.VARIANT_ICONS[variant].icon })))), index.h("div", { class: {
                ["toast-content"]: true,
                ["no-icon"]: variant === "neutral" && !helpers.isSlotUsed(this.el, "neutral-icon"),
            } }, index.h("div", { class: "toast-message" }, index.h("ic-typography", { variant: "subtitle-large" }, visible && index.h("h5", null, heading)), message && (index.h("ic-typography", { variant: "body" }, visible && index.h("p", null, message)))), helpers.isSlotUsed(this.el, "action") && (index.h("div", { class: "toast-action-container" }, index.h("slot", { name: "action" })))), !isManual ? (index.h("ic-loading-indicator", { class: "toast-dismiss-timer", appearance: "light", size: "icon", progress: this.timerProgress })) : (index.h("ic-button", { id: "dismiss-button", innerHTML: closeIcon.closeIcon, onClick: this.dismissAction, variant: "icon", appearance: types.IcThemeForegroundEnum.Light, "aria-label": dismissButtonAriaLabel })))));
    }
    get el() { return index.getElement(this); }
    static get watchers() { return {
        "dismissMode": ["dismissModeChangeHandler"]
    }; }
};
Toast.style = icToastCss;

exports.ic_toast = Toast;

//# sourceMappingURL=ic-toast.cjs.entry.js.map