import { h, Host, } from "@stencil/core";
import { isSlotUsed } from "../../utils/helpers";
let accordionGroupIds = 0;
/**
 * @slot group-title - Content is placed as the accordion group title.
 */
export class AccordionGroup {
    constructor() {
        this.accordionGroupId = `ic-accordion-group-${accordionGroupIds++}`;
        this.handleExpanded = () => {
            if (this.areAllAccordionsOpen) {
                this.expanded = false;
                this.accordions.forEach((acc) => {
                    acc.expanded = this.expanded;
                });
            }
            else {
                this.expanded = true;
                this.accordions.forEach((acc) => {
                    acc.expanded = this.expanded;
                });
            }
            this.setExpandedToAreAllAccordionsOpen();
        };
        this.linkAccordions = () => {
            this.accordions.forEach((accordion) => {
                accordion.setAttribute("context-id", this.accordionGroupId);
            });
        };
        this.setExpandedToAreAllAccordionsOpen = () => {
            this.areAllAccordionsOpen = this.accordions.every((accordion) => !!accordion.expanded);
        };
        this.accordionOpenBtnText = () => {
            return !this.areAllAccordionsOpen ? "See all" : "Hide all";
        };
        this.accordions = undefined;
        this.areAllAccordionsOpen = undefined;
        this.accessibleButtonLabel = "accordions";
        this.appearance = "default";
        this.expanded = false;
        this.groupTitle = "";
        this.singleExpansion = false;
        this.size = "default";
    }
    watchAppearanceHandler() {
        this.accordions.forEach((acc) => {
            acc.appearance = this.appearance;
        });
    }
    watchExpandedHandler() {
        this.handleExpanded();
    }
    componentDidLoad() {
        const accordionDirectChildren = this.el.children;
        this.accordions = Array.from(accordionDirectChildren).filter((child) => child.tagName === "IC-ACCORDION");
        this.linkAccordions();
        this.accordions.forEach((acc) => {
            acc.appearance = this.appearance;
        });
        this.accordions.forEach((acc) => {
            acc.size = this.size;
        });
        if (this.expanded) {
            this.accordions.forEach((acc) => {
                acc.expanded = true;
            });
            this.setExpandedToAreAllAccordionsOpen();
        }
        else {
            this.setExpandedToAreAllAccordionsOpen();
            this.expanded = this.areAllAccordionsOpen;
        }
    }
    handleAccordionClicked(event) {
        if (!this.singleExpansion) {
            // 'See all' should be visible until all accordions are open, then 'Hide all' should be visible
            this.setExpandedToAreAllAccordionsOpen();
        }
        else {
            this.accordions.forEach((acc) => {
                if (acc.expanded && event.detail.id !== acc.id) {
                    acc.expanded = false;
                }
            });
        }
    }
    /**
     * Sets the focus on first focusable element in the accordion group. If the "See/Hide all" button is present, it will be focused.
     * Otherwise, the first accordion will be focused.
     */
    async setFocus() {
        const focusEl = this.singleExpansion
            ? this.accordions[0]
            : this.allButtonEl;
        focusEl.setFocus();
    }
    render() {
        const { appearance, size, groupTitle, singleExpansion, accessibleButtonLabel, } = this;
        return (h(Host, { "context-id": this.accordionGroupId, class: {
                [`${appearance}`]: true,
                [`${size}`]: true,
                ["accordion-group"]: true,
            } }, h("div", { class: "group-title-container" }, h("ic-typography", { variant: "h4" }, h("h3", null, isSlotUsed(this.el, "group-title") ? (h("slot", { name: "group-title" })) : (groupTitle))), !singleExpansion && (h("ic-button", { ref: (el) => (this.allButtonEl = el), appearance: appearance === "light" ? "light" : "default", onClick: this.handleExpanded, variant: "tertiary", "aria-label": `${this.accordionOpenBtnText()} ${accessibleButtonLabel}` }, this.accordionOpenBtnText()))), h("slot", null)));
    }
    static get is() { return "ic-accordion-group"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-accordion-group.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-accordion-group.css"]
        };
    }
    static get properties() {
        return {
            "accessibleButtonLabel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The accessible button label to provide more context to the 'See all/Hide all' button for screen reader users."
                },
                "attribute": "accessible-button-label",
                "reflect": false,
                "defaultValue": "\"accordions\""
            },
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForeground",
                    "resolved": "\"dark\" | \"default\" | \"light\"",
                    "references": {
                        "IcThemeForeground": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForeground"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the accordion group, e.g dark, or light."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "expanded": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the accordion will load in an expanded state."
                },
                "attribute": "expanded",
                "reflect": false,
                "defaultValue": "false"
            },
            "groupTitle": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The header for the accordion group."
                },
                "attribute": "group-title",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "singleExpansion": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, only one accordion will open at a time."
                },
                "attribute": "single-expansion",
                "reflect": false,
                "defaultValue": "false"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the accordion."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            }
        };
    }
    static get states() {
        return {
            "accordions": {},
            "areAllAccordionsOpen": {}
        };
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets the focus on first focusable element in the accordion group. If the \"See/Hide all\" button is present, it will be focused.\nOtherwise, the first accordion will be focused.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "appearance",
                "methodName": "watchAppearanceHandler"
            }, {
                "propName": "expanded",
                "methodName": "watchExpandedHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "accordionClicked",
                "method": "handleAccordionClicked",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-accordion-group.js.map
