import { Host, h, forceUpdate, } from "@stencil/core";
import closeIcon from "../../assets/close-icon.svg";
import { isSlotUsed, checkSlotInChildMutations } from "../../utils/helpers";
import { IcThemeForegroundEnum } from "../../utils/types";
import { VARIANT_ICONS } from "../../utils/constants";
/**
 * @slot message - Content is placed to the right of the title.
 * @slot action - Content is placed to the right of the message.
 * @slot neutral-icon - A custom neutral icon is placed to the left of the title. This will override the default icon if used.
 */
export class Alert {
    constructor() {
        this.hostMutationObserver = null;
        this.dismissAction = () => {
            this.dismiss.emit();
            this.icDismiss.emit();
        };
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, "action")
                : false)) {
                forceUpdate(this);
            }
        };
        this.alertTitleWrap = false;
        this.visible = true;
        this.announced = true;
        this.dismissible = false;
        this.heading = "";
        this.message = undefined;
        this.titleAbove = false;
        this.variant = "neutral";
        this.showDefaultIcon = true;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentDidLoad() {
        this.alertTitleShouldWrap();
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    handleClick() {
        this.visible = !this.visible;
    }
    alertTitleShouldWrap() {
        var _a;
        const titleHeight = (_a = this.el.shadowRoot.querySelector(".alert-title")) === null || _a === void 0 ? void 0 : _a.clientHeight;
        if (titleHeight > 24)
            this.alertTitleWrap = true;
    }
    render() {
        const { variant, heading, message, titleAbove, dismissible, announced, visible, showDefaultIcon, } = this;
        return (visible && (h(Host, { role: announced ? "alert" : null, class: {
                [IcThemeForegroundEnum.Dark]: true,
            } }, h("div", { class: {
                ["container"]: true,
                [`container-${variant}`]: true,
            } }, h("div", { class: "alert-icon-container" }, h("div", { class: {
                ["divider"]: true,
                [`divider-${variant}`]: true,
            } }), variant === "neutral" ? (isSlotUsed(this.el, "neutral-icon") ? (h("div", { class: "alert-icon svg-container icon-neutral" }, h("slot", { name: "neutral-icon" }))) : showDefaultIcon ? (h("span", { class: {
                ["alert-icon"]: true,
                ["svg-container"]: true,
                [`icon-${variant}`]: true,
            }, innerHTML: VARIANT_ICONS[variant].icon })) : (h("div", { class: "icon-placeholder" }))) : (h("span", { class: {
                ["alert-icon"]: true,
                ["svg-container"]: true,
                [`icon-${variant}`]: true,
            }, innerHTML: VARIANT_ICONS[variant].icon }))), h("div", { class: "alert-content" }, h("div", { class: {
                ["alert-message"]: true,
                ["alert-message-title-above"]: titleAbove || this.alertTitleWrap,
            } }, heading && (h("ic-typography", { class: {
                ["alert-title"]: true,
                ["alert-title-above"]: titleAbove || this.alertTitleWrap,
            }, variant: "subtitle-large" }, h("p", null, heading))), h("slot", { name: "message" }, h("ic-typography", { variant: "body" }, message))), isSlotUsed(this.el, "action") && (h("div", { class: "alert-action-container" }, h("slot", { name: "action" })))), h("div", { class: "dismiss-icon-container" }, dismissible && (h("ic-button", { class: {
                ["svg-container"]: true,
                ["dismiss-icon"]: true,
            }, innerHTML: closeIcon, onClick: this.dismissAction, variant: "icon", appearance: IcThemeForegroundEnum.Dark, title: "dismiss" })))))));
    }
    static get is() { return "ic-alert"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-alert.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-alert.css"]
        };
    }
    static get properties() {
        return {
            "announced": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the alert will have the 'alert' ARIA role and will be announced to screen readers."
                },
                "attribute": "announced",
                "reflect": false,
                "defaultValue": "true"
            },
            "dismissible": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the alert will have a close icon at the end to dismiss it."
                },
                "attribute": "dismissible",
                "reflect": false,
                "defaultValue": "false"
            },
            "heading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The optional title to display at the start of the alert."
                },
                "attribute": "heading",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "message": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The main body message of the alert."
                },
                "attribute": "message",
                "reflect": false
            },
            "titleAbove": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the title and message will appear above and below instead of inline."
                },
                "attribute": "title-above",
                "reflect": false,
                "defaultValue": "false"
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcStatusVariants",
                    "resolved": "\"error\" | \"info\" | \"neutral\" | \"success\" | \"warning\"",
                    "references": {
                        "IcStatusVariants": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcStatusVariants"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The variant of the alert which will be rendered."
                },
                "attribute": "variant",
                "reflect": false,
                "defaultValue": "\"neutral\""
            },
            "showDefaultIcon": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the default icon for the neutral variant will be appear on the left of the alert."
                },
                "attribute": "show-default-icon",
                "reflect": false,
                "defaultValue": "true"
            }
        };
    }
    static get states() {
        return {
            "alertTitleWrap": {},
            "visible": {}
        };
    }
    static get events() {
        return [{
                "method": "dismiss",
                "name": "dismiss",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This event should not be used anymore. Use icDismiss instead."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "icDismiss",
                "name": "icDismiss",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Is emitted when the user dismisses the alert."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "icDismiss",
                "method": "handleClick",
                "target": undefined,
                "capture": true,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-alert.js.map
