import { Host, h } from "@stencil/core";
import { checkResizeObserver, DEVICE_SIZES, getCurrentDeviceSize, } from "../../utils/helpers";
// Added ResizeObserver to find out width of breadcrumbs and parents. Use side navigation long title for ref.
export class BreadcrumbGroup {
    constructor() {
        this.ADD_CLASS_DELAY = 50;
        this.IC_BREADCRUMB = "ic-breadcrumb";
        this.resizeObserver = null;
        this.SHOW_BACK_ICON = "show-back-icon";
        this.setAppearance = () => {
            const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
            allBreadcrumbs.forEach((breadcrumb) => {
                breadcrumb.setAttribute("appearance", this.appearance);
            });
        };
        this.setBackBreadcrumb = () => {
            if (this.backBreadcrumbOnly) {
                this.setBackBreadcrumbAttr();
            }
        };
        this.setBackBreadcrumbAttr = () => {
            if (this.lastParentBreadcrumb) {
                this.lastParentBreadcrumb.classList.add("show");
                this.lastParentBreadcrumb.setAttribute(this.SHOW_BACK_ICON, "true");
            }
        };
        this.getLastParentBreadcrumb = () => {
            const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
            if (allBreadcrumbs.length === 1) {
                return null;
            }
            this.breadcrumbs = allBreadcrumbs.filter((breadcrumb) => !breadcrumb.getAttribute("current"));
            this.breadcrumb = this.breadcrumbs[this.breadcrumbs.length - 1];
            return this.breadcrumb;
        };
        this.lastParentBreadcrumb = this.getLastParentBreadcrumb();
        this.setDefaultBreadcrumbs = () => {
            const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
            allBreadcrumbs.forEach((breadcrumb) => {
                breadcrumb.setAttribute(this.SHOW_BACK_ICON, "false");
            });
        };
        this.setCollapsed = () => {
            if (this.collapsed) {
                const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
                this.collapsedBreadcrumbs = allBreadcrumbs
                    .splice(1, allBreadcrumbs.length - 2)
                    .filter((breadcrumb) => !breadcrumb.classList.contains("collapsed-breadcrumb-wrapper"));
                this.collapsedBreadcrumbs.forEach((breadcrumb) => breadcrumb.classList.add("hide"));
                const firstBreadcrumb = allBreadcrumbs[0];
                if (firstBreadcrumb) {
                    firstBreadcrumb.insertAdjacentElement("afterend", this.collapsedBreadcrumbWrapper);
                }
            }
        };
        this.clickHandler = () => {
            this.handleHiddenCollapsedBreadcrumbs(this.collapsedBreadcrumbWrapper);
        };
        this.renderCollapsedBreadcrumb = () => {
            this.collapsedBreadcrumbWrapper = document.createElement("ic-breadcrumb");
            this.collapsedBreadcrumbWrapper.classList.add("collapsed-breadcrumb-wrapper");
            this.collapsedBreadcrumbEl = document.createElement("button");
            const ariaLabel = document.createElement("span");
            ariaLabel.id = "collapsed-button-label";
            ariaLabel.innerText = "Collapsed breadcrumbs";
            ariaLabel.className = "hide";
            this.collapsedBreadcrumbEl.setAttribute("aria-labelledby", "collapsed-button-label");
            const ariaDescribed = document.createElement("span");
            ariaDescribed.id = "collapsed-button-described";
            ariaDescribed.innerText = "Select to view collapsed breadcrumbs";
            ariaDescribed.className = "hide";
            this.collapsedBreadcrumbEl.setAttribute("aria-describedby", "collapsed-button-described");
            this.collapsedBreadcrumbEl.id = "collapsed-ellipsis";
            this.collapsedBreadcrumbEl.innerText = "...";
            this.collapsedBreadcrumbEl.classList.add("collapsed-breadcrumb");
            this.collapsedBreadcrumbEl.addEventListener("click", this.clickHandler);
            this.collapsedBreadcrumbWrapper.append(ariaDescribed);
            this.collapsedBreadcrumbWrapper.append(ariaLabel);
            this.collapsedBreadcrumbWrapper.append(this.collapsedBreadcrumbEl);
            return this.collapsedBreadcrumbWrapper;
        };
        this.handleHiddenCollapsedBreadcrumbs = (collapsedBreadcrumbWrapper) => {
            collapsedBreadcrumbWrapper.remove();
            this.collapsedBreadcrumbs.forEach((breadcrumb) => {
                breadcrumb.classList.add("visuallyhidden");
                breadcrumb.classList.remove("hide");
                setTimeout(() => {
                    breadcrumb.classList.add("fade");
                }, this.ADD_CLASS_DELAY);
                this.removeVisuallyHiddenClass(breadcrumb);
            });
            this.expandedBreadcrumbs = true;
            // Set focus to first unhidden breadcrumb
            this.collapsedBreadcrumbs[0].setFocus();
        };
        this.transitionendHandler = (event) => {
            if (event.propertyName === "opacity") {
                event.target.classList.remove("visuallyhidden");
            }
        };
        this.removeVisuallyHiddenClass = (breadcrumb) => {
            breadcrumb.addEventListener("transitionend", this.transitionendHandler);
        };
        this.setLastParentCollapsedBackBreadcrumb = () => {
            this.setBackBreadcrumbAttr();
            this.lastParentBreadcrumb.classList.remove("hide");
        };
        this.revertLastParentCollapsedBreadcrumb = () => {
            this.lastParentBreadcrumb.setAttribute(this.SHOW_BACK_ICON, "false");
        };
        this.resizeObserverCallback = (currSize) => {
            if (currSize !== this.deviceSize) {
                this.deviceSize = currSize;
                if (this.deviceSize <= DEVICE_SIZES.S) {
                    this.el.setAttribute("back-breadcrumb-only", "true");
                    if (this.collapsed) {
                        this.setLastParentCollapsedBackBreadcrumb();
                    }
                    else {
                        this.setBackBreadcrumb();
                    }
                }
                else {
                    this.el.setAttribute("back-breadcrumb-only", "false");
                    if (this.collapsed && this.breadcrumbs && this.breadcrumbs.length > 2) {
                        this.revertLastParentCollapsedBreadcrumb();
                        if (this.expandedBreadcrumbs) {
                            this.setDefaultBreadcrumbs();
                        }
                        else {
                            this.setCollapsed();
                        }
                    }
                    else {
                        this.setDefaultBreadcrumbs();
                    }
                }
            }
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                const currSize = getCurrentDeviceSize();
                this.resizeObserverCallback(currSize);
            });
            this.resizeObserver.observe(this.el);
        };
        this.deviceSize = DEVICE_SIZES.XL;
        this.expandedBreadcrumbs = false;
        this.appearance = "default";
        this.backBreadcrumbOnly = false;
        this.collapsed = false;
    }
    watchAppearanceHandler() {
        this.setAppearance();
    }
    watchBackBreadcrumbHandler() {
        this.setBackBreadcrumb();
    }
    componentWillLoad() {
        const allBreadcrumbs = Array.from(this.el.querySelectorAll(this.IC_BREADCRUMB));
        this.setAppearance();
        if (this.backBreadcrumbOnly) {
            this.setBackBreadcrumb();
        }
        else {
            checkResizeObserver(this.runResizeObserver);
        }
        if (this.collapsed) {
            this.collapsedBreadcrumbWrapper = this.renderCollapsedBreadcrumb();
            if (allBreadcrumbs.length > 2) {
                if (getCurrentDeviceSize() === DEVICE_SIZES.S) {
                    this.setLastParentCollapsedBackBreadcrumb();
                }
                else {
                    this.setCollapsed();
                }
            }
        }
    }
    disconnectedCallback() {
        this.breadcrumb &&
            this.breadcrumb.removeEventListener("transitionend", this.transitionendHandler);
        this.collapsedBreadcrumbEl &&
            this.collapsedBreadcrumbEl.removeEventListener("click", this.clickHandler);
    }
    render() {
        return (h(Host, { class: {
                back: this.backBreadcrumbOnly,
                collapsed: this.collapsed,
            } }, h("nav", { "aria-label": "breadcrumbs" }, h("ol", null, h("slot", null)))));
    }
    static get is() { return "ic-breadcrumb-group"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-breadcrumb-group.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-breadcrumb-group.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForeground",
                    "resolved": "\"dark\" | \"default\" | \"light\"",
                    "references": {
                        "IcThemeForeground": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForeground"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the breadcrumb group."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "backBreadcrumbOnly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, display only a single breadcrumb for the parent page with a back icon."
                },
                "attribute": "back-breadcrumb-only",
                "reflect": false,
                "defaultValue": "false"
            },
            "collapsed": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, all breadcrumbs between the first and last breadcrumb will be collapsed."
                },
                "attribute": "collapsed",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "deviceSize": {},
            "expandedBreadcrumbs": {}
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "appearance",
                "methodName": "watchAppearanceHandler"
            }, {
                "propName": "backBreadcrumbOnly",
                "methodName": "watchBackBreadcrumbHandler"
            }];
    }
}
//# sourceMappingURL=ic-breadcrumb-group.js.map
