import { Host, h } from "@stencil/core";
import chevronIcon from "../../assets/chevron-icon.svg";
import backIcon from "../../assets/back-icon.svg";
import { isPropDefined, isSlotUsed } from "../../utils/helpers";
/**
 * @slot icon - Content will be rendered to the left of the breadcrumb page title.
 */
export class Breadcrumb {
    constructor() {
        this.renderDefaultBreadcrumb = (current, pageTitle, describedById, href) => {
            const hasPageTitle = pageTitle !== null && isPropDefined(pageTitle) && pageTitle !== "";
            if (current && hasPageTitle) {
                return (h("span", { class: {
                        "current-page-container": current,
                        [this.appearance]: true,
                    } }, isSlotUsed(this.el, "icon") && h("slot", { name: "icon" }), pageTitle));
            }
            return (h("ic-link", { appearance: this.appearance, href: href, class: "breadcrumb-link", "aria-describedby": this.showBackIcon && describedById && describedById }, this.showBackIcon && (h("div", { class: "back-icon", innerHTML: backIcon })), isSlotUsed(this.el, "icon") && h("slot", { name: "icon" }), pageTitle));
        };
        this.setSlottedCurrentPageClass = () => {
            const icLink = this.el.querySelector("ic-link");
            const currentPage = "current-page";
            if (icLink) {
                icLink.classList.remove(currentPage);
                if (this.current) {
                    const hasCurrentPageClass = icLink.classList.contains(currentPage);
                    if (!hasCurrentPageClass) {
                        icLink.classList.add("breadcrumb-link", currentPage);
                    }
                }
            }
        };
        this.appearance = "default";
        this.current = false;
        this.href = undefined;
        this.pageTitle = undefined;
        this.showBackIcon = false;
    }
    componentWillRender() {
        this.setSlottedCurrentPageClass();
    }
    /**
     * Sets focus on the breadcrumb.
     */
    async setFocus() {
        if (this.el.shadowRoot.querySelector("ic-link")) {
            this.el.shadowRoot.querySelector("ic-link").focus();
        }
    }
    render() {
        const { current, href, pageTitle } = this;
        const describedById = `${pageTitle && pageTitle.toLowerCase().replace(" ", "-")}-describedby`;
        const hasPageTitle = pageTitle !== null && isPropDefined(pageTitle) && pageTitle !== "";
        const hasHref = href !== null && isPropDefined(href) && href !== "";
        return (h(Host, { class: {
                back: this.showBackIcon,
            }, "aria-current": current && "page", role: "listitem" }, h("div", { class: "breadcrumb" }, h("span", { innerHTML: chevronIcon, class: "chevron", "aria-hidden": "true" }), this.showBackIcon && describedById && (h("span", { id: describedById, class: "hide" }, `Back to ${pageTitle}`)), hasPageTitle && hasHref ? (this.renderDefaultBreadcrumb(current, pageTitle, describedById, href)) : (h("slot", null)))));
    }
    static get is() { return "ic-breadcrumb"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-breadcrumb.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-breadcrumb.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForeground",
                    "resolved": "\"dark\" | \"default\" | \"light\"",
                    "references": {
                        "IcThemeForeground": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForeground"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The appearance of the breadcrumb."
                        }],
                    "text": ""
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "current": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, aria-current will be set on the breadcrumb."
                },
                "attribute": "current",
                "reflect": false,
                "defaultValue": "false"
            },
            "href": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The URL that the breadcrumb link points to."
                },
                "attribute": "href",
                "reflect": false
            },
            "pageTitle": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The title of the breadcrumb."
                },
                "attribute": "page-title",
                "reflect": false
            },
            "showBackIcon": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, back icon will be displayed."
                        }],
                    "text": ""
                },
                "attribute": "show-back-icon",
                "reflect": true,
                "defaultValue": "false"
            }
        };
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the breadcrumb.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-breadcrumb.js.map
