var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { Host, forceUpdate, h, } from "@stencil/core";
import { getThemeFromContext, inheritAttributes, isSlotUsed, removeDisabledFalse, renderFileHiddenInput, } from "../../utils/helpers";
import { IC_INHERITED_ARIA } from "../../utils/constants";
import { IcThemeForegroundEnum, } from "../../utils/types";
import arrowDropdown from "../../assets/arrow-dropdown.svg";
let buttonIds = 0;
/**
 * @slot icon - Deprecated. This slot should not be used anymore. Use left-icon or right-icon slot instead.
 * @slot left-icon - Content will be placed to the left of the button label.
 * @slot right-icon - Content will be placed to the right of the button label.
 * @slot top-icon - Content will be placed above the button label.
 * @slot badge - Badge component overlaying the top right of the button.
 * @slot router-item - Handle routing by nesting your routes in this slot. Setting loading to true will have no impact on this slot.
 */
export class Button {
    constructor() {
        this.buttonIdNum = buttonIds++;
        this.hasTooltip = false;
        this.inheritedAttributes = {};
        this.describedbyEl = null;
        this.describedById = null;
        this.mutationObserver = null;
        this.hostMutationObserver = null;
        this.handleClick = () => {
            if ((this.el.type === "submit" || this.el.type === "reset") &&
                !this.hasRouterSlot() &&
                !!this.el.closest("FORM")) {
                const hiddenFormButton = document.createElement("button");
                hiddenFormButton.setAttribute("type", this.el.type);
                hiddenFormButton.style.display = "none";
                this.el.closest("FORM").appendChild(hiddenFormButton);
                hiddenFormButton.click();
                hiddenFormButton.remove();
            }
        };
        this.handleKeyDown = (ev) => {
            if (ev.key === "Escape" && this.hasTooltip) {
                this.closeButtonTooltip(ev);
            }
        };
        this.onFocus = () => {
            this.icFocus.emit();
        };
        this.onBlur = () => {
            this.icBlur.emit();
        };
        // triggered when text content of sibling element in light DOM changes
        this.mutationCallback = () => {
            this.describedByContent = this.describedbyEl.innerText;
        };
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName }) => {
                const attribute = this.el.getAttribute(attributeName);
                if (attributeName === "title")
                    this.title = attribute;
                else if (attributeName === "aria-label")
                    this.ariaLabel = attribute;
                if (IC_INHERITED_ARIA.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] = attribute;
                    forceComponentUpdate = true;
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.setHasTooltip = () => {
            this.hasTooltip =
                !this.disableTooltip && (!!this.title || this.isIconVariant());
        };
        this.isIconVariant = () => {
            return this.variant.startsWith("icon");
        };
        this.ariaLabel = null;
        this.describedByContent = null;
        this.title = null;
        this.accept = "*";
        this.appearance = "default";
        this.ariaControlsId = undefined;
        this.ariaOwnsId = undefined;
        this.disabled = false;
        this.disableTooltip = false;
        this.download = false;
        this.dropdown = false;
        this.dropdownExpanded = false;
        this.fileUpload = false;
        this.fileInputName = `ic-button-file-upload-input-${buttonIds++}`;
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.fullWidth = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.loading = false;
        this.multiple = false;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.selectedFiles = undefined;
        this.size = "default";
        this.target = undefined;
        this.tooltipPlacement = "bottom";
        this.transparentBackground = true;
        this.type = "button";
        this.variant = "primary";
    }
    watchDisabledHandler() {
        removeDisabledFalse(this.disabled, this.el);
    }
    disconnectedCallback() {
        if (this.mutationObserver !== null && this.mutationObserver !== undefined) {
            this.mutationObserver.disconnect();
        }
        if (this.hostMutationObserver !== null &&
            this.hostMutationObserver !== undefined) {
            this.hostMutationObserver.disconnect();
        }
    }
    componentWillUpdate() {
        if (this.loading) {
            this.el.style.setProperty("--min-width", `${this.el.getBoundingClientRect().width}px`);
        }
        this.setHasTooltip();
    }
    componentWillLoad() {
        const _a = inheritAttributes(this.el, [...IC_INHERITED_ARIA, "title"]), { title, "aria-label": ariaLabel } = _a, restInheritedAttributes = __rest(_a, ["title", "aria-label"]);
        this.title = title;
        this.ariaLabel = ariaLabel;
        this.inheritedAttributes = restInheritedAttributes;
        removeDisabledFalse(this.disabled, this.el);
        this.el.setAttribute("exportparts", "button");
        this.id = this.el.id || null;
        this.setHasTooltip();
        if (!this.hasTooltip) {
            const describedById = this.inheritedAttributes["aria-describedby"];
            if (describedById !== undefined) {
                this.describedById = describedById;
                const el = this.el.parentElement.querySelector(`#${describedById}`);
                if (el) {
                    this.describedByContent = el.innerText;
                    this.describedbyEl = el;
                }
            }
        }
    }
    componentDidLoad() {
        this.updateTheme();
        if (typeof MutationObserver !== "undefined") {
            if (this.describedById) {
                this.mutationObserver = new MutationObserver(this.mutationCallback);
                this.mutationObserver.observe(this.describedbyEl, {
                    characterData: true,
                    childList: true,
                    subtree: true,
                });
            }
            this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
            this.hostMutationObserver.observe(this.el, {
                attributes: true,
            });
        }
    }
    componentWillRender() {
        const iconEl = this.hasIconSlot("left")
            ? this.el.querySelector(`[slot="left-icon"]`)
            : this.hasIconSlot("right")
                ? this.el.querySelector(`[slot="right-icon"]`)
                : null;
        iconEl === null || iconEl === void 0 ? void 0 : iconEl.setAttribute("viewBox", "0 0 24 24");
    }
    handleHostClick(event) {
        if (!this.hasRouterSlot()) {
            if (this.fileUpload) {
                renderFileHiddenInput(this.icFileSelection, this.el, this.multiple, this.fileInputName, this.selectedFiles, this.disabled, this.accept);
            }
            if (this.disabled || this.loading) {
                event.stopImmediatePropagation();
            }
            if (this.dropdown) {
                this.dropdownExpanded = !this.dropdownExpanded;
            }
        }
    }
    themeChangeHandler({ detail }) {
        this.updateTheme(detail.mode);
    }
    /**
     * Sets focus on the native `button`.
     */
    async setFocus() {
        var _a;
        (_a = this.buttonEl) === null || _a === void 0 ? void 0 : _a.focus();
    }
    async closeButtonTooltip(ev) {
        const tooltip = this.el.shadowRoot.querySelector("ic-tooltip");
        if (await tooltip.isTooltipVisible()) {
            tooltip.displayTooltip(false);
            ev.preventDefault();
            ev.stopImmediatePropagation();
        }
    }
    hasIconSlot(position) {
        const selectorPrefix = position ? `${position}-` : "";
        return this.el.querySelector(`[slot="${selectorPrefix}icon"]`) !== null;
    }
    hasRouterSlot() {
        this.routerSlot = this.el.querySelector('[slot="router-item"]');
        if (this.routerSlot) {
            this.routerSlot.ariaLabel = this.routerSlot.textContent;
        }
        return !!this.routerSlot;
    }
    updateTheme(newTheme = null) {
        const foregroundColor = getThemeFromContext(this.el, newTheme);
        if (foregroundColor !== IcThemeForegroundEnum.Default) {
            this.appearance = foregroundColor;
        }
    }
    render() {
        const TagType = (this.href && "a") || "button";
        const { title, ariaLabel, inheritedAttributes } = this;
        const buttonAttrs = TagType === "button"
            ? {
                type: this.type,
                disabled: this.disabled,
                form: this.form,
                formaction: this.formaction,
                formenctype: this.formenctype,
                formmethod: this.formmethod,
                formnovalidate: this.formnovalidate,
                formtarget: this.formtarget,
            }
            : {
                download: this.download !== false ? this.download : null,
                href: this.href,
                rel: this.rel,
                target: this.target,
                referrerpolicy: this.referrerpolicy,
                hreflang: this.hreflang,
            };
        let describedby = null;
        let buttonId = null;
        if (this.hasTooltip) {
            buttonId =
                this.id !== null
                    ? `ic-button-with-tooltip-${this.id}`
                    : `ic-button-with-tooltip-${this.buttonIdNum}`;
            describedby =
                this.variant === "icon" && !!ariaLabel
                    ? null
                    : `ic-tooltip-${buttonId}`;
        }
        else {
            describedby = this.describedById;
        }
        const ButtonContent = () => {
            return (h(TagType, Object.assign({ class: "button", "aria-disabled": this.loading || this.disabled ? "true" : null, "aria-label": this.loading ? "Loading" : ariaLabel, "aria-expanded": this.dropdown && `${this.dropdownExpanded}` }, buttonAttrs, inheritedAttributes, { onFocus: this.onFocus, onBlur: this.onBlur, ref: (el) => (this.buttonEl = el), "aria-describedby": describedby, part: "button" }), this.hasIconSlot() && !this.loading && (h("div", { class: "icon-container" }, h("slot", { name: "icon" }))), this.hasIconSlot("left") && !this.loading && (h("div", { class: "icon-container" }, h("slot", { name: "left-icon" }))), this.hasIconSlot("top") &&
                !this.hasIconSlot("left") &&
                !this.hasIconSlot("right") &&
                !this.loading && (h("div", { class: "icon-container" }, h("slot", { name: "top-icon" }))), this.loading ? (h("div", { class: "loading-container" }, h("ic-loading-indicator", { type: "linear", appearance: this.variant === "primary" ||
                    this.variant === "destructive" ||
                    this.appearance === IcThemeForegroundEnum.Dark ||
                    this.appearance === IcThemeForegroundEnum.Light
                    ? "light"
                    : "dark" }))) : (h("slot", null)), this.hasIconSlot("right") && !this.loading && !this.dropdown && (h("div", { class: { "icon-container": true, "right-icon": true } }, h("slot", { name: "right-icon" }))), this.dropdown &&
                !this.loading &&
                this.variant !== "icon" &&
                this.variant !== "destructive" && (h("span", { class: {
                    ["arrow-dropdown"]: !this.dropdownExpanded,
                    ["dropdown-expanded"]: this.dropdownExpanded,
                }, innerHTML: arrowDropdown }))));
        };
        return (h(Host, { class: {
                ["disabled"]: this.disabled && !this.loading,
                [`button-variant-${this.variant}`]: true,
                [`button-size-${this.size}`]: true,
                ["loading"]: this.loading,
                ["dark"]: this.appearance === IcThemeForegroundEnum.Dark,
                ["light"]: this.appearance === IcThemeForegroundEnum.Light,
                ["full-width"]: this.fullWidth,
                ["with-badge"]: isSlotUsed(this.el, "badge"),
                ["dropdown-no-icon"]: this.dropdown &&
                    !isSlotUsed(this.el, "icon") &&
                    !isSlotUsed(this.el, "left-icon"),
                ["top-icon"]: isSlotUsed(this.el, "top-icon"),
                ["white-background"]: this.variant === "secondary" &&
                    !this.transparentBackground &&
                    this.appearance !== "light",
            }, onClick: this.handleClick, onKeyDown: this.handleKeyDown, "aria-owns": this.ariaOwnsId, "aria-controls": this.ariaControlsId, "aria-expanded": this.dropdown && `${this.dropdownExpanded}` }, this.hasTooltip && (h("ic-tooltip", { id: describedby, label: title || ariaLabel, target: buttonId, placement: this.tooltipPlacement, silent: this.isIconVariant() && !!ariaLabel }, this.hasRouterSlot() ? (h("slot", { name: "router-item" })) : (h(ButtonContent, null)))), isSlotUsed(this.el, "badge") && h("slot", { name: "badge" }), !this.hasTooltip &&
            (this.hasRouterSlot() ? (h("slot", { name: "router-item" })) : (h(ButtonContent, null))), this.describedByContent && (h("span", { id: describedby, class: "ic-button-describedby" }, this.describedByContent))));
    }
    static get is() { return "ic-button"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-button.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-button.css"]
        };
    }
    static get properties() {
        return {
            "accept": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `fileUpload` is set to `true`, this is the accepted list of file types."
                },
                "attribute": "accept",
                "reflect": false,
                "defaultValue": "\"*\""
            },
            "appearance": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "IcThemeForeground",
                    "resolved": "\"dark\" | \"default\" | \"light\"",
                    "references": {
                        "IcThemeForeground": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForeground"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the button, e.g. dark, light, or the default."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "ariaControlsId": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | boolean",
                    "resolved": "boolean | string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Used to identify any related child component"
                        }],
                    "text": ""
                },
                "attribute": "aria-controls-id",
                "reflect": false
            },
            "ariaOwnsId": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | boolean",
                    "resolved": "boolean | string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Used to identify any related child component"
                        }],
                    "text": ""
                },
                "attribute": "aria-owns-id",
                "reflect": false
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the button will be in disabled state."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "disableTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the ic-tooltip which is shown for icon variant will be disabled. Title or aria-label must be set if this prop is not applied."
                },
                "attribute": "disable-tooltip",
                "reflect": false,
                "defaultValue": "false"
            },
            "download": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | boolean",
                    "resolved": "boolean | string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the user can save the linked URL instead of navigating to it."
                },
                "attribute": "download",
                "reflect": false,
                "defaultValue": "false"
            },
            "dropdown": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the button will show a dropdown icon."
                },
                "attribute": "dropdown",
                "reflect": false,
                "defaultValue": "false"
            },
            "dropdownExpanded": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the aria-expanded value will be set to true. This is only applied if the dropdown prop is also true."
                },
                "attribute": "dropdown-expanded",
                "reflect": true,
                "defaultValue": "false"
            },
            "fileUpload": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, when the button is clicked the native file explorer will be launched."
                },
                "attribute": "file-upload",
                "reflect": false,
                "defaultValue": "false"
            },
            "fileInputName": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The name of the control for the file input, which is submitted with the form data."
                },
                "attribute": "file-input-name",
                "reflect": false,
                "defaultValue": "`ic-button-file-upload-input-${buttonIds++}`"
            },
            "form": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The <form> element to associate the button with."
                },
                "attribute": "form",
                "reflect": false
            },
            "formaction": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The URL that processes the information submitted by the button. It overrides the action attribute of the button's form owner. Does nothing if there is no form owner."
                },
                "attribute": "formaction",
                "reflect": false
            },
            "formenctype": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The way the submitted form data is encoded."
                },
                "attribute": "formenctype",
                "reflect": false
            },
            "formmethod": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The HTTP method used to submit the form."
                },
                "attribute": "formmethod",
                "reflect": false
            },
            "formnovalidate": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the form will not be validated when submitted."
                },
                "attribute": "formnovalidate",
                "reflect": false
            },
            "formtarget": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The place to display the response from submitting the form. It overrides the target attribute of the button's form owner."
                },
                "attribute": "formtarget",
                "reflect": false
            },
            "fullWidth": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the button will fill the width of the container."
                },
                "attribute": "full-width",
                "reflect": false,
                "defaultValue": "false"
            },
            "href": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The URL that the link points to. This will render the button as an \"a\" tag."
                },
                "attribute": "href",
                "reflect": false
            },
            "hreflang": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The human language of the linked URL."
                },
                "attribute": "hreflang",
                "reflect": false
            },
            "loading": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the button will be in loading state."
                },
                "attribute": "loading",
                "reflect": false,
                "defaultValue": "false"
            },
            "multiple": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `fileUpload` is set to `true`, this boolean determines whether multiple files are accepted."
                },
                "attribute": "multiple",
                "reflect": false,
                "defaultValue": "false"
            },
            "referrerpolicy": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "ReferrerPolicy",
                    "resolved": "\"\" | \"no-referrer\" | \"no-referrer-when-downgrade\" | \"origin\" | \"origin-when-cross-origin\" | \"same-origin\" | \"strict-origin\" | \"strict-origin-when-cross-origin\" | \"unsafe-url\"",
                    "references": {
                        "ReferrerPolicy": {
                            "location": "global",
                            "id": "global::ReferrerPolicy"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "How much of the referrer to send when following the link."
                },
                "attribute": "referrerpolicy",
                "reflect": false
            },
            "rel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The relationship of the linked URL as space-separated link types."
                },
                "attribute": "rel",
                "reflect": false
            },
            "selectedFiles": {
                "type": "unknown",
                "mutable": false,
                "complexType": {
                    "original": "FileList",
                    "resolved": "FileList",
                    "references": {
                        "FileList": {
                            "location": "global",
                            "id": "global::FileList"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The list of the files that have been selected by a user."
                }
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the button to be displayed."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "target": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe)."
                },
                "attribute": "target",
                "reflect": false
            },
            "tooltipPlacement": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcButtonTooltipPlacement",
                    "resolved": "\"bottom\" | \"left\" | \"right\" | \"top\"",
                    "references": {
                        "IcButtonTooltipPlacement": {
                            "location": "import",
                            "path": "./ic-button.types",
                            "id": "src/components/ic-button/ic-button.types.ts::IcButtonTooltipPlacement"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The position of the tooltip in relation to the button."
                },
                "attribute": "tooltip-placement",
                "reflect": false,
                "defaultValue": "\"bottom\""
            },
            "transparentBackground": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the secondary variant of button will have a transparent background rather than white."
                },
                "attribute": "transparent-background",
                "reflect": false,
                "defaultValue": "true"
            },
            "type": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcButtonTypes",
                    "resolved": "\"button\" | \"reset\" | \"submit\"",
                    "references": {
                        "IcButtonTypes": {
                            "location": "import",
                            "path": "./ic-button.types",
                            "id": "src/components/ic-button/ic-button.types.ts::IcButtonTypes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The type of the button."
                },
                "attribute": "type",
                "reflect": false,
                "defaultValue": "\"button\""
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcButtonVariants",
                    "resolved": "\"destructive\" | \"icon\" | \"icon-destructive\" | \"icon-primary\" | \"icon-secondary\" | \"icon-tertiary\" | \"primary\" | \"secondary\" | \"tertiary\"",
                    "references": {
                        "IcButtonVariants": {
                            "location": "import",
                            "path": "./ic-button.types",
                            "id": "src/components/ic-button/ic-button.types.ts::IcButtonVariants"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The variant of the button to be displayed."
                },
                "attribute": "variant",
                "reflect": false,
                "defaultValue": "\"primary\""
            }
        };
    }
    static get states() {
        return {
            "ariaLabel": {},
            "describedByContent": {},
            "title": {}
        };
    }
    static get events() {
        return [{
                "method": "icBlur",
                "name": "icBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when button has blur"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "icFileSelection",
                "name": "icFileSelection",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "If `fileUpload` is set to `true`, this will be emitted when a file is selected in the native explorer."
                },
                "complexType": {
                    "original": "FileList",
                    "resolved": "FileList",
                    "references": {
                        "FileList": {
                            "location": "global",
                            "id": "global::FileList"
                        }
                    }
                }
            }, {
                "method": "icFocus",
                "name": "icFocus",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when button has focus"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the native `button`.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "disabled",
                "methodName": "watchDisabledHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "click",
                "method": "handleHostClick",
                "target": undefined,
                "capture": true,
                "passive": false
            }, {
                "name": "themeChange",
                "method": "themeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-button.js.map
