import { Host, h, } from "@stencil/core";
import { getInputDescribedByText, hasValidationStatus, onComponentRequiredPropUndefined, removeDisabledFalse, } from "../../utils/helpers";
// eslint-disable-next-line @typescript-eslint/no-unused-vars
export class CheckboxGroup {
    constructor() {
        this.disabled = false;
        this.helperText = "";
        this.hideLabel = false;
        this.label = undefined;
        this.name = undefined;
        this.required = false;
        this.size = "default";
        this.small = false;
        this.validationStatus = "";
        this.validationText = "";
    }
    labelNameHandler(newValue, oldValue, propName) {
        Array.from(this.el.querySelectorAll("ic-checkbox")).forEach((checkbox) => {
            if (propName === "label")
                checkbox.groupLabel = newValue;
            else if (checkbox.name === oldValue) {
                // If the checkbox name has been set by the parent, then override it
                checkbox.name = newValue;
            }
        });
    }
    handleChange(ev) {
        //don't pass on the event if it has come from slotted text field
        //otherwise any icChange handler bound to the checkbox group will also run
        if (ev.target.tagName === "IC-TEXT-FIELD") {
            ev.stopImmediatePropagation();
        }
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([
            { prop: this.label, propName: "label" },
            { prop: this.name, propName: "name" },
        ], "Checkbox Group");
    }
    selectHandler({ target }) {
        const checkedOptions = Array.from(this.el.querySelectorAll("ic-checkbox")).filter(({ checked, disabled }) => checked && !disabled);
        this.icChange.emit({
            value: checkedOptions.map(({ value }) => value),
            checkedOptions: checkedOptions.map((opt) => {
                var _a;
                return ({
                    checkbox: opt,
                    textFieldValue: (_a = opt.querySelector("ic-text-field")) === null || _a === void 0 ? void 0 : _a.value,
                });
            }),
            selectedOption: target,
        });
    }
    render() {
        const { disabled, helperText, hideLabel, label, name, required, size, small, validationStatus, validationText, } = this;
        const describedBy = getInputDescribedByText(name, helperText !== "", validationStatus !== "");
        return (h(Host, { class: { ["small"]: small, [`${size}`]: true } }, (validationStatus === "error" || required || hideLabel) && (h("span", { id: "screenReaderOnlyText", class: "screen-reader-only-text", "aria-hidden": "true" }, label, " ", validationStatus === "error" ? "invalid data " : null, " ", required ? "required" : null)), h("fieldset", { id: name, "aria-labelledby": `${validationStatus === "error" || required || hideLabel
                ? "screenReaderOnlyText"
                : ""} ${describedBy}`.trim(), disabled: disabled }, !hideLabel && (h("legend", null, h("ic-input-label", { class: { [`${validationStatus}`]: true }, label: label, helperText: helperText, required: required, disabled: disabled, for: name }))), h("div", { class: "checkboxes-container" }, h("slot", null))), hasValidationStatus(validationStatus, disabled) && (h("ic-input-validation", { for: name, ariaLiveMode: "polite", status: validationStatus, message: validationText }))));
    }
    static get is() { return "ic-checkbox-group"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-checkbox-group.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-checkbox-group.css"]
        };
    }
    static get properties() {
        return {
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the checkbox group will be set to the disabled state."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The helper text that will be displayed for additional field guidance."
                },
                "attribute": "helper-text",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "hideLabel": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the label will be hidden and the required label value will be applied as an aria-label."
                },
                "attribute": "hide-label",
                "reflect": false,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label for the checkbox group to be displayed."
                },
                "attribute": "label",
                "reflect": false
            },
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The name for the checkbox group to differentiate from other groups."
                },
                "attribute": "name",
                "reflect": false
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the checkbox group will require a value."
                },
                "attribute": "required",
                "reflect": false,
                "defaultValue": "false"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the checkboxes to be displayed. This does not affect the font size of the label."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "validationStatus": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcInformationStatusOrEmpty",
                    "resolved": "\"\" | \"error\" | \"success\" | \"warning\"",
                    "references": {
                        "IcInformationStatusOrEmpty": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcInformationStatusOrEmpty"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The validation status - e.g. 'error' | 'warning' | 'success'."
                },
                "attribute": "validation-status",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "validationText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The validation text - e.g. 'error' | 'warning' | 'success'."
                },
                "attribute": "validation-text",
                "reflect": false,
                "defaultValue": "\"\""
            }
        };
    }
    static get events() {
        return [{
                "method": "icChange",
                "name": "icChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when a checkbox is checked."
                },
                "complexType": {
                    "original": "IcChangeEventDetail",
                    "resolved": "IcChangeEventDetail",
                    "references": {
                        "IcChangeEventDetail": {
                            "location": "import",
                            "path": "./ic-checkbox-group.types",
                            "id": "src/components/ic-checkbox-group/ic-checkbox-group.types.ts::IcChangeEventDetail"
                        }
                    }
                }
            }];
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "label",
                "methodName": "labelNameHandler"
            }, {
                "propName": "name",
                "methodName": "labelNameHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "icChange",
                "method": "handleChange",
                "target": undefined,
                "capture": false,
                "passive": false
            }, {
                "name": "icCheck",
                "method": "selectHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-checkbox-group.js.map
