import { Host, h, } from "@stencil/core";
import { isSlotUsed, onComponentRequiredPropUndefined, renderHiddenInput, removeHiddenInput, addFormResetListener, removeFormResetListener, removeDisabledFalse, isPropDefined, } from "../../utils/helpers";
/**
 * @slot additional-field - Content to be displayed alongside a checkbox.
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
export class Checkbox {
    constructor() {
        this.handleClick = () => {
            this.checked = !this.checked;
            this.displayIndeterminate = this.nativeIndeterminateBehaviour
                ? false
                : this.indeterminate && this.checked;
            this.icCheck.emit();
            this.checkboxChecked.emit();
        };
        this.handleFormReset = () => {
            this.checked = this.initiallyChecked;
        };
        this.additionalFieldDisplay = "static";
        this.checked = false;
        this.initiallyChecked = this.checked;
        this.disabled = false;
        this.dynamicText = "This selection requires additional answers";
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.groupLabel = undefined;
        this.indeterminate = false;
        this.displayIndeterminate = this.indeterminate;
        this.label = undefined;
        this.name = undefined;
        this.nativeIndeterminateBehaviour = false;
        this.size = undefined;
        this.small = false;
        this.value = undefined;
        this.hideLabel = false;
    }
    watchIndeterminateHandler() {
        this.displayIndeterminate = this.nativeIndeterminateBehaviour
            ? this.indeterminate
            : this.indeterminate && this.checked;
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
        addFormResetListener(this.el, this.handleFormReset);
        const checkboxGroup = this.el.parentElement;
        if (checkboxGroup) {
            if (!this.name)
                this.name = checkboxGroup.name;
            this.groupLabel = checkboxGroup.label;
        }
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([
            { prop: this.label, propName: "label" },
            { prop: this.value, propName: "value" },
        ], "Checkbox");
    }
    componentDidRender() {
        if (this.additionalFieldDisplay === "static") {
            const textfield = this.el.querySelector("ic-text-field");
            if (!this.checked) {
                textfield === null || textfield === void 0 ? void 0 : textfield.setAttribute("disabled", "");
            }
            else {
                textfield === null || textfield === void 0 ? void 0 : textfield.removeAttribute("disabled");
            }
        }
        else if (this.additionalFieldContainer) {
            this.additionalFieldContainer.style.display = !this.checked
                ? "none"
                : "flex";
        }
    }
    disconnectedCallback() {
        removeFormResetListener(this.el, this.handleFormReset);
    }
    /**
     * Sets focus on the checkbox.
     */
    async setFocus() {
        var _a;
        (_a = this.el.shadowRoot.querySelector(".checkbox")) === null || _a === void 0 ? void 0 : _a.focus();
    }
    render() {
        const { additionalFieldDisplay, checked, disabled, dynamicText, el, form, formaction, formenctype, formmethod, formnovalidate, formtarget, displayIndeterminate, groupLabel, label, name, size, small, value, } = this;
        const id = `ic-checkbox-${isPropDefined(label) || value}-${groupLabel}`.replace(/ /g, "-");
        const parentElementSize = el.parentElement
            .size;
        checked
            ? renderHiddenInput(true, el, name, checked && value, disabled)
            : removeHiddenInput(el);
        return (h(Host, { class: {
                disabled,
                small,
                [`${size || parentElementSize}`]: true,
            } }, h("div", { class: "container" }, displayIndeterminate && h("div", { class: "indeterminate-symbol" }), !displayIndeterminate && checked && (h("svg", { class: "checkmark", width: "1.5rem", height: "1.5rem", viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", "fill-rule": "evenodd", "clip-rule": "evenodd" }, h("title", null, "checkmark icon"), h("path", { d: "M21 6.285l-11.16 12.733-6.84-6.018 1.319-1.49 5.341 4.686 9.865-11.196 1.475 1.285z" }))), h("input", { role: "checkbox", class: {
                checkbox: true,
                checked,
                indeterminate: displayIndeterminate,
            }, type: "checkbox", name: name, id: id, value: value, disabled: disabled ? true : null, checked: checked, indeterminate: displayIndeterminate, onClick: this.handleClick, form: form, formaction: formaction, formenctype: formenctype, formmethod: formmethod, formnovalidate: formnovalidate, formtarget: formtarget, "aria-label": this.hideLabel ? this.label : undefined }), !this.hideLabel && (h("ic-typography", { class: "checkbox-label", variant: "body" }, h("label", { htmlFor: id }, label)))), isSlotUsed(el, "additional-field") && (h("div", { class: "dynamic-container", ref: (el) => (this.additionalFieldContainer = el) }, additionalFieldDisplay === "dynamic" && (h("div", { class: "branch-corner" })), h("div", null, additionalFieldDisplay === "dynamic" && (h("ic-typography", { variant: "caption" }, h("p", { class: "dynamic-text", "aria-live": "polite" }, dynamicText))), h("div", { class: {
                "additional-field-wrapper": additionalFieldDisplay === "static",
            } }, h("slot", { name: "additional-field" })))))));
    }
    static get is() { return "ic-checkbox"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-checkbox.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-checkbox.css"]
        };
    }
    static get properties() {
        return {
            "additionalFieldDisplay": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcAdditionalFieldTypes",
                    "resolved": "\"dynamic\" | \"static\"",
                    "references": {
                        "IcAdditionalFieldTypes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcAdditionalFieldTypes"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The style of additionalField that will be displayed if used."
                },
                "attribute": "additional-field-display",
                "reflect": true,
                "defaultValue": "\"static\""
            },
            "checked": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the checkbox will be set to the checked state."
                },
                "attribute": "checked",
                "reflect": true,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the checkbox will be set to the disabled state."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "dynamicText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The text to be displayed when dynamic."
                },
                "attribute": "dynamic-text",
                "reflect": false,
                "defaultValue": "\"This selection requires additional answers\""
            },
            "form": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The <form> element to associate the checkbox with."
                },
                "attribute": "form",
                "reflect": false
            },
            "formaction": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The URL that processes the information submitted by the checkbox. It overrides the action attribute of the checkbox's form owner. Does nothing if there is no form owner."
                },
                "attribute": "formaction",
                "reflect": false
            },
            "formenctype": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The way the submitted form data is encoded."
                },
                "attribute": "formenctype",
                "reflect": false
            },
            "formmethod": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The HTTP method used to submit the form."
                },
                "attribute": "formmethod",
                "reflect": false
            },
            "formnovalidate": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the form will not be validated when submitted."
                },
                "attribute": "formnovalidate",
                "reflect": false
            },
            "formtarget": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The place to display the response from submitting the form. It overrides the target attribute of the checkbox's form owner."
                },
                "attribute": "formtarget",
                "reflect": false
            },
            "groupLabel": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The group label for the checkbox."
                },
                "attribute": "group-label",
                "reflect": false
            },
            "indeterminate": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the indeterminate state will be displayed when checked."
                },
                "attribute": "indeterminate",
                "reflect": false,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label for the checkbox."
                },
                "attribute": "label",
                "reflect": false
            },
            "name": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The name for the checkbox. If not set when used in a checkbox group, the name will be based on the group name."
                },
                "attribute": "name",
                "reflect": false
            },
            "nativeIndeterminateBehaviour": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the checkbox will behave like a native checkbox where the `indeterminate` prop sets the indeterminate visual styling, independent of the `checked` state."
                },
                "attribute": "native-indeterminate-behaviour",
                "reflect": false,
                "defaultValue": "false"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the checkbox to be displayed. This does not affect the font size of the label. If a checkbox is contained in a checkbox group, this will override the size set on checkbox group."
                },
                "attribute": "size",
                "reflect": false
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "value": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The value for the checkbox."
                },
                "attribute": "value",
                "reflect": false
            },
            "hideLabel": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the label will be hidden and the required label value will be applied as an aria-label."
                },
                "attribute": "hide-label",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "initiallyChecked": {},
            "displayIndeterminate": {}
        };
    }
    static get events() {
        return [{
                "method": "checkboxChecked",
                "name": "checkboxChecked",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This event should not be used anymore. Use icCheck instead."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "icCheck",
                "name": "icCheck",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when a checkbox has been checked."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLElement": {
                            "location": "global",
                            "id": "global::HTMLElement"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the checkbox.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "indeterminate",
                "methodName": "watchIndeterminateHandler"
            }];
    }
}
//# sourceMappingURL=ic-checkbox.js.map
