import { h, } from "@stencil/core";
import { onComponentRequiredPropUndefined, isSlotUsed, removeDisabledFalse, convertToRGBA, isElInAGGrid, } from "../../utils/helpers";
import dismissIcon from "../../assets/dismiss-icon.svg";
/**
 * @slot icon - Content will be rendered at the start of the chip.
 * @slot badge - Badge component overlaying the top right of the chip.
 */
export class Chip {
    constructor() {
        this.inAGGrid = false;
        this.dismissAction = () => {
            this.dismiss.emit();
            this.icDismiss.emit();
        };
        this.mouseEnterHandler = () => {
            this.hovered = true;
        };
        this.mouseLeaveHandler = () => {
            this.hovered = false;
        };
        this.setChipColour = () => {
            const colorRGBA = convertToRGBA(this.customColor);
            if (colorRGBA) {
                const { r, g, b, a } = colorRGBA;
                const foregroundColour = (r * 299 + g * 587 + b * 114) / 1000 > 133.3505 ? "black" : "white";
                this.el.setAttribute("style", `--chip-custom-color: rgba(${r}, ${g}, ${b}, ${a}); --chip-custom-foreground-color: var(--ic-architectural-${foregroundColour})`);
            }
        };
        this.hovered = false;
        this.visible = true;
        this.appearance = undefined;
        this.customColor = null;
        this.disabled = false;
        this.dismissible = false;
        this.label = undefined;
        this.size = "default";
        this.transparentBackground = true;
        this.variant = "filled";
    }
    customColorHandler() {
        if (!this.dismissible) {
            this.setChipColour();
        }
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
        if (!this.dismissible) {
            this.setChipColour();
        }
        if (this.appearance === "outline") {
            this.variant = "outlined";
        }
    }
    componentWillRender() {
        if (isElInAGGrid(this.el)) {
            this.inAGGrid = true;
        }
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Chip");
    }
    handleClick() {
        this.visible = !this.visible;
    }
    /**
     * Sets focus on the chip.
     */
    async setFocus() {
        var _a;
        (_a = this.el.shadowRoot.querySelector("button")) === null || _a === void 0 ? void 0 : _a.focus();
    }
    render() {
        const { label, appearance, variant, size, dismissible, visible, disabled, hovered, } = this;
        return (visible && (h("div", { class: {
                chip: true,
                [`${appearance}`]: appearance !== undefined,
                [`${variant}`]: true,
                [`${size}`]: true,
                disabled,
                dismissible,
                hovered,
                "white-background": this.variant === "outlined" && !this.transparentBackground,
            } }, isSlotUsed(this.el, "icon") && (h("div", { class: "icon" }, h("slot", { name: "icon" }))), h("ic-typography", { variant: "label", "apply-vertical-margins": false, class: { label: true, "in-ag-grid": this.inAGGrid } }, h("span", null, label)), dismissible && (h("ic-tooltip", { label: "Dismiss", target: "dismiss-icon", class: { "tooltip-disabled": disabled } }, h("button", { id: "dismiss-icon", class: "dismiss-icon", "aria-label": `Dismiss ${label} chip`, disabled: disabled, tabindex: disabled ? -1 : 0, onClick: this.dismissAction, onMouseEnter: this.mouseEnterHandler, onMouseLeave: this.mouseLeaveHandler, innerHTML: dismissIcon }))), isSlotUsed(this.el, "badge") && h("slot", { name: "badge" }))));
    }
    static get is() { return "ic-chip"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-chip.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-chip.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcChipAppearance",
                    "resolved": "\"filled\" | \"outline\"",
                    "references": {
                        "IcChipAppearance": {
                            "location": "import",
                            "path": "./ic-chip.types",
                            "id": "src/components/ic-chip/ic-chip.types.ts::IcChipAppearance"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Use variant prop instead."
                        }],
                    "text": ""
                },
                "attribute": "appearance",
                "reflect": false
            },
            "customColor": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcColor",
                    "resolved": "`#${string}` | `rgb(${string})` | `rgba(${string})`",
                    "references": {
                        "IcColor": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcColor"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The custom chip colour. This prop will be applied to the chip component if `dismissible` is set to `false`.\nCan be a hex value e.g. \"#ff0000\", RGB e.g. \"rgb(255, 0, 0)\", or RGBA e.g. \"rgba(255, 0, 0, 1)\"."
                },
                "attribute": "custom-color",
                "reflect": false,
                "defaultValue": "null"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the chip will appear disabled."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "dismissible": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the chip will have a close button at the end to dismiss it."
                },
                "attribute": "dismissible",
                "reflect": false,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The text rendered within the chip."
                },
                "attribute": "label",
                "reflect": false
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the chip."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "transparentBackground": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the outlined variant of chip will have a transparent background rather than white."
                },
                "attribute": "transparent-background",
                "reflect": false,
                "defaultValue": "true"
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcEmphasisType",
                    "resolved": "\"filled\" | \"outlined\"",
                    "references": {
                        "IcEmphasisType": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcEmphasisType"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The emphasis of the chip."
                },
                "attribute": "variant",
                "reflect": false,
                "defaultValue": "\"filled\""
            }
        };
    }
    static get states() {
        return {
            "hovered": {},
            "visible": {}
        };
    }
    static get events() {
        return [{
                "method": "dismiss",
                "name": "dismiss",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This event should not be used anymore. Use icDismiss instead."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "icDismiss",
                "name": "icDismiss",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Is emitted when the user dismisses the chip."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the chip.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "customColor",
                "methodName": "customColorHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "icDismiss",
                "method": "handleClick",
                "target": undefined,
                "capture": true,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-chip.js.map
