import { h, Host } from "@stencil/core";
const classificationText = {
    default: "protective marking not set",
    official: "official",
    "official-sensitive": "official sensitive",
    secret: "secret",
    "top-secret": "top secret",
};
export class ClassificationBanner {
    constructor() {
        this.additionalSelectors = "";
        this.classification = "default";
        this.country = "uk";
        this.inline = false;
        this.upTo = false;
    }
    render() {
        const { inline, upTo } = this;
        // In case of unrecognized props, fallback to default
        let { country, additionalSelectors, classification } = this;
        if (!country)
            country = "";
        if (!additionalSelectors)
            additionalSelectors = "";
        if (!classification ||
            (classification && !classificationText[classification]))
            classification = "default";
        return (h(Host, { class: { ["inline"]: inline } }, h("banner", { "aria-label": "Protective marking", class: {
                ["classification-banner"]: true,
                [`${classification}`]: classification,
            } }, classification !== "default" ? (h("span", { class: "offscreen" }, "The protective marking of this page is:", " ")) : null, h("ic-typography", { variant: "caption-uppercase" }, classification === "default"
            ? classificationText[classification]
            : `${upTo ? "up to" : ""} 
               ${country} 
               ${classificationText[classification]} 
               ${additionalSelectors}`))));
    }
    static get is() { return "ic-classification-banner"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-classification-banner.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-classification-banner.css"]
        };
    }
    static get properties() {
        return {
            "additionalSelectors": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The additional information that will be displayed after the classification."
                },
                "attribute": "additional-selectors",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "classification": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcProtectiveMarkings",
                    "resolved": "\"default\" | \"official\" | \"official-sensitive\" | \"secret\" | \"top-secret\"",
                    "references": {
                        "IcProtectiveMarkings": {
                            "location": "import",
                            "path": "./ic-classification-banner.types",
                            "id": "src/components/ic-classification-banner/ic-classification-banner.types.tsx::IcProtectiveMarkings"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The classification level to be displayed - also determines the banner and text colour."
                },
                "attribute": "classification",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "country": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The optional text that will be displayed before classification to specify relevant country/countries."
                },
                "attribute": "country",
                "reflect": false,
                "defaultValue": "\"uk\""
            },
            "inline": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the banner will appear inline with the page, instead of sticking to the bottom of the page."
                },
                "attribute": "inline",
                "reflect": false,
                "defaultValue": "false"
            },
            "upTo": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, \"Up to\" will be displayed before the classification and country."
                },
                "attribute": "up-to",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
}
//# sourceMappingURL=ic-classification-banner.js.map
