import { Host, h } from "@stencil/core";
/**
 * @slot heading - Content will be placed at the top of the data entity.
 */
export class DataEntity {
    constructor() {
        this.heading = undefined;
        this.size = "default";
        this.small = false;
    }
    render() {
        const { el, heading, small, size } = this;
        if (small || size === "small") {
            Array.from(el.children).forEach((child) => child.setAttribute("size", "small"));
        }
        return (h(Host, { class: { small: small || size === "small" } }, h("div", { class: "heading", id: "data-entity-heading" }, h("slot", { name: "heading" }, h("ic-typography", { variant: "h3" }, heading))), h("div", { class: "divider" }), h("ul", { "aria-labelledby": "data-entity-heading", class: "rows" }, h("slot", null))));
    }
    static get is() { return "ic-data-entity"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-data-entity.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-data-entity.css"]
        };
    }
    static get properties() {
        return {
            "heading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The title for the data entity."
                },
                "attribute": "heading",
                "reflect": false
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizesNoLarge",
                    "resolved": "\"default\" | \"small\"",
                    "references": {
                        "IcSizesNoLarge": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizesNoLarge"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the data entity component."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-data-entity.js.map
