import { Host, h } from "@stencil/core";
import { checkResizeObserver, DEVICE_SIZES, getCurrentDeviceSize, isSlotUsed, slotHasContent, } from "../../utils/helpers";
/**
 * @slot label - Content will be rendered in the leftmost cell.
 * @slot value - Content will be rendered to the right of the label.
 * @slot end-component - Content will be displayed in the rightmost cell.
 */
export class DataRow {
    constructor() {
        this.hasEndComponent = false;
        this.resizeObserver = null;
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                this.checkLabelAbove();
            });
            this.resizeObserver.observe(this.el);
        };
        this.renderCellContent = (cell) => {
            const isValue = cell === "value";
            return (h("div", { class: cell }, isSlotUsed(this.el, cell) ? (h("slot", { name: cell })) : (h("ic-typography", { variant: isValue
                    ? "body"
                    : this.entitySize === "xs"
                        ? "label"
                        : "subtitle-large" }, isValue ? this.value : this.label))));
        };
        this.deviceSize = DEVICE_SIZES.XL;
        this.entitySize = undefined;
        this.label = undefined;
        this.size = "default";
        this.small = false;
        this.value = undefined;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentWillLoad() {
        this.deviceSize = getCurrentDeviceSize();
        this.hasEndComponent = slotHasContent(this.el, "end-component");
        this.checkLabelAbove();
    }
    componentDidLoad() {
        checkResizeObserver(this.runResizeObserver);
        if (this.hasEndComponent)
            this.labelEndComponent();
    }
    checkLabelAbove() {
        var _a;
        const rowSize = ((_a = this.el.shadowRoot.querySelector(".data")) === null || _a === void 0 ? void 0 : _a.clientWidth) + 46;
        if (rowSize) {
            this.entitySize =
                rowSize < DEVICE_SIZES.S ? "xs" : rowSize < DEVICE_SIZES.M ? "m" : "xl";
        }
    }
    labelEndComponent() {
        this.el.shadowRoot
            .querySelectorAll("slot[name=end-component]")
            .forEach((child) => child.setAttribute("aria-label", `for ${this.label} row`));
    }
    render() {
        const { el, entitySize, hasEndComponent, label, renderCellContent, size, small, value, } = this;
        return (h(Host, { class: {
                ["small"]: small || size === "small",
                ["breakpoint-medium"]: entitySize === "m",
                ["breakpoint-xs"]: entitySize === "xs",
            }, role: "listitem" }, h("div", { class: "data" }, h("div", { class: "text-cells" }, (isSlotUsed(el, "label") || label) && renderCellContent("label"), (isSlotUsed(el, "value") || value) && renderCellContent("value")), hasEndComponent && (h("div", { class: "end-component" }, h("slot", { name: "end-component" })))), h("div", { class: "divider" })));
    }
    static get is() { return "ic-data-row"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-data-row.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-data-row.css"]
        };
    }
    static get properties() {
        return {
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label in the leftmost cell of the row."
                },
                "attribute": "label",
                "reflect": false
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizesNoLarge",
                    "resolved": "\"default\" | \"small\"",
                    "references": {
                        "IcSizesNoLarge": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizesNoLarge"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the data row component."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "value": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The value of the middle (right if no end-component supplied) cell of the row."
                },
                "attribute": "value",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "deviceSize": {},
            "entitySize": {}
        };
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-data-row.js.map
