import { Host, h, } from "@stencil/core";
import closeIcon from "../../assets/close-icon.svg";
import { isSlotUsed, checkResizeObserver, isPropDefined, onComponentRequiredPropUndefined, } from "../../utils/helpers";
/**
 * @slot dialog-controls - Content will be place at the bottom of the dialog.
 * @slot heading - Content will be placed at the top of the dialog.
 * @slot label - Content will be placed above the dialog heading.
 * @slot alert - Content will be placed at the top of the content area of the dialog.
 */
export class Dialog {
    constructor() {
        this.DATA_GETS_FOCUS = "data-gets-focus";
        this.DATA_GETS_FOCUS_SELECTOR = "[data-gets-focus]";
        this.DIALOG_CONTROLS = "dialog-controls";
        this.dialogHeight = 0;
        this.focusedElementIndex = 0;
        this.IC_TEXT_FIELD = "IC-TEXT-FIELD";
        this.IC_ACCORDION = "IC-ACCORDION";
        this.IC_ACCORDION_GROUP = "IC-ACCORDION-GROUP";
        this.resizeObserver = null;
        this.dialogOpened = () => {
            var _a;
            this.dialogRendered = true;
            if (this.disableHeightConstraint) {
                this.dialogEl.show();
            }
            else {
                (_a = this.dialogEl) === null || _a === void 0 ? void 0 : _a.showModal();
            }
            setTimeout(() => {
                this.fadeIn = true;
                /**
                 * This is required to set scroll back to top if:
                 * - dialog content goes below the fold
                 * - is closed using cancel or confirm and reopened.
                 *
                 * Without this, the scroll bar will start from the dialog's last scroll-x coordinate.
                 */
                if (this.disableHeightConstraint && this.backdropEl.scrollTop !== 0) {
                    this.backdropEl.scrollTop = 0;
                }
            }, 10);
            setTimeout(() => {
                this.setInitialFocus();
                checkResizeObserver(this.runResizeObserver);
            }, 75);
            setTimeout(() => {
                this.getFocusedElementIndex();
                this.icDialogOpened.emit();
            }, 80);
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                clearTimeout(this.resizeTimeout);
                this.resizeTimeout = window.setTimeout(this.resizeObserverCallback, 80);
            });
            this.resizeObserver.observe(this.dialogEl);
        };
        this.resizeObserverCallback = () => {
            if (this.dialogEl.clientHeight !== this.dialogHeight) {
                this.dialogHeight = this.dialogEl.clientHeight;
            }
        };
        this.refreshInteractiveElementsOnSlotChange = () => {
            this.contentArea = this.el.shadowRoot.querySelector("#dialog-content slot");
            this.contentArea.addEventListener("slotchange", this.getInteractiveElements);
        };
        this.removeSlotChangeListener = () => {
            if (this.contentArea) {
                this.contentArea.removeEventListener("slotchange", this.getInteractiveElements);
            }
        };
        this.setInitialFocus = () => {
            this.sourceElement = document.activeElement;
            let focusedElement;
            if (this.el.querySelector(this.DATA_GETS_FOCUS_SELECTOR) !== null) {
                focusedElement = this.el.querySelector(this.DATA_GETS_FOCUS_SELECTOR);
            }
            else {
                focusedElement = this.el.shadowRoot.querySelector(this.DATA_GETS_FOCUS_SELECTOR);
            }
            if (focusedElement.tagName === this.IC_TEXT_FIELD) {
                focusedElement.setFocus();
            }
            else if (focusedElement.tagName === this.IC_ACCORDION_GROUP) {
                focusedElement.setFocus();
            }
            else if (focusedElement.tagName === this.IC_ACCORDION) {
                focusedElement.setFocus();
            }
            else {
                focusedElement.focus({
                    preventScroll: this.disableHeightConstraint ? true : false,
                });
            }
        };
        this.getFocusedElementIndex = () => {
            for (let i = 0; i < this.interactiveElementList.length; i++) {
                if (this.interactiveElementList[i] ===
                    (this.el.shadowRoot.activeElement || document.activeElement)) {
                    this.focusedElementIndex = i;
                }
            }
        };
        this.setAlertVariant = () => {
            if (isPropDefined(this.status) && this.status !== null) {
                const alert = this.el.shadowRoot.querySelector("ic-alert");
                alert.setAttribute("variant", this.status);
            }
        };
        this.closeIconClick = () => {
            this.open = false;
        };
        this.getInteractiveElements = () => {
            this.interactiveElementList = Array.from(this.el.shadowRoot.querySelectorAll("ic-button"));
            const slottedInteractiveElements = Array.from(this.el.querySelectorAll(`a[href], button, input:not(.ic-input), textarea, select, details, [tabindex]:not([tabindex="-1"]), 
          ic-button, ic-checkbox, ic-select, ic-search-bar, ic-tab-group, ic-radio-group, 
          ic-back-to-top, ic-breadcrumb, ic-chip[dismissible="true"], ic-footer-link, ic-link, ic-navigation-button, 
          ic-navigation-item, ic-switch, ic-text-field, ic-accordion-group, ic-accordion`));
            if (slottedInteractiveElements.length > 0) {
                if (slottedInteractiveElements[0].slot !== this.DIALOG_CONTROLS) {
                    slottedInteractiveElements[0].setAttribute(this.DATA_GETS_FOCUS, "");
                }
                else if (!this.destructive) {
                    slottedInteractiveElements[slottedInteractiveElements.length - 1].setAttribute(this.DATA_GETS_FOCUS, "");
                }
            }
            for (let i = 0; i < slottedInteractiveElements.length; i++) {
                this.interactiveElementList.splice(1 + i, 0, slottedInteractiveElements[i]);
            }
        };
        this.getNextFocusEl = (focusedElementIndex) => this.interactiveElementList[focusedElementIndex];
        this.focusNextInteractiveElement = (shiftKey) => {
            this.getFocusedElementIndex();
            this.setFocusIndexBasedOnShiftKey(shiftKey);
            this.loopNextFocusIndexIfLastElement();
            let nextFocusEl = this.getNextFocusEl(this.focusedElementIndex);
            const isHidden = getComputedStyle(nextFocusEl).visibility === "hidden" ||
                (nextFocusEl.tagName === this.IC_ACCORDION_GROUP &&
                    nextFocusEl.hasAttribute("single-expansion"));
            if (nextFocusEl.tagName === this.IC_TEXT_FIELD) {
                nextFocusEl.setFocus();
            }
            else {
                if (isHidden) {
                    this.setFocusIndexBasedOnShiftKey(shiftKey);
                    this.loopNextFocusIndexIfLastElement();
                    nextFocusEl = this.getNextFocusEl(this.focusedElementIndex);
                }
                if (nextFocusEl.tagName === this.IC_ACCORDION_GROUP) {
                    nextFocusEl.setFocus();
                }
                else if (nextFocusEl.tagName === this.IC_ACCORDION) {
                    nextFocusEl.setFocus();
                }
                else {
                    nextFocusEl.focus();
                }
            }
        };
        this.setButtonOnClick = () => {
            var _a, _b, _c;
            if (this.buttons) {
                this.buttonOnclick0 = new Function((_a = this.buttonProps[0]) === null || _a === void 0 ? void 0 : _a.onclick);
                this.buttonOnclick1 = new Function((_b = this.buttonProps[1]) === null || _b === void 0 ? void 0 : _b.onclick);
                this.buttonOnclick2 = new Function((_c = this.buttonProps[2]) === null || _c === void 0 ? void 0 : _c.onclick);
            }
        };
        this.getButtonOnclick = (index) => {
            if (index === 0) {
                return this.buttonOnclick0();
            }
            else if (index === 1) {
                return this.buttonOnclick1();
            }
            else {
                return this.buttonOnclick2();
            }
        };
        this.getButtonVariant = (index) => {
            const mainVariant = this.destructive ? "destructive" : "primary";
            if (this.buttonProps.length === 1) {
                return mainVariant;
            }
            else if (this.buttonProps.length === 2) {
                if (index === 0) {
                    return "tertiary";
                }
                else {
                    return mainVariant;
                }
            }
            else {
                if (index === 2) {
                    return mainVariant;
                }
                else {
                    return "secondary";
                }
            }
        };
        this.renderDialog = () => {
            const { alertHeading, alertMessage, buttons, buttonProps, size, heading, label, status, destructive, dismissLabel, hideCloseButton, } = this;
            return (h("dialog", { class: {
                    ["dialog"]: true,
                    [`${size}`]: true,
                    ["disable-height-constraint"]: this.disableHeightConstraint,
                    ["disable-width-constraint"]: this.disableWidthConstraint,
                }, "aria-labelledby": "dialog-label dialog-heading", "aria-describedby": "dialog-alert dialog-content", ref: (el) => (this.dialogEl = el) }, h("div", { class: "heading-area" }, h("div", { class: "heading-content" }, h("div", { class: "label" }, h("slot", { name: "label" }, h("ic-typography", { variant: "label", id: "dialog-label" }, label))), h("div", { class: "heading" }, h("slot", { name: "heading" }, h("ic-typography", { variant: "h4", id: "dialog-heading" }, heading)))), !hideCloseButton && (h("ic-button", { class: "close-icon", variant: "icon", innerHTML: closeIcon, "aria-label": dismissLabel, onClick: this.closeIconClick, "data-gets-focus": destructive || !buttons ? "" : null }))), h("div", { class: "content-area" }, isSlotUsed(this.el, "alert") ? (h("slot", { name: "alert" })) : (status && (h("ic-alert", { variant: status, heading: alertHeading, message: alertMessage, "title-above": true, class: "status-alert", id: "dialog-alert" }))), h("div", { id: "dialog-content" }, h("slot", null))), (buttons || isSlotUsed(this.el, this.DIALOG_CONTROLS)) && (h("div", { class: {
                    [this.DIALOG_CONTROLS]: true,
                    ["triple-button"]: buttonProps.length === 3,
                } }, h("slot", { name: this.DIALOG_CONTROLS }, !isSlotUsed(this.el, this.DIALOG_CONTROLS) &&
                buttonProps.map((props, index) => {
                    if (index > 2) {
                        return;
                    }
                    else {
                        return (h("ic-button", { variant: this.getButtonVariant(index), onClick: () => this.getButtonOnclick(index), class: "dialog-control-button", "full-width": buttonProps.length === 3, "data-gets-focus": this.getButtonVariant(index) === "primary" ? "" : null }, props.label));
                    }
                }))))));
        };
        this.dialogRendered = false;
        this.fadeIn = false;
        this.alertHeading = undefined;
        this.alertMessage = undefined;
        this.buttons = true;
        this.closeOnBackdropClick = true;
        this.destructive = false;
        this.dismissLabel = "Dismiss";
        this.disableHeightConstraint = false;
        this.disableWidthConstraint = false;
        this.hideCloseButton = false;
        this.heading = undefined;
        this.label = undefined;
        this.open = undefined;
        this.size = "small";
        this.status = undefined;
        this.buttonProps = [
            {
                label: "Cancel",
                onclick: "this.cancelDialog();",
            },
            { label: "Confirm", onclick: "this.confirmDialog();" },
        ];
    }
    watchOpenHandler() {
        if (this.open) {
            this.dialogOpened();
        }
        else {
            this.fadeIn = false;
            if (this.resizeObserver !== null) {
                this.resizeObserver.disconnect();
            }
            setTimeout(() => {
                var _a;
                this.dialogRendered = false;
                this.dialogEl.close();
                (_a = this.sourceElement) === null || _a === void 0 ? void 0 : _a.focus();
                this.dialogHeight = 0;
                this.icDialogClosed.emit();
            }, 80);
        }
    }
    watchPropHandler() {
        this.setButtonOnClick();
    }
    disconnectedCallback() {
        this.removeSlotChangeListener();
    }
    componentWillLoad() {
        if (this.buttonProps.length) {
            this.setButtonOnClick();
        }
    }
    componentDidLoad() {
        this.getInteractiveElements();
        this.setAlertVariant();
        this.refreshInteractiveElementsOnSlotChange();
        if (this.open) {
            this.dialogOpened();
        }
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Dialog");
    }
    componentDidRender() {
        if (getComputedStyle(this.el).display !== "none" &&
            this.disableHeightConstraint) {
            document.body.style.overflow = "hidden";
        }
        else {
            document.body.style.overflow = "auto";
        }
    }
    handleKeyboard(ev) {
        if (this.dialogRendered) {
            switch (ev.key) {
                case "Tab":
                    ev.preventDefault();
                    this.focusNextInteractiveElement(ev.shiftKey);
                    break;
                case "Escape":
                    if (!ev.repeat) {
                        this.open = false;
                    }
                    ev.stopImmediatePropagation();
                    break;
            }
        }
    }
    handleClick(ev) {
        const dialogElement = this.el.shadowRoot.querySelector("dialog");
        if (this.closeOnBackdropClick &&
            ev.composedPath().indexOf(dialogElement) <= 0) {
            const rect = this.dialogEl.getBoundingClientRect();
            const isInDialog = rect.top <= ev.clientY &&
                ev.clientY <= rect.top + rect.height &&
                rect.left <= ev.clientX &&
                ev.clientX <= rect.left + rect.width;
            if (!isInDialog) {
                this.open = false;
            }
        }
    }
    /**
     * @deprecated This method should not be used anymore. Use open prop to set dialog visibility.
     */
    async showDialog() {
        this.open = true;
    }
    /**
     * @deprecated This method should not be used anymore. Use open prop to set dialog visibility.
     */
    async hideDialog() {
        this.open = false;
    }
    /**
     * Cancels the dialog. Used by the default 'Cancel' button or can be called manually to trigger cancelling of dialog.
     */
    async cancelDialog() {
        this.icDialogCancelled.emit();
        this.open = false;
    }
    /**
     * Confirms the dialog. Used by the default 'Confirm' button or can be called manually to trigger confirming of dialog.
     */
    async confirmDialog() {
        this.icDialogConfirmed.emit();
    }
    loopNextFocusIndexIfLastElement() {
        if (this.focusedElementIndex > this.interactiveElementList.length - 1)
            this.focusedElementIndex = 0;
        else if (this.focusedElementIndex < 0) {
            this.focusedElementIndex = this.interactiveElementList.length - 1;
        }
    }
    setFocusIndexBasedOnShiftKey(shiftKey) {
        if (shiftKey) {
            this.focusedElementIndex -= 1;
        }
        else {
            this.focusedElementIndex += 1;
        }
    }
    render() {
        return (h(Host, { class: {
                ["hidden"]: !this.dialogRendered,
                ["fade-in"]: this.fadeIn,
                ["disable-height-constraint"]: this.disableHeightConstraint,
            } }, this.disableHeightConstraint ? (h("div", { class: "backdrop", ref: (el) => (this.backdropEl = el) }, this.renderDialog())) : (this.renderDialog())));
    }
    static get is() { return "ic-dialog"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-dialog.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-dialog.css"]
        };
    }
    static get properties() {
        return {
            "alertHeading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Use an ic-alert/IcAlert component within an alert slot with a heading instead."
                        }],
                    "text": ""
                },
                "attribute": "alert-heading",
                "reflect": false
            },
            "alertMessage": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Use an ic-alert/IcAlert component within an alert slot with a message instead."
                        }],
                    "text": ""
                },
                "attribute": "alert-message",
                "reflect": false
            },
            "buttons": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If set to `false`, dialog controls will not be displayed overriding buttonProps or slotted dialog controls."
                },
                "attribute": "buttons",
                "reflect": false,
                "defaultValue": "true"
            },
            "closeOnBackdropClick": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If set to `false`, the dialog will not close when the backdrop is clicked."
                },
                "attribute": "close-on-backdrop-click",
                "reflect": false,
                "defaultValue": "true"
            },
            "destructive": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If default buttons are displayed, sets the 'primary' or rightmost button to the destructive variant. Stops initial focus being set on the 'primary' or rightmost default or slotted button."
                },
                "attribute": "destructive",
                "reflect": false,
                "defaultValue": "false"
            },
            "dismissLabel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Sets the dismiss label tooltip and aria label."
                },
                "attribute": "dismiss-label",
                "reflect": false,
                "defaultValue": "\"Dismiss\""
            },
            "disableHeightConstraint": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If set to `true`, the content area max height and overflow properties are removed allowing the dialog to stretch below the fold.\nThis prop also prevents popover elements from being cut off within the content area."
                },
                "attribute": "disable-height-constraint",
                "reflect": false,
                "defaultValue": "false"
            },
            "disableWidthConstraint": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If set to `true`, the content area width property is removed, allowing content to take the full width of the dialog when using the large variant."
                },
                "attribute": "disable-width-constraint",
                "reflect": false,
                "defaultValue": "false"
            },
            "hideCloseButton": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the close button will not be displayed."
                },
                "attribute": "hide-close-button",
                "reflect": false,
                "defaultValue": "false"
            },
            "heading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Sets the heading for the dialog."
                },
                "attribute": "heading",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Sets the optional label for the dialog which appears above the heading."
                },
                "attribute": "label",
                "reflect": false
            },
            "open": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the dialog will be displayed."
                },
                "attribute": "open",
                "reflect": true,
                "defaultValue": "undefined"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "\"small\" | \"medium\" | \"large\"",
                    "resolved": "\"large\" | \"medium\" | \"small\"",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Sets the maximum and minimum height and width for the dialog."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"small\""
            },
            "status": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "\"neutral\" | \"info\" | \"warning\" | \"error\" | \"success\"",
                    "resolved": "\"error\" | \"info\" | \"neutral\" | \"success\" | \"warning\"",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Use an ic-alert/IcAlert component within an alert slot with a variant instead."
                        }],
                    "text": ""
                },
                "attribute": "status",
                "reflect": false
            },
            "buttonProps": {
                "type": "unknown",
                "mutable": false,
                "complexType": {
                    "original": "{ label: string; onclick: string }[]",
                    "resolved": "{ label: string; onclick: string; }[]",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Sets the label and onclick functions for default buttons."
                },
                "defaultValue": "[\n    {\n      label: \"Cancel\",\n      onclick: \"this.cancelDialog();\",\n    },\n    { label: \"Confirm\", onclick: \"this.confirmDialog();\" },\n  ]"
            }
        };
    }
    static get states() {
        return {
            "dialogRendered": {},
            "fadeIn": {}
        };
    }
    static get events() {
        return [{
                "method": "icDialogCancelled",
                "name": "icDialogCancelled",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Cancelation event emitted when default 'Cancel' button clicked or 'cancelDialog' method is called."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "icDialogClosed",
                "name": "icDialogClosed",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when dialog has closed."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "icDialogConfirmed",
                "name": "icDialogConfirmed",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Confirmation event emitted when default 'Confirm' primary button clicked or 'confirmDialog' method is called."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "icDialogOpened",
                "name": "icDialogOpened",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when dialog has opened."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "showDialog": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "deprecated",
                            "text": "This method should not be used anymore. Use open prop to set dialog visibility."
                        }]
                }
            },
            "hideDialog": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "deprecated",
                            "text": "This method should not be used anymore. Use open prop to set dialog visibility."
                        }]
                }
            },
            "cancelDialog": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Cancels the dialog. Used by the default 'Cancel' button or can be called manually to trigger cancelling of dialog.",
                    "tags": []
                }
            },
            "confirmDialog": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Confirms the dialog. Used by the default 'Confirm' button or can be called manually to trigger confirming of dialog.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "open",
                "methodName": "watchOpenHandler"
            }, {
                "propName": "buttonProps",
                "methodName": "watchPropHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "keydown",
                "method": "handleKeyboard",
                "target": "document",
                "capture": false,
                "passive": false
            }, {
                "name": "click",
                "method": "handleClick",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-dialog.js.map
