import { h, Host } from "@stencil/core";
import { getThemeForegroundColor } from "../../utils/helpers";
import { IcThemeForegroundEnum, } from "../../utils/types";
export class Divider {
    constructor() {
        this.foregroundColor = getThemeForegroundColor();
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    render() {
        return (h(Host, { "aria-hidden": "true" }, h("hr", { class: {
                ["light"]: this.foregroundColor === IcThemeForegroundEnum.Light,
            } })));
    }
    static get is() { return "ic-divider"; }
    static get encapsulation() { return "scoped"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-divider.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-divider.css"]
        };
    }
    static get states() {
        return {
            "foregroundColor": {}
        };
    }
    static get listeners() {
        return [{
                "name": "themeChange",
                "method": "themeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-divider.js.map
