import { h, Host, forceUpdate } from "@stencil/core";
import { isSlotUsed, onComponentRequiredPropUndefined, checkSlotInChildMutations, } from "../../utils/helpers";
/**
 * @slot image - Content is placed at the top above all other content.
 * @slot actions - Content is placed at the bottom below all other content.
 * @slot heading - Content will be rendered in place of the heading prop.
 * @slot subheading - Content will be rendered in place of the subheading prop.
 * @slot body - Content will be rendered in place of the body prop.
 */
export class EmptyState {
    constructor() {
        this.hostMutationObserver = null;
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, [
                    "image",
                    "actions",
                ])
                : false)) {
                forceUpdate(this);
            }
        };
        this.aligned = "left";
        this.body = undefined;
        this.bodyMaxLines = undefined;
        this.heading = undefined;
        this.imageSize = "default";
        this.subheading = undefined;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentDidLoad() {
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Empty State");
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    render() {
        const { aligned, body, bodyMaxLines, heading, imageSize, subheading } = this;
        return (h(Host, { class: {
                [`${aligned}`]: true,
                [`image-${imageSize}`]: isSlotUsed(this.el, "image"),
            } }, isSlotUsed(this.el, "image") && h("slot", { name: "image" }), h("div", null, h("slot", { name: "heading" }, h("ic-typography", { variant: "h4" }, heading)), h("slot", { name: "subheading" }, h("ic-typography", { variant: "subtitle-small" }, subheading)), h("slot", { name: "body" }, h("ic-typography", { maxLines: bodyMaxLines }, body))), isSlotUsed(this.el, "actions") && (h("div", { class: "action-area" }, h("slot", { name: "actions" })))));
    }
    static get is() { return "ic-empty-state"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-empty-state.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-empty-state.css"]
        };
    }
    static get properties() {
        return {
            "aligned": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcEmptyStateAlignment",
                    "resolved": "\"center\" | \"left\" | \"right\"",
                    "references": {
                        "IcEmptyStateAlignment": {
                            "location": "import",
                            "path": "./ic-empty-state.types",
                            "id": "src/components/ic-empty-state/ic-empty-state.types.ts::IcEmptyStateAlignment"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The alignment of the empty state container."
                },
                "attribute": "aligned",
                "reflect": false,
                "defaultValue": "\"left\""
            },
            "body": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The body text rendered in the empty state container."
                },
                "attribute": "body",
                "reflect": false
            },
            "bodyMaxLines": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The number of lines of body text to display before truncating."
                },
                "attribute": "body-max-lines",
                "reflect": false
            },
            "heading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The title rendered in the empty state container."
                },
                "attribute": "heading",
                "reflect": false
            },
            "imageSize": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the image or icon used in the image slot."
                },
                "attribute": "image-size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "subheading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The subtitle rendered in the empty state container."
                },
                "attribute": "subheading",
                "reflect": false
            }
        };
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-empty-state.js.map
