import { Host, h, } from "@stencil/core";
import { DEVICE_SIZES, getThemeForegroundColor, onComponentRequiredPropUndefined, } from "../../utils/helpers";
export class FooterLinkGroup {
    constructor() {
        this.handleKeydown = (event) => {
            if (event.key === " " || event.key === "Enter") {
                this.toggleExpanded();
            }
        };
        this.toggleExpanded = () => {
            this.expanded = !this.expanded;
        };
        this.expanded = false;
        this.deviceSize = DEVICE_SIZES.XL;
        this.dropdownIconStyle = getThemeForegroundColor();
        this.small = false;
        this.groupTitle = undefined;
    }
    componentWillLoad() {
        this.small = this.isSmall(this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.groupTitle, propName: "group-title" }], "Footer Link Group");
    }
    footerResizeHandler() {
        this.small = this.isSmall(this.el);
    }
    footerThemeChangeHandler(ev) {
        const theme = ev.detail;
        this.dropdownIconStyle = theme.mode;
    }
    isSmall(e) {
        if (e.parentElement !== null) {
            if (e.parentElement.classList.contains("footer")) {
                return e.parentElement.classList.contains("footer-small");
            }
            else {
                return this.isSmall(e.parentElement);
            }
        }
        else {
            return false;
        }
    }
    render() {
        const { small, groupTitle } = this;
        return !small ? (h(Host, { class: {
                ["footer-link-group footer-link-group-sparse"]: true,
                [`footer-link-group-${this.dropdownIconStyle}`]: true,
            }, role: "listitem" }, h("div", { class: "footer-link-group-title" }, h("ic-typography", { variant: "subtitle-small" }, groupTitle)), h("div", { class: "footer-link-group-links", role: "list" }, h("slot", null)))) : (h(Host, { class: {
                ["footer-link-group footer-link-group-small"]: true,
                [`footer-link-group-${this.dropdownIconStyle}`]: true,
            }, tabIndex: "1", onClick: this.toggleExpanded, onKeydown: this.handleKeydown, "aria-expanded": this.expanded }, h("ic-section-container", { fullHeight: true }, h("div", { class: "footer-link-group-header" }, h("div", { class: "footer-link-group-title" }, h("ic-typography", { variant: "label" }, groupTitle)), this.expanded ? (h("svg", { class: "footer-link-group-toggle", xmlns: "http://www.w3.org/2000/svg", "aria-hidden": "true", role: "img", width: "1em", height: "1em", preserveAspectRatio: "xMidYMid meet", viewBox: "0 0 1200 1200" }, h("path", { fill: "currentColor", d: "M600.002 210.605L421.285 389.336L0 810.559l178.721 178.836l421.281-421.341l421.281 421.341L1200 810.559L778.733 389.336L600.002 210.605z" }))) : (h("svg", { class: "footer-link-group-toggle", xmlns: "http://www.w3.org/2000/svg", "aria-hidden": "true", role: "img", width: "1em", height: "1em", preserveAspectRatio: "xMidYMid meet", viewBox: "0 0 1200 1200" }, h("g", { transform: "translate(0 1200) scale(1 -1)" }, h("path", { fill: "currentColor", d: "M600.002 210.605L421.285 389.336L0 810.559l178.721 178.836l421.281-421.341l421.281 421.341L1200 810.559L778.733 389.336L600.002 210.605z" }))))), this.expanded && (h("div", { class: "footer-link-group-links", role: "list" }, h("slot", null))))));
    }
    static get is() { return "ic-footer-link-group"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-footer-link-group.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-footer-link-group.css"]
        };
    }
    static get properties() {
        return {
            "groupTitle": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The title of the link group to be displayed."
                },
                "attribute": "group-title",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "expanded": {},
            "deviceSize": {},
            "dropdownIconStyle": {},
            "small": {}
        };
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "footerResized",
                "method": "footerResizeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }, {
                "name": "themeChange",
                "method": "footerThemeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-footer-link-group.js.map
