import { Host, h, } from "@stencil/core";
import { DEVICE_SIZES, getThemeForegroundColor } from "../../utils/helpers";
import OpenInNew from "../../assets/OpenInNew.svg";
export class FooterLink {
    constructor() {
        this.deviceSize = DEVICE_SIZES.XL;
        this.footerConfig = { small: false, grouped: false };
        this.foregroundColor = getThemeForegroundColor();
        this.download = false;
        this.href = null;
        this.hreflang = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.target = undefined;
    }
    componentWillLoad() {
        this.footerConfig = this.inferConfig(this.el);
    }
    footerResizeHandler() {
        this.footerConfig = this.inferConfig(this.el);
    }
    footerThemeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    inferConfig(e) {
        if (e.parentElement !== null) {
            if (e.parentElement.classList.contains("footer")) {
                return {
                    small: e.parentElement.classList.contains("footer-small"),
                    grouped: e.parentElement.classList.contains("footer-grouped"),
                };
            }
            else {
                return this.inferConfig(e.parentElement);
            }
        }
        else {
            return { small: false, grouped: false };
        }
    }
    render() {
        const { footerConfig, href, hreflang, referrerpolicy, rel, target, download, } = this;
        const { small, grouped } = footerConfig;
        return (h(Host, { class: {
                "footer-link": true,
                [`footer-link-${grouped ? "grouped" : "ungrouped"}-${small ? "small" : "sparse"}`]: true,
                [`footer-link-${this.foregroundColor}`]: true,
            }, role: "listitem" }, h("a", { href: href, hreflang: hreflang, referrerPolicy: referrerpolicy, rel: rel, download: download !== false ? download : null, target: target }, h("slot", null), target === "_blank" && (h("span", { class: "open-in-new-icon", innerHTML: OpenInNew })))));
    }
    static get is() { return "ic-footer-link"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-footer-link.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-footer-link.css"]
        };
    }
    static get properties() {
        return {
            "download": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | boolean",
                    "resolved": "boolean | string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the user can save the linked URL instead of navigating to it."
                },
                "attribute": "download",
                "reflect": false,
                "defaultValue": "false"
            },
            "href": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The URL that the link points to."
                },
                "attribute": "href",
                "reflect": false,
                "defaultValue": "null"
            },
            "hreflang": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The human language of the linked URL."
                },
                "attribute": "hreflang",
                "reflect": false
            },
            "referrerpolicy": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "ReferrerPolicy",
                    "resolved": "\"\" | \"no-referrer\" | \"no-referrer-when-downgrade\" | \"origin\" | \"origin-when-cross-origin\" | \"same-origin\" | \"strict-origin\" | \"strict-origin-when-cross-origin\" | \"unsafe-url\"",
                    "references": {
                        "ReferrerPolicy": {
                            "location": "global",
                            "id": "global::ReferrerPolicy"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "How much of the referrer to send when following the link."
                },
                "attribute": "referrerpolicy",
                "reflect": false
            },
            "rel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The relationship of the linked URL as space-separated link types."
                },
                "attribute": "rel",
                "reflect": false
            },
            "target": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe)."
                },
                "attribute": "target",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "deviceSize": {},
            "footerConfig": {},
            "foregroundColor": {}
        };
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "footerResized",
                "method": "footerResizeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }, {
                "name": "themeChange",
                "method": "footerThemeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-footer-link.js.map
