import { h, Host, } from "@stencil/core";
import { IC_DEVICE_SIZES } from "../../utils/constants";
import { getCurrentDeviceSize, getThemeForegroundColor, checkResizeObserver, hasClassificationBanner, isSlotUsed, } from "../../utils/helpers";
import { IcThemeForegroundEnum, } from "../../utils/types";
/**
 * @slot description - Content will be rendered at the top of the footer.
 * @slot link - Content will be rendered between description and logos.
 * @slot logo - Content will be rendered underneath footer links.
 * @slot caption - Content will be rendered above Crown Copyright.
 */
export class Footer {
    constructor() {
        this.resizeObserver = null;
        this.resizeObserverCallback = (currSize) => {
            if (currSize !== this.deviceSize) {
                this.deviceSize = currSize;
            }
            this.footerResized.emit();
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                const currSize = getCurrentDeviceSize();
                this.resizeObserverCallback(currSize);
            });
            this.resizeObserver.observe(this.footerEl);
        };
        this.deviceSize = IC_DEVICE_SIZES.XL;
        this.foregroundColor = getThemeForegroundColor();
        this.aligned = "left";
        this.breakpoint = "medium";
        this.caption = undefined;
        this.copyright = true;
        this.description = undefined;
        this.groupLinks = false;
    }
    disconnectedCallback() {
        if (this.resizeObserver !== null) {
            this.resizeObserver.disconnect();
        }
    }
    componentWillLoad() {
        this.deviceSize = getCurrentDeviceSize();
    }
    componentDidLoad() {
        checkResizeObserver(this.runResizeObserver);
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    isSmall() {
        const bp = this.breakpoint;
        return bp === "extra small"
            ? this.deviceSize < IC_DEVICE_SIZES.XS
            : bp === "small"
                ? this.deviceSize < IC_DEVICE_SIZES.S
                : bp === "medium"
                    ? this.deviceSize < IC_DEVICE_SIZES.M
                    : bp === "large"
                        ? this.deviceSize < IC_DEVICE_SIZES.L
                        : bp === "extra large"
                            ? this.deviceSize < IC_DEVICE_SIZES.XL
                            : false;
    }
    render() {
        const { aligned, caption, copyright, description, groupLinks, foregroundColor, } = this;
        const small = this.isSmall();
        return (h(Host, { class: {
                footer: true,
                [`footer-${small ? "small" : "sparse"}`]: true,
                [`footer-${groupLinks ? "grouped" : "ungrouped"}`]: true,
                [`footer-${foregroundColor}`]: true,
                // Slots will be able to infer their own color
                [IcThemeForegroundEnum.Dark]: foregroundColor === IcThemeForegroundEnum.Dark,
                [IcThemeForegroundEnum.Light]: foregroundColor === IcThemeForegroundEnum.Light,
            } }, h("footer", { ref: (footerEl) => (this.footerEl = footerEl) }, (isSlotUsed(this.el, "description") || description) && (h("div", { class: "footer-description" }, h("ic-section-container", { aligned: aligned, fullHeight: true }, h("div", { class: "footer-description-inner" }, h("ic-typography", { variant: "body" }, h("slot", { name: "description" }, description)))))), isSlotUsed(this.el, "link") && (h("div", { class: "footer-links" }, groupLinks && small ? (h("div", { class: "footer-links-inner", role: "list" }, h("slot", { name: "link" }))) : (h("ic-section-container", { fullHeight: true, aligned: aligned }, h("div", { class: "footer-links-inner", role: "list" }, h("slot", { name: "link" })))))), h("div", { class: "footer-compliance" }, h("ic-section-container", { aligned: aligned, fullHeight: true }, h("div", { class: "footer-compliance-inner" }, isSlotUsed(this.el, "logo") && (h("div", { class: "footer-logo" }, h("slot", { name: "logo" }))), (isSlotUsed(this.el, "caption") || caption) && (h("div", { class: "footer-caption" }, h("ic-typography", { variant: this.deviceSize <= IC_DEVICE_SIZES.M
                ? "caption"
                : "body" }, h("slot", { name: "caption" }, caption)))), copyright && (h("div", { class: {
                ["footer-copyright"]: true,
                ["classification-spacing"]: hasClassificationBanner(),
            } }, h("ic-typography", { variant: this.deviceSize <= IC_DEVICE_SIZES.M
                ? "caption-uppercase"
                : "label-uppercase" }, "\u00A9 Crown Copyright")))))))));
    }
    static get is() { return "ic-footer"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-footer.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-footer.css"]
        };
    }
    static get properties() {
        return {
            "aligned": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcAlignment",
                    "resolved": "\"center\" | \"full-width\" | \"left\"",
                    "references": {
                        "IcAlignment": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcAlignment"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The alignment of the section containers used within the footer."
                },
                "attribute": "aligned",
                "reflect": false,
                "defaultValue": "\"left\""
            },
            "breakpoint": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcFooterBreakpoints",
                    "resolved": "\"extra large\" | \"extra small\" | \"large\" | \"medium\" | \"small\"",
                    "references": {
                        "IcFooterBreakpoints": {
                            "location": "import",
                            "path": "./ic-footer.types",
                            "id": "src/components/ic-footer/ic-footer.types.tsx::IcFooterBreakpoints"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The screen size breakpoint at which to switch to the small layout."
                },
                "attribute": "breakpoint",
                "reflect": false,
                "defaultValue": "\"medium\""
            },
            "caption": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The caption displayed at the bottom of the footer."
                },
                "attribute": "caption",
                "reflect": false
            },
            "copyright": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the footer will display the crown copyright at the bottom."
                },
                "attribute": "copyright",
                "reflect": false,
                "defaultValue": "true"
            },
            "description": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The description displayed at the top of the footer."
                },
                "attribute": "description",
                "reflect": false
            },
            "groupLinks": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the footer will be set up to handle link groups instead of standalone links."
                },
                "attribute": "group-links",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "deviceSize": {},
            "foregroundColor": {}
        };
    }
    static get events() {
        return [{
                "method": "footerResized",
                "name": "footerResized",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Triggers on page resize and triggers style changes in footer links and link groups"
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "themeChange",
                "method": "themeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-footer.js.map
