import { Host, h, forceUpdate, } from "@stencil/core";
import { IcThemeForegroundEnum, } from "../../utils/types";
import { slotHasContent, getThemeForegroundColor, onComponentRequiredPropUndefined, isPropDefined, isSlotUsed, checkSlotInChildMutations, } from "../../utils/helpers";
/**
 * @slot heading - Content will be rendered in the title area, in place of the heading.
 * @slot subheading - Content will be rendered in the title area, in place of the subheading.
 * @slot interaction - Content will be rendered in the interaction area, adjacent to the title area.
 * @slot secondary - Content will be rendered in the secondary content area.
 */
export class Hero {
    constructor() {
        this.hostMutationObserver = null;
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, "secondary")
                : false)) {
                forceUpdate(this);
            }
        };
        this.foregroundColor = getThemeForegroundColor();
        this.rightContent = false;
        this.leftContentFullWidth = !this.rightContent && this.secondaryHeading === undefined;
        this.scrollFactor = "right -100px";
        this.aligned = "left";
        this.backgroundImage = undefined;
        this.contentAligned = "left";
        this.disableBackgroundParallax = false;
        this.heading = undefined;
        this.secondaryHeading = undefined;
        this.secondarySubheading = undefined;
        this.size = "default";
        this.small = false;
        this.subheading = undefined;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentWillLoad() {
        this.rightContent = slotHasContent(this.el, "secondary");
    }
    componentDidLoad() {
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Hero");
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    componentWillRender() {
        this.rightContent = slotHasContent(this.el, "secondary");
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    doScroll() {
        if (this.disableBackgroundParallax) {
            return;
        }
        const scrolltotop = document.scrollingElement.scrollTop;
        const factor = 0.4;
        const y = -100 + scrolltotop * factor;
        this.scrollFactor = "right " + y + "px";
    }
    render() {
        const { aligned, small, size, heading, subheading, secondaryHeading, secondarySubheading, foregroundColor, backgroundImage, scrollFactor, } = this;
        let style = {};
        if (isPropDefined(backgroundImage)) {
            style = {
                "background-image": "url(" + backgroundImage + ")",
                "background-position": scrollFactor,
            };
        }
        return (h(Host, { class: {
                [IcThemeForegroundEnum.Dark]: foregroundColor === IcThemeForegroundEnum.Dark,
                ["has-background-image"]: backgroundImage !== undefined,
                ["small"]: small || size === "small",
                ["secondary-heading"]: !!secondaryHeading,
            }, style: style }, h("ic-section-container", { aligned: aligned, fullHeight: true, class: "section-container" }, h("div", { class: {
                ["left-container"]: true,
                ["left-container-full-width"]: this.leftContentFullWidth,
            } }, h("div", { class: "heading" }, h("slot", { name: "heading" }, h("ic-typography", { variant: small || size === "small" ? "h2" : "h1", class: {
                ["heading-bottom-spacing"]: !small && size !== "small",
            } }, heading))), h("div", { class: "subheading" }, h("slot", { name: "subheading" }, h("ic-typography", { variant: "body" }, subheading))), h("div", { class: "interaction-container" }, h("slot", { name: "interaction" }))), (isPropDefined(secondaryHeading) || this.rightContent) && (h("div", { class: "right-container" }, h("slot", { name: "secondary" }, secondaryHeading && (h("div", { class: "secondary-container" }, h("div", { class: "secondary-heading" }, h("ic-typography", { variant: "h4" }, secondaryHeading)), h("div", { class: "secondary-subheading" }, h("ic-typography", { variant: "subtitle-small" }, secondarySubheading))))))))));
    }
    static get is() { return "ic-hero"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-hero.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-hero.css"]
        };
    }
    static get properties() {
        return {
            "aligned": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcAlignment",
                    "resolved": "\"center\" | \"full-width\" | \"left\"",
                    "references": {
                        "IcAlignment": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcAlignment"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The alignment of the hero."
                },
                "attribute": "aligned",
                "reflect": false,
                "defaultValue": "\"left\""
            },
            "backgroundImage": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The optional background image."
                },
                "attribute": "background-image",
                "reflect": false
            },
            "contentAligned": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcHeroContentAlignments",
                    "resolved": "\"center\" | \"left\"",
                    "references": {
                        "IcHeroContentAlignments": {
                            "location": "import",
                            "path": "./ic-hero.types",
                            "id": "src/components/ic-hero/ic-hero.types.tsx::IcHeroContentAlignments"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The alignment of the hero content."
                },
                "attribute": "content-aligned",
                "reflect": false,
                "defaultValue": "\"left\""
            },
            "disableBackgroundParallax": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the background image (if set) will not scroll using a parallax effect."
                },
                "attribute": "disable-background-parallax",
                "reflect": false,
                "defaultValue": "false"
            },
            "heading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The heading of the hero."
                },
                "attribute": "heading",
                "reflect": false
            },
            "secondaryHeading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The optional secondary heading, replaced by slotted right content."
                },
                "attribute": "secondary-heading",
                "reflect": false
            },
            "secondarySubheading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The optional secondary subheading, replaced by slotted right content."
                },
                "attribute": "secondary-subheading",
                "reflect": false
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizesNoLarge",
                    "resolved": "\"default\" | \"small\"",
                    "references": {
                        "IcSizesNoLarge": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizesNoLarge"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the hero component."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "subheading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The description for the hero."
                },
                "attribute": "subheading",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "foregroundColor": {},
            "rightContent": {},
            "leftContentFullWidth": {},
            "scrollFactor": {}
        };
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "themeChange",
                "method": "themeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }, {
                "name": "scroll",
                "method": "doScroll",
                "target": "document",
                "capture": false,
                "passive": true
            }];
    }
}
//# sourceMappingURL=ic-hero.js.map
