import { Host, forceUpdate, h } from "@stencil/core";
import { IcInformationStatus, } from "../../utils/types";
import successIcon from "../../assets/success-icon.svg";
import { checkSlotInChildMutations, slotHasContent } from "../../utils/helpers";
/**
 * @slot left-icon - Content will be placed to the left of the input.
 */
export class InputComponentContainer {
    constructor() {
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, "left-icon")
                : false)) {
                forceUpdate(this);
            }
        };
        this.appearance = "default";
        this.dark = false;
        this.disabled = false;
        this.fullWidth = false;
        this.multiLine = false;
        this.readonly = false;
        this.size = "default";
        this.small = false;
        this.validationInline = false;
        this.validationStatus = "";
    }
    componentDidLoad() {
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, { childList: true });
    }
    render() {
        const { size, small, validationStatus, disabled, readonly, multiLine, fullWidth, dark, appearance, validationInline, } = this;
        const hasValidationStatus = this.validationStatus !== "" && !this.disabled && !this.readonly
            ? true
            : false;
        return (h(Host, { class: {
                small: small,
                [`${size}`]: true,
                [validationStatus]: hasValidationStatus,
                disabled: disabled,
                readonly: readonly,
                ["multiline"]: multiLine,
                ["fullwidth"]: fullWidth,
                ["dark"]: dark || appearance === "dark",
            }, "aria-disabled": disabled && `${disabled}` }, h("div", { class: {
                "focus-indicator": true,
                dark: dark || appearance === "dark",
            } }, slotHasContent(this.el, "left-icon") && (h("div", { class: {
                ["icon-container"]: true,
            } }, h("slot", { name: "left-icon" }))), h("slot", null), validationInline &&
            validationStatus === IcInformationStatus.Success && (h("span", { class: {
                ["inline-success"]: true,
            }, innerHTML: successIcon })))));
    }
    static get is() { return "ic-input-component-container"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-input-component-container.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-input-component-container.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "\"dark\" | \"default\"",
                    "resolved": "\"dark\" | \"default\"",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the input component container."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "dark": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `appearance` to \"dark\" instead."
                        }],
                    "text": ""
                },
                "attribute": "dark",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the disabled state will be set."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "fullWidth": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the input component container will fill the width of the container it is in."
                },
                "attribute": "full-width",
                "reflect": false,
                "defaultValue": "false"
            },
            "multiLine": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the input component container will allow for multiple lines."
                },
                "attribute": "multi-line",
                "reflect": false,
                "defaultValue": "false"
            },
            "readonly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the readonly state will be set."
                },
                "attribute": "readonly",
                "reflect": false,
                "defaultValue": "false"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the input component container component."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "validationInline": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the validation will display inline."
                },
                "attribute": "validation-inline",
                "reflect": false,
                "defaultValue": "false"
            },
            "validationStatus": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcInformationStatusOrEmpty",
                    "resolved": "\"\" | \"error\" | \"success\" | \"warning\"",
                    "references": {
                        "IcInformationStatusOrEmpty": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcInformationStatusOrEmpty"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The validation status of the input component container - e.g. 'error' | 'warning' | 'success'."
                },
                "attribute": "validation-status",
                "reflect": false,
                "defaultValue": "\"\""
            }
        };
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-input-component-container.js.map
