import { Host, h } from "@stencil/core";
export class InputContainer {
    constructor() {
        this.disabled = false;
        this.readonly = false;
    }
    render() {
        return (h(Host, null, h("div", { class: {
                ["component-container"]: true,
                ["disabled"]: this.disabled,
                ["readonly"]: this.readonly,
            } }, h("slot", null))));
    }
    static get is() { return "ic-input-container"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-input-container.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-input-container.css"]
        };
    }
    static get properties() {
        return {
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the disabled state will be set."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "readonly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the readonly state will be set."
                },
                "attribute": "readonly",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
}
//# sourceMappingURL=ic-input-container.js.map
