import { Host, h } from "@stencil/core";
import { getInputHelperTextID, onComponentRequiredPropUndefined, } from "../../utils/helpers";
export class InputLabel {
    constructor() {
        this.appearance = "default";
        this.dark = false;
        this.disabled = false;
        this.error = false;
        this.for = undefined;
        this.helperText = "";
        this.label = undefined;
        this.readonly = false;
        this.required = false;
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Input Label");
    }
    render() {
        const { disabled, readonly, label, required, helperText, error, dark, appearance, } = this;
        const labelText = required ? label + " *" : label;
        const labelContent = readonly ? (`${labelText}`) : (h("label", { htmlFor: this.for }, labelText));
        const id = getInputHelperTextID(this.for);
        return (h(Host, { class: {
                ["disabled"]: disabled,
                ["readonly"]: readonly,
                ["with-helper"]: helperText !== "",
            } }, h("ic-typography", { variant: "label", class: {
                ["readonly-label"]: readonly,
                ["error-label"]: error && !(readonly || disabled),
                ["dark"]: dark || appearance === "dark",
            } }, labelContent), helperText !== "" && (h("ic-typography", { variant: "caption", class: {
                ["helpertext"]: true,
                ["helpertext-normal"]: !disabled && !readonly,
                ["helpertext-readonly"]: readonly,
            } }, h("span", { id: id }, helperText)))));
    }
    static get is() { return "ic-input-label"; }
    static get originalStyleUrls() {
        return {
            "$": ["./ic-input-label.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-input-label.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "\"dark\" | \"default\"",
                    "resolved": "\"dark\" | \"default\"",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the input label."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "dark": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `appearance` to \"dark\" instead."
                        }],
                    "text": ""
                },
                "attribute": "dark",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the disabled state will be set."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "error": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the input label will display with error styling."
                },
                "attribute": "error",
                "reflect": false,
                "defaultValue": "false"
            },
            "for": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The ID of the form element the label is bound to."
                },
                "attribute": "for",
                "reflect": false
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The helper text that will be displayed."
                },
                "attribute": "helper-text",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The text content of the label."
                },
                "attribute": "label",
                "reflect": false
            },
            "readonly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the readonly state will be set."
                },
                "attribute": "readonly",
                "reflect": false,
                "defaultValue": "false"
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the input label will require a value."
                },
                "attribute": "required",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
}
//# sourceMappingURL=ic-input-label.js.map
