import { Host, h } from "@stencil/core";
import { IcInformationStatus, } from "../../utils/types";
import errorIcon from "../../assets/error-icon.svg";
import successIcon from "../../assets/success-icon.svg";
import warningIcon from "../../assets/warning-icon.svg";
import { getInputValidationTextID, onComponentRequiredPropUndefined, } from "../../utils/helpers";
const icon = {
    [IcInformationStatus.Warning]: warningIcon,
    [IcInformationStatus.Error]: errorIcon,
    [IcInformationStatus.Success]: successIcon,
};
/**
 * @slot validation-message-adornment - Content will be placed to the right of the validation message.
 */
export class InputValidation {
    constructor() {
        this.ariaLiveMode = "polite";
        this.for = undefined;
        this.fullWidth = false;
        this.message = undefined;
        this.status = "";
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.message, propName: "message" }], "Input Validation");
    }
    render() {
        const displayIcon = this.status !== "" ? icon[this.status] : "";
        const id = getInputValidationTextID(this.for);
        return (h(Host, { class: {
                [this.status]: this.status !== "",
                ["fullwidth"]: this.fullWidth,
            } }, displayIcon !== "" && (h("span", { class: {
                ["status-icon"]: true,
                [`icon-${this.status}`]: true,
            }, innerHTML: displayIcon })), h("ic-typography", { variant: "caption", class: "statustext" }, h("span", { "aria-live": this.ariaLiveMode, id: id }, this.message)), h("slot", { name: "validation-message-adornment" })));
    }
    static get is() { return "ic-input-validation"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-input-validation.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-input-validation.css"]
        };
    }
    static get properties() {
        return {
            "ariaLiveMode": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcAriaLiveModeVariants",
                    "resolved": "\"assertive\" | \"polite\"",
                    "references": {
                        "IcAriaLiveModeVariants": {
                            "location": "import",
                            "path": "./ic-input-validation.types",
                            "id": "src/components/ic-input-validation/ic-input-validation.types.tsx::IcAriaLiveModeVariants"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The ARIA live mode to apply to the message."
                },
                "attribute": "aria-live-mode",
                "reflect": false,
                "defaultValue": "\"polite\""
            },
            "for": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The ID of the form element the validation is bound to."
                },
                "attribute": "for",
                "reflect": false
            },
            "fullWidth": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the input validation will fill the width of the container."
                },
                "attribute": "full-width",
                "reflect": false,
                "defaultValue": "false"
            },
            "message": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The validation message to display."
                },
                "attribute": "message",
                "reflect": false
            },
            "status": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcInformationStatusOrEmpty",
                    "resolved": "\"\" | \"error\" | \"success\" | \"warning\"",
                    "references": {
                        "IcInformationStatusOrEmpty": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcInformationStatusOrEmpty"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The status of the validation - e.g. 'error' | 'warning' | 'success'."
                },
                "attribute": "status",
                "reflect": false,
                "defaultValue": "\"\""
            }
        };
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-input-validation.js.map
