import { h, Host, forceUpdate, } from "@stencil/core";
import OpenInNew from "../../assets/OpenInNew.svg";
import { getThemeFromContext, inheritAttributes } from "../../utils/helpers";
import { IC_INHERITED_ARIA } from "../../utils/constants";
import { IcThemeForegroundEnum, } from "../../utils/types";
/**
 * @slot router-item - Handle routing by nesting your routes in this slot.
 */
export class Link {
    constructor() {
        this.inheritedAttributes = {};
        this.hostMutationObserver = null;
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName }) => {
                if (IC_INHERITED_ARIA.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] =
                        this.el.getAttribute(attributeName);
                    forceComponentUpdate = true;
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.appearance = "default";
        this.download = false;
        this.href = null;
        this.hreflang = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.showIcon = undefined;
        this.target = undefined;
    }
    componentWillLoad() {
        this.inheritedAttributes = inheritAttributes(this.el, IC_INHERITED_ARIA);
        this.updateTheme();
    }
    componentDidLoad() {
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            attributes: true,
        });
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    themeChangeHandler({ detail }) {
        this.updateTheme(detail.mode);
    }
    /**
     * Sets focus on the link.
     */
    async setFocus() {
        var _a;
        (_a = this.el.shadowRoot.querySelector("a")) === null || _a === void 0 ? void 0 : _a.focus();
    }
    updateTheme(newTheme = null) {
        const theme = getThemeFromContext(this.el, newTheme);
        if (theme !== IcThemeForegroundEnum.Default) {
            this.appearance = theme;
        }
    }
    hasRouterSlot() {
        this.routerSlot = this.el.querySelector('[slot="router-item"]');
        if (this.routerSlot) {
            this.routerSlot.ariaLabel = this.routerSlot.textContent;
        }
        return !!this.routerSlot;
    }
    render() {
        const { download, href, hreflang, referrerpolicy, rel, target, showIcon, appearance, } = this;
        return (h(Host, { class: { ["link"]: true, [`${appearance}`]: true } }, this.hasRouterSlot() ? (h("slot", { name: "router-item" })) : (h("a", Object.assign({ class: {
                ["ic-link"]: href !== null,
                [`${appearance}`]: href !== null,
            }, download: download !== false ? download : null, href: href, hrefLang: hreflang, referrerPolicy: referrerpolicy, rel: rel, target: target, tabindex: href !== null ? "0" : "-1" }, this.inheritedAttributes), h("slot", null), (showIcon || target === "_blank") && (h("span", { class: "ic-link-open-in-new-icon", innerHTML: OpenInNew }))))));
    }
    static get is() { return "ic-link"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-link.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-link.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "IcThemeForeground",
                    "resolved": "\"dark\" | \"default\" | \"light\"",
                    "references": {
                        "IcThemeForeground": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForeground"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the link, e.g. dark, light, or default."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "download": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | boolean",
                    "resolved": "boolean | string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the user can save the linked URL instead of navigating to it."
                },
                "attribute": "download",
                "reflect": false,
                "defaultValue": "false"
            },
            "href": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The URL that the link points to."
                },
                "attribute": "href",
                "reflect": false,
                "defaultValue": "null"
            },
            "hreflang": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The human language of the linked URL."
                },
                "attribute": "hreflang",
                "reflect": false
            },
            "referrerpolicy": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "ReferrerPolicy",
                    "resolved": "\"\" | \"no-referrer\" | \"no-referrer-when-downgrade\" | \"origin\" | \"origin-when-cross-origin\" | \"same-origin\" | \"strict-origin\" | \"strict-origin-when-cross-origin\" | \"unsafe-url\"",
                    "references": {
                        "ReferrerPolicy": {
                            "location": "global",
                            "id": "global::ReferrerPolicy"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "How much of the referrer to send when following the link."
                },
                "attribute": "referrerpolicy",
                "reflect": false
            },
            "rel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The relationship of the linked URL as space-separated link types."
                },
                "attribute": "rel",
                "reflect": false
            },
            "showIcon": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. The 'open in new tab/window' icon will display automatically if target=\"_blank\"."
                        }],
                    "text": ""
                },
                "attribute": "show-icon",
                "reflect": false
            },
            "target": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe)."
                },
                "attribute": "target",
                "reflect": false
            }
        };
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the link.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "themeChange",
                "method": "themeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-link.js.map
