import { h, Host } from "@stencil/core";
import { IcThemeForegroundEnum, } from "../../utils/types";
import { isPropDefined } from "../../utils/helpers";
export class LoadingIndicator {
    constructor() {
        this.updateCircularProgressMeter = () => {
            if (!this.indeterminate) {
                this.circularMeter.style.setProperty("--progress-value", String(this.progress));
            }
        };
        this.getLabel = (labelIndex, setLabel) => {
            return new Promise(() => {
                this.interval = setInterval(() => {
                    if (labelIndex < this.labelList.length - 1) {
                        labelIndex++;
                    }
                    else {
                        labelIndex = 0;
                    }
                    setLabel(this.labelList[labelIndex]);
                }, this.labelDuration);
            });
        };
        this.getLabelVariant = () => {
            var _a;
            let variant = "h4";
            const width = (_a = this.outerElement) === null || _a === void 0 ? void 0 : _a.offsetWidth;
            if (this.size === "small" || (this.type === "circular" && width < 60)) {
                variant = "label";
            }
            else if (this.size === "large" ||
                (this.type === "circular" && width >= 120)) {
                variant = "h2";
            }
            return variant;
        };
        // Sets the circular indicator line width - accounting for the circle size being altered using the CSS custom property
        this.setCircleLineWidth = () => {
            const { offsetWidth: width } = this.outerElement;
            const compactStepCircularLineWidth = this.el.classList.contains("compact-step-progress-indicator")
                ? 40
                : 0;
            const toastDismissTimerCircularLineWidth = this.el.classList.contains("toast-dismiss-timer")
                ? 20
                : 0;
            if (width ||
                compactStepCircularLineWidth ||
                toastDismissTimerCircularLineWidth) {
                this.circularLineWidth =
                    (compactStepCircularLineWidth ||
                        toastDismissTimerCircularLineWidth ||
                        width) * 0.1;
                this.circularDiameter =
                    compactStepCircularLineWidth ||
                        toastDismissTimerCircularLineWidth ||
                        width;
                this.outerElement.style.setProperty("--circular-line-width", `${this.circularLineWidth}px`);
            }
        };
        this.setLinearDeterminateWidth = () => {
            if (!this.innerElement)
                return;
            // Ensure progress cannot be out of bounds
            const progress = Math.min(this.max, Math.max(this.min, this.progress));
            const proportion = (progress - this.min) / (this.max - this.min);
            this.showSecond = proportion > 0.5;
            if (this.showSecond) {
                this.innerElement.classList.remove("clip");
            }
            else {
                this.innerElement.classList.add("clip");
            }
            this.innerElement.style.setProperty("--linear-width", `${proportion * 100}%`);
        };
        this.calcOuterClass = () => {
            let cls = `ic-loading-${this.type}-outer`;
            cls += this.indeterminate ? " indeterminate" : " determinate";
            return cls;
        };
        this.updateLabel = () => {
            if (isPropDefined(this.label)) {
                this.labelList = this.label.split("/");
                const labelIndex = 0;
                this.indicatorLabel = this.labelList[labelIndex];
                if (this.labelList.length > 1) {
                    this.getLabel(labelIndex, (label) => {
                        this.indicatorLabel = label;
                    });
                }
            }
        };
        this.setCircleXY = () => {
            if (this.circularDiameter > 0) {
                const r = this.circularDiameter / 2;
                const x = r;
                const y = r;
                const nextRadius = r - this.circularLineWidth / 2;
                this.setDashSteps(nextRadius);
                return { x, y, r: nextRadius };
            }
            return { x: 0, y: 0, r: 0 };
        };
        this.setDashSteps = (radius) => {
            const dashArray = 2 * Math.PI * radius;
            const progress = Math.min(Math.max(this.progress, this.min), this.max);
            const proportion = -1 - (progress - this.min) / (this.max - this.min);
            this.circularMeter.style.setProperty("--stroke-dasharray", `${dashArray}px`);
            if (!this.indeterminate) {
                this.circularMeter.style.setProperty("--circular-steps-max", String(this.max));
                this.circularMeter.style.setProperty("--stroke-dashoffset", `${proportion * dashArray}px`);
            }
        };
        this.circularDiameter = undefined;
        this.circularLineWidth = undefined;
        this.indeterminate = undefined;
        this.indicatorLabel = undefined;
        this.showSecond = false;
        this.appearance = "dark";
        this.description = "Loading";
        this.fullWidth = false;
        this.innerLabel = undefined;
        this.labelDuration = 8000;
        this.max = 100;
        this.min = 0;
        this.size = "default";
        this.type = "circular";
        this.label = undefined;
        this.progress = undefined;
    }
    watchPropHandler() {
        this.updateLabel();
    }
    watchProgressHandler() {
        if (this.type === "circular") {
            this.updateCircularProgressMeter();
        }
    }
    disconnectedCallback() {
        clearInterval(this.interval);
    }
    componentWillLoad() {
        this.indeterminate = this.progress === undefined;
        this.updateLabel();
        this.el.setAttribute("exportparts", "ic-loading-container");
    }
    componentDidLoad() {
        if (this.type === "circular") {
            this.setCircleLineWidth();
            this.circularMeter = this.el.shadowRoot.querySelector(".ic-loading-circular-svg circle:nth-child(2)");
            this.updateCircularProgressMeter();
        }
        if (Number(this.progress) >= 0 && this.type === "linear") {
            this.setLinearDeterminateWidth();
        }
    }
    componentWillUpdate() {
        this.indeterminate = this.progress === undefined;
    }
    componentDidUpdate() {
        if (Number(this.progress) >= 0 && this.type === "linear") {
            this.setLinearDeterminateWidth();
        }
    }
    render() {
        const { appearance, label, description, size, fullWidth, innerLabel } = this;
        const { x, y, r } = this.setCircleXY();
        return (h(Host, { class: {
                ["light"]: appearance === IcThemeForegroundEnum.Light,
                ["label"]: !!label,
                ["full-width"]: fullWidth,
                ["inner-label"]: !!innerLabel,
            } }, h("div", { class: "ic-loading-container", part: "ic-loading-container" }, h("div", { ref: (el) => (this.outerElement = el), class: this.calcOuterClass(), role: "progressbar", "aria-labelledby": this.label && this.size !== "icon" && "ic-loading-label", "aria-label": description, "aria-valuenow": this.progress, "aria-valuemin": this.min, "aria-valuemax": this.max }, h("div", { ref: (el) => (this.innerElement = el), class: `ic-loading-${this.type}-inner` }, this.innerLabel &&
            this.innerLabel !== undefined &&
            this.size === "small" && (h("ic-typography", { variant: "subtitle-small", class: "inner-text" }, this.innerLabel)), this.type === "circular" && (h("svg", { class: "ic-loading-circular-svg", viewBox: `0 0 ${this.circularDiameter || 0} ${this.circularDiameter || 0}` }, h("circle", { cx: `${x}`, cy: `${y}`, r: `${r}` }), h("circle", { cx: `${x}`, cy: `${y}`, r: `${r}` }))))), label && size !== "icon" && (h("ic-typography", { id: "ic-loading-label", class: "ic-loading-label", role: "status", variant: this.getLabelVariant() }, h("p", null, this.indicatorLabel))))));
    }
    static get is() { return "ic-loading-indicator"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-loading-indicator.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-loading-indicator.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForegroundNoDefault",
                    "resolved": "\"dark\" | \"light\"",
                    "references": {
                        "IcThemeForegroundNoDefault": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForegroundNoDefault"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the loading indicator, e.g. dark or light."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"dark\""
            },
            "description": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The description that will be set as the aria-label of the loading indicator when not using a visible label."
                },
                "attribute": "description",
                "reflect": false,
                "defaultValue": "\"Loading\""
            },
            "fullWidth": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, when linear, the full-width variant (i.e. without a border radius) will be displayed."
                },
                "attribute": "full-width",
                "reflect": true,
                "defaultValue": "false"
            },
            "innerLabel": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The step number of a compact step, managed by ic-step."
                        }],
                    "text": ""
                },
                "attribute": "inner-label",
                "reflect": false
            },
            "labelDuration": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The time in milliseconds before the label changes."
                },
                "attribute": "label-duration",
                "reflect": false,
                "defaultValue": "8000"
            },
            "max": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The maximum value that the progress value can take.\nUsed to calculate the proportional width of the progress bar."
                },
                "attribute": "max",
                "reflect": false,
                "defaultValue": "100"
            },
            "min": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The minimum value that the progress value can take.\nUsed to calculate the proportional width of the progress bar."
                },
                "attribute": "min",
                "reflect": false,
                "defaultValue": "0"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcLoadingSizes",
                    "resolved": "\"default\" | \"icon\" | \"large\" | \"small\"",
                    "references": {
                        "IcLoadingSizes": {
                            "location": "import",
                            "path": "./ic-loading-indicator.types",
                            "id": "src/components/ic-loading-indicator/ic-loading-indicator.types.tsx::IcLoadingSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the loading indicator."
                },
                "attribute": "size",
                "reflect": true,
                "defaultValue": "\"default\""
            },
            "type": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcLoadingTypes",
                    "resolved": "\"circular\" | \"linear\"",
                    "references": {
                        "IcLoadingTypes": {
                            "location": "import",
                            "path": "./ic-loading-indicator.types",
                            "id": "src/components/ic-loading-indicator/ic-loading-indicator.types.tsx::IcLoadingTypes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The type of indicator, either linear or circular."
                },
                "attribute": "type",
                "reflect": true,
                "defaultValue": "\"circular\""
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The label to be displayed beneath the loading indicator.\nDisplay a changing label by separating multiple messages with forward slashes."
                },
                "attribute": "label",
                "reflect": false
            },
            "progress": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The current amount of progress made.\nIf not provided, component acts as an indeterminate loading indicator."
                },
                "attribute": "progress",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "circularDiameter": {},
            "circularLineWidth": {},
            "indeterminate": {},
            "indicatorLabel": {},
            "showSecond": {}
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "label",
                "methodName": "watchPropHandler"
            }, {
                "propName": "progress",
                "methodName": "watchProgressHandler"
            }];
    }
}
//# sourceMappingURL=ic-loading-indicator.js.map
