import { Host, h } from "@stencil/core";
import { isPropDefined } from "../../utils/helpers";
export class MenuGroup {
    constructor() {
        this.label = undefined;
    }
    render() {
        const parentMenu = this.el.closest("ic-popover-menu");
        return (h(Host, { "aria-label": this.label !== null ? this.label : "" }, isPropDefined(this.label) && (h("ic-typography", { variant: "subtitle-small" }, this.label)), h("ul", { role: "group" }, h("slot", null)), this.el !== (parentMenu === null || parentMenu === void 0 ? void 0 : parentMenu.querySelector("ic-menu-group:last-child")) && (h("hr", null))));
    }
    static get is() { return "ic-menu-group"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-menu-group.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-menu-group.css"]
        };
    }
    static get properties() {
        return {
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The label to display as the title of the menu group."
                },
                "attribute": "label",
                "reflect": false
            }
        };
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-menu-group.js.map
