import { Host, h, } from "@stencil/core";
import { isSlotUsed, onComponentRequiredPropUndefined, removeDisabledFalse, isPropDefined, } from "../../utils/helpers";
import Check from "../../assets/check-icon.svg";
import Chevron from "../../assets/chevron-icon.svg";
/**
 * @slot icon - Content will be placed to the left of the menu item label.
 */
export class MenuItem {
    constructor() {
        this.handleClick = (e) => {
            if (isPropDefined(this.submenuTriggerFor)) {
                this.triggerPopoverMenuInstance.emit();
            }
            else if (this.variant === "toggle") {
                e.preventDefault();
                this.toggleChecked = !this.toggleChecked;
            }
            this.handleMenuItemClick.emit({
                label: this.label,
                hasSubMenu: !!this.el.submenuTriggerFor,
            });
        };
        this.getMenuItemAriaLabel = () => {
            let ariaLabel = this.label;
            if (isPropDefined(this.description)) {
                ariaLabel = `${ariaLabel}, ${this.description}`;
            }
            if (isPropDefined(this.keyboardShortcut)) {
                ariaLabel = `${ariaLabel}, ${this.keyboardShortcut}`;
            }
            if (this.variant === "destructive") {
                ariaLabel = `${ariaLabel}, destructive`;
            }
            if (isPropDefined(this.submenuTriggerFor)) {
                ariaLabel = `${ariaLabel}, triggers submenu`;
            }
            if (this.el.classList.contains("ic-popover-submenu-back-button")) {
                ariaLabel = "Go back to parent menu";
            }
            const parentEl = this.el.parentElement;
            if (parentEl.tagName === "IC-MENU-GROUP" &&
                parentEl.label) {
                return `${ariaLabel}, ${parentEl.label} menu group`;
            }
            else {
                return ariaLabel;
            }
        };
        this.toggleChecked = false;
        this.description = undefined;
        this.disabled = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.keyboardShortcut = undefined;
        this.label = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.submenuTriggerFor = undefined;
        this.target = undefined;
        this.variant = "default";
    }
    componentWillLoad() {
        // This ensures that trigger menu items are always set to the default variant
        if (isPropDefined(this.submenuTriggerFor) && this.variant !== "default") {
            this.variant = "default";
        }
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Menu Item");
    }
    handleHostClick(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
    }
    render() {
        // A sub-component to layout the menu information correctly in ic-button
        const MenuItemInformation = () => {
            return (h("div", { class: "menu-item-info" }, h("div", { class: "menu-labels" }, h("ic-typography", { class: "menu-item-label" }, this.label), this.keyboardShortcut && (h("ic-typography", { variant: "caption", class: "shortcut" }, this.keyboardShortcut))), this.description && (h("ic-typography", { class: "menu-item-description", variant: "caption" }, this.description))));
        };
        return (h(Host, { class: {
                ["disabled"]: this.disabled,
            } }, h("li", { role: this.variant === "toggle" ? "menuitemcheckbox" : "menuitem", "aria-disabled": `${this.disabled}`, "aria-checked": this.variant === "toggle" ? this.toggleChecked : undefined }, h("ic-button", { fullWidth: true, variant: "tertiary", onClick: this.handleClick, href: isPropDefined(this.href), hreflang: isPropDefined(this.hreflang), target: isPropDefined(this.target), rel: isPropDefined(this.rel), referrerpolicy: this.referrerpolicy !== undefined ? this.referrerpolicy : null, "aria-disabled": `${this.disabled}`, "aria-label": this.getMenuItemAriaLabel(), ariaControlsId: isPropDefined(this.submenuTriggerFor)
                ? `ic-popover-submenu-${this.submenuTriggerFor}`
                : false, "aria-haspopup": isPropDefined(this.submenuTriggerFor) ||
                this.el.classList.contains("ic-popover-submenu-back-button")
                ? "menu"
                : false, ariaOwnsId: isPropDefined(this.submenuTriggerFor)
                ? `ic-popover-submenu-${this.submenuTriggerFor}`
                : false }, h("div", { class: "focus-border" }, isSlotUsed(this.el, "icon") && (h("span", { class: "icon" }, h("slot", { name: "icon" }))), h(MenuItemInformation, null), this.variant === "toggle" && (h("span", { class: {
                ["check-icon"]: true,
                ["hide"]: !this.toggleChecked,
            }, "aria-hidden": "true", innerHTML: Check })), isPropDefined(this.submenuTriggerFor) && (h("span", { class: { ["submenu-icon"]: true }, "aria-hidden": "true", innerHTML: Chevron })))))));
    }
    static get is() { return "ic-menu-item"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-menu-item.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-menu-item.css"]
        };
    }
    static get properties() {
        return {
            "description": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The description displayed in the menu item, below the label."
                },
                "attribute": "description",
                "reflect": false
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the menu item will be in disabled state."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "href": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The URL that the link points to. This will render the menu item as an \"a\" tag."
                },
                "attribute": "href",
                "reflect": false
            },
            "hreflang": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The human language of the linked URL."
                },
                "attribute": "hreflang",
                "reflect": false
            },
            "keyboardShortcut": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The label describing the keyboard shortcut for a menu item's action."
                },
                "attribute": "keyboard-shortcut",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label to display in the menu item."
                },
                "attribute": "label",
                "reflect": false
            },
            "referrerpolicy": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "ReferrerPolicy",
                    "resolved": "\"\" | \"no-referrer\" | \"no-referrer-when-downgrade\" | \"origin\" | \"origin-when-cross-origin\" | \"same-origin\" | \"strict-origin\" | \"strict-origin-when-cross-origin\" | \"unsafe-url\"",
                    "references": {
                        "ReferrerPolicy": {
                            "location": "global",
                            "id": "global::ReferrerPolicy"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "How much of the referrer to send when following the link."
                },
                "attribute": "referrerpolicy",
                "reflect": false
            },
            "rel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The relationship of the linked URL as space-separated link types."
                },
                "attribute": "rel",
                "reflect": false
            },
            "submenuTriggerFor": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "This references the popover menu instance that the menu item is a trigger for. If this prop is set, then the variant will always be default."
                },
                "attribute": "submenu-trigger-for",
                "reflect": false
            },
            "target": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe)."
                },
                "attribute": "target",
                "reflect": false
            },
            "variant": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "IcMenuItemVariants",
                    "resolved": "\"default\" | \"destructive\" | \"toggle\"",
                    "references": {
                        "IcMenuItemVariants": {
                            "location": "import",
                            "path": "./ic-menu-item.types",
                            "id": "src/components/ic-menu-item/ic-menu-item.types.ts::IcMenuItemVariants"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The variant of the menu item."
                },
                "attribute": "variant",
                "reflect": true,
                "defaultValue": "\"default\""
            }
        };
    }
    static get states() {
        return {
            "toggleChecked": {}
        };
    }
    static get events() {
        return [{
                "method": "childBlur",
                "name": "childBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when item loses focus."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "handleMenuItemClick",
                "name": "handleMenuItemClick",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when the user clicks a menu item."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "{\n    label: string;\n    hasSubMenu: boolean;\n  }",
                    "resolved": "{ label: string; hasSubMenu: boolean; }",
                    "references": {}
                }
            }, {
                "method": "triggerPopoverMenuInstance",
                "name": "triggerPopoverMenuInstance",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when the user clicks a menu item that triggers a popover menu instance."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "click",
                "method": "handleHostClick",
                "target": undefined,
                "capture": true,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-menu-item.js.map
