import { h, Host, Fragment, } from "@stencil/core";
import { createPopper } from "@popperjs/core";
import Check from "../../assets/check-icon.svg";
import { onComponentRequiredPropUndefined } from "../../utils/helpers";
// eslint-disable-next-line @typescript-eslint/no-unused-vars
export class Menu {
    constructor() {
        this.disabledOptionSelected = false;
        this.hasPreviouslyBlurred = false;
        this.hasTimedOut = false;
        this.isLoading = false;
        this.isSearchBar = false;
        this.isSearchableSelect = false;
        // Prevents menu re-opening immediately after it is closed on blur when clicking input.
        this.preventClickOpen = false;
        this.ungroupedOptions = [];
        this.handleClearListener = () => {
            this.optionHighlighted = "";
        };
        this.handleSubmitSearch = () => {
            const highlightedOptionIndex = this.options.findIndex((option) => option[this.valueField] === this.optionHighlighted);
            this.setInputValue(highlightedOptionIndex);
        };
        this.handleMenuChange = (open, focusInput) => {
            this.menuStateChange.emit({ open, focusInput });
            if (!open && focusInput !== false) {
                this.inputEl.focus();
                this.preventClickOpen = false;
            }
        };
        this.setNextOptionValue = (selectedOptionIndex) => {
            if (this.ungroupedOptions[selectedOptionIndex + 1]) {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[selectedOptionIndex + 1][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[selectedOptionIndex + 1][this.valueField]),
                });
            }
            else {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[0][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[0][this.valueField]),
                });
            }
        };
        this.setPreviousOptionValue = (selectedOptionIndex) => {
            if (this.ungroupedOptions[selectedOptionIndex - 1]) {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[selectedOptionIndex - 1][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[selectedOptionIndex - 1][this.valueField]),
                });
            }
            else {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[this.ungroupedOptions.length - 1][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[this.ungroupedOptions.length - 1][this.valueField]),
                });
            }
        };
        this.getParentEl = (parent) => {
            if (parent.tagName === "IC-SEARCH-BAR") {
                this.isSearchBar = true;
            }
            else if (parent.tagName === "IC-SELECT" &&
                parent.getAttribute("searchable") !== null &&
                parent.getAttribute("searchable") !== undefined) {
                this.isSearchableSelect = true;
            }
        };
        this.arrowBehaviour = (event) => {
            event.preventDefault();
            this.handleMenuChange(true);
        };
        this.setMenuOptions = () => this.isSearchBar ? this.options : this.ungroupedOptions;
        this.setHighlightedOption = (highlightedIndex) => {
            const menuOptions = this.setMenuOptions();
            menuOptions[highlightedIndex] &&
                !menuOptions[highlightedIndex].timedOut &&
                (this.optionHighlighted =
                    menuOptions[highlightedIndex][this.valueField] || undefined);
        };
        this.autoSetInputValueKeyboardOpen = (event) => {
            const selectedOptionIndex = this.ungroupedOptions.findIndex((option) => option[this.valueField] === this.value);
            this.keyboardNav = false;
            switch (event.key) {
                case "ArrowDown":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    this.setNextOptionValue(selectedOptionIndex);
                    break;
                case "ArrowUp":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    this.setPreviousOptionValue(selectedOptionIndex);
                    break;
                case " ":
                case "Enter":
                    if (event.target.id !== "clear-button") {
                        this.handleMenuChange(true);
                    }
                    break;
            }
        };
        this.manSetInputValueKeyboardOpen = (event) => {
            const menuOptions = this.setMenuOptions();
            const highlightedOptionIndex = menuOptions.findIndex((option) => option[this.valueField] === this.optionHighlighted);
            const getOptionId = (index) => { var _a; return (_a = Array.from(this.host.querySelectorAll("li"))[index]) === null || _a === void 0 ? void 0 : _a.id; };
            const isOpen = this.isSearchBar || this.isSearchableSelect || this.open;
            switch (event.key) {
                case "ArrowDown":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    if (highlightedOptionIndex < menuOptions.length - 1) {
                        this.setHighlightedOption(highlightedOptionIndex + 1);
                        this.menuOptionId.emit({
                            optionId: getOptionId(highlightedOptionIndex + 1),
                        });
                    }
                    else {
                        this.setHighlightedOption(0);
                        this.menuOptionId.emit({
                            optionId: getOptionId(0),
                        });
                    }
                    this.preventIncorrectTabOrder = false;
                    this.focusFromSearchKeypress = false;
                    break;
                case "ArrowUp":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    if (highlightedOptionIndex <= 0 ||
                        highlightedOptionIndex > menuOptions.length + 1) {
                        this.setHighlightedOption(menuOptions.length - 1);
                        this.menuOptionId.emit({
                            optionId: getOptionId(menuOptions.length - 1),
                        });
                    }
                    else {
                        this.setHighlightedOption(highlightedOptionIndex - 1);
                        this.menuOptionId.emit({
                            optionId: getOptionId(highlightedOptionIndex - 1),
                        });
                    }
                    this.preventIncorrectTabOrder = false;
                    this.focusFromSearchKeypress = false;
                    break;
                case "Home":
                    this.keyboardNav = true;
                    event.preventDefault();
                    this.arrowBehaviour(event);
                    this.setHighlightedOption(0);
                    this.menuOptionId.emit({
                        optionId: getOptionId(0),
                    });
                    break;
                case "End":
                    this.keyboardNav = true;
                    event.preventDefault();
                    this.arrowBehaviour(event);
                    this.setHighlightedOption(menuOptions.length - 1);
                    this.menuOptionId.emit({
                        optionId: getOptionId(menuOptions.length - 1),
                    });
                    break;
                case " ":
                    this.keyboardNav = false;
                    if (this.isSearchBar || this.isSearchableSelect) {
                        break;
                    }
                    else {
                        if (event.target.id !== "clear-button") {
                            this.handleMenuChange(true);
                        }
                    }
                    break;
                case "Enter":
                    event.preventDefault();
                    this.keyboardNav = false;
                    if (isOpen) {
                        if (highlightedOptionIndex >= 0) {
                            if (menuOptions[highlightedOptionIndex] !== undefined) {
                                if (this.isSearchBar &&
                                    menuOptions[highlightedOptionIndex].disabled === true) {
                                    this.disabledOptionSelected = true;
                                }
                                else {
                                    this.setInputValue(highlightedOptionIndex);
                                    this.value =
                                        menuOptions[highlightedOptionIndex][this.valueField];
                                }
                            }
                        }
                        else {
                            this.setInputValue(highlightedOptionIndex);
                        }
                    }
                    else {
                        this.handleMenuChange(true);
                    }
                    break;
                case "Escape":
                    if (this.open) {
                        event.stopImmediatePropagation();
                    }
                    this.handleMenuChange(false);
                    this.menuOptionId.emit({ optionId: undefined });
                    break;
                case "Shift":
                case "Tab":
                    if (this.isSearchBar) {
                        this.keyboardNav = true;
                    }
                    this.preventIncorrectTabOrder = true;
                    break;
                default:
                    this.keyboardNav = false;
                    this.focusOnSearchOrSelectInput(menuOptions, highlightedOptionIndex);
                    break;
            }
        };
        this.setInputValue = (highlightedOptionIndex) => {
            const menuOptions = this.setMenuOptions();
            if (menuOptions[highlightedOptionIndex] !== undefined) {
                this.menuOptionSelect.emit({
                    value: menuOptions[highlightedOptionIndex][this.valueField],
                });
                this.optionHighlighted = undefined;
                this.menuOptionId.emit({ optionId: undefined });
            }
            if (!this.hasTimedOut)
                this.handleMenuChange(false);
            else
                this.parentEl.setFocus();
        };
        this.handleOptionClick = (event) => {
            const { value, label } = event.target.dataset;
            this.menuOptionSelect.emit({ value, label });
            this.handleMenuChange(false);
        };
        this.handleRetry = () => {
            this.retryButtonClicked.emit({ value: this.value });
        };
        this.handleRetryKeyDown = (ev) => {
            if (ev.key === "Enter" || ev.key === " ") {
                ev.preventDefault();
                this.retryButtonClicked.emit({ value: this.value, keyPressed: ev.key });
            }
        };
        this.handleBlur = (event) => {
            if (event.relatedTarget !== this.inputEl) {
                if (!this.menu.contains(event.relatedTarget)) {
                    this.handleMenuChange(false, this.hasPreviouslyBlurred);
                }
            }
            else {
                this.handleMenuChange(false);
                this.preventClickOpen = true;
            }
            if (!this.isSearchBar)
                this.hasPreviouslyBlurred = !!event.relatedTarget;
        };
        this.handleMouseDown = (event) => {
            event.preventDefault();
        };
        this.handleMenuKeyDown = (event) => {
            if (this.activationType === "automatic") {
                this.autoSetValueOnMenuKeyDown(event);
            }
            else if (this.activationType === "manual" && !this.isSearchBar) {
                this.manSetInputValueKeyboardOpen(event);
            }
        };
        this.emitMenuKeyPress = (isNavKey, key) => {
            this.menuKeyPress.emit({ isNavKey: isNavKey, key: key });
        };
        this.autoSetValueOnMenuKeyDown = (event) => {
            event.cancelBubble = true;
            const selectedOptionIndex = this.ungroupedOptions.findIndex((option) => option[this.valueField] === this.value);
            const isSearchableSelect = this.inputEl.tagName === "INPUT";
            this.keyboardNav = false;
            switch (event.key) {
                case " ":
                    event.preventDefault();
                    break;
                case "ArrowUp":
                    if (!this.hasTimedOut) {
                        event.preventDefault();
                        this.setPreviousOptionValue(selectedOptionIndex);
                        this.keyboardNav = true;
                    }
                    break;
                case "ArrowDown":
                    if (!this.hasTimedOut) {
                        event.preventDefault();
                        this.setNextOptionValue(selectedOptionIndex);
                        this.keyboardNav = true;
                    }
                    break;
                case "Home":
                    this.menuOptionSelect.emit({
                        value: this.ungroupedOptions[0][this.valueField],
                    });
                    this.keyboardNav = true;
                    break;
                case "End":
                    this.menuOptionSelect.emit({
                        value: this.ungroupedOptions[this.ungroupedOptions.length - 1][this.valueField],
                    });
                    this.keyboardNav = true;
                    break;
                case "Enter":
                    !this.hasTimedOut && this.handleMenuChange(false);
                    break;
                case "Escape":
                    this.handleMenuChange(false);
                    break;
                case "Backspace":
                    if (isSearchableSelect) {
                        this.inputEl.focus();
                    }
                    break;
                case "Shift":
                    break;
                default:
                    if (isSearchableSelect && event.key !== "Tab" && !this.hasTimedOut) {
                        this.inputEl.focus();
                    }
                    if (event.key.length === 1) {
                        this.keyboardNav = true;
                    }
                    break;
            }
            this.emitMenuKeyPress(this.keyboardNav, event.key);
        };
        this.handleMenuKeyUp = (event) => {
            if (event.key === "Tab" && event.shiftKey) {
                this.preventClickOpen = false;
            }
            if (event.key === "Enter" && this.disabledOptionSelected) {
                this.disabledOptionSelected = false;
                event.stopImmediatePropagation();
            }
        };
        this.getOptionId = (value) => {
            return `${this.menuId}-${value}`;
        };
        this.getOptionAriaLabel = (option, parentOption) => {
            let ariaLabel = option[this.labelField];
            if (option.description) {
                ariaLabel = `${ariaLabel}, ${option.description}`;
            }
            if (option.element) {
                ariaLabel = `${ariaLabel}, ${option.element.ariaLabel}`;
            }
            if (parentOption) {
                return `${ariaLabel}, ${parentOption[this.labelField]} group`;
            }
            else {
                return ariaLabel;
            }
        };
        this.getSortedOptions = (options) => {
            let sorted = [];
            if (options.sort) {
                sorted = options.sort((optionA, optionB) => optionA.recommended && !optionB.recommended ? -1 : 0);
            }
            return sorted;
        };
        this.isManualMode = this.activationType === "manual";
        this.scrollToSelected = (menu) => {
            const selectedOption = this.selectOnEnter
                ? this.host.querySelector(`li[data-value="${this.optionHighlighted}"]`)
                : menu.querySelector(".option[aria-selected='true']");
            if (selectedOption) {
                const elTop = selectedOption.offsetTop + selectedOption.offsetHeight;
                if (elTop > menu.scrollTop + menu.offsetHeight ||
                    elTop < menu.scrollTop + menu.offsetHeight) {
                    menu.scrollTop = selectedOption.offsetTop;
                }
                selectedOption.focus();
            }
        };
        this.loadUngroupedOptions = () => {
            if (this.options.length > 0 && this.options.map) {
                this.options.map((option) => {
                    if (option.children) {
                        option.children.map((option) => !option.disabled && this.ungroupedOptions.push(option));
                    }
                    else if (!option.disabled) {
                        this.ungroupedOptions.push(option);
                    }
                });
            }
            this.ungroupedOptions = this.getSortedOptions(this.ungroupedOptions);
            this.ungroupedOptionsSet.emit({ options: this.ungroupedOptions });
        };
        this.setMenuScrollbar = () => {
            let optionsHeight = 0;
            this.host
                .querySelectorAll(".option")
                .forEach((option) => (optionsHeight += option.clientHeight));
            if (optionsHeight >= 320) {
                this.menu.classList.add("menu-scroll");
            }
        };
        this.handleTimeoutBlur = (ev) => {
            this.timeoutBlur.emit({ ev });
        };
        this.optionContent = (option) => {
            var _a;
            return (h(Fragment, null, option.loading && h("ic-loading-indicator", { size: "icon" }), h("div", { class: "option-text-container" }, h("div", { class: "option-label" }, option.icon && (h("div", { class: "option-icon", innerHTML: option.icon, "aria-hidden": "true" })), h("ic-typography", { variant: "body", "aria-hidden": "true" }, option[this.labelField])), option.description && (h("ic-typography", { id: `${this.getOptionId(option[this.valueField])}-description`, class: "option-description", variant: "caption", "aria-hidden": "true" }, h("p", null, option.description))), option.element && (h("div", { class: "option-element", innerHTML: option.element.component, "aria-hidden": "true" }))), !!option[this.valueField] &&
                !!this.value &&
                option[this.valueField].toLowerCase() === ((_a = this.value) === null || _a === void 0 ? void 0 : _a.toLowerCase()) &&
                this.parentEl.tagName !== "IC-SEARCH-BAR" && (h("span", { class: "check-icon", innerHTML: Check }))));
        };
        this.displayOption = (option, index, parentOption) => {
            const { open, value, keyboardNav, isManualMode, initialOptionsListRender, optionHighlighted, options, } = this;
            return (h("li", { id: this.getOptionId(option[this.valueField]), class: {
                    option: true,
                    "focused-option": isManualMode
                        ? (keyboardNav || initialOptionsListRender) &&
                            option[this.valueField] === optionHighlighted
                        : keyboardNav && option[this.valueField] === value,
                    "last-recommended-option": option.recommended &&
                        options[index + 1] &&
                        !options[index + 1].recommended,
                    "disabled-option": option.disabled,
                    "loading-option": option.loading,
                    timeout: option.timedOut,
                }, role: "option", tabindex: open &&
                    (option[this.valueField] === value ||
                        option[this.valueField] === optionHighlighted) &&
                    keyboardNav
                    ? "0"
                    : "-1", "aria-label": this.getOptionAriaLabel(option, parentOption), "aria-selected": `${option[this.valueField] === value}`, "aria-disabled": option.disabled ? "true" : "false", onClick: !option.timedOut && !option.loading && this.handleOptionClick, onBlur: this.handleBlur, onMouseDown: this.handleMouseDown, "data-value": option[this.valueField], "data-label": option[this.labelField] }, option.timedOut ? (h(Fragment, null, h("div", { class: "loading-error-info" }, h("svg", { class: "error-icon-svg", "aria-labelledby": "error-title", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", fill: "#000000" }, h("title", { id: "error-title" }, "Error"), h("g", { id: "close-octagon" }, h("path", { id: "Vector", d: "M8.77 3L3.5 8.27V15.73L8.77 21H16.23L21.5 15.73V8.27L16.23 3M8.91 7L12.5 10.59L16.09 7L17.5 8.41L13.91 12L17.5 15.59L16.09 17L12.5 13.41L8.91 17L7.5 15.59L11.09 12L7.5 8.41" }))), h("ic-typography", { variant: "label" }, option[this.labelField])), h("ic-button", { size: "small", variant: "tertiary", onClick: this.handleRetry, onKeyDown: this.handleRetryKeyDown, onBlur: this.handleTimeoutBlur, id: "retry-button" }, "Retry"))) : (this.optionContent(option))));
        };
        this.focusFromSearchKeypress = false;
        this.initialOptionsListRender = false;
        this.keyboardNav = false;
        this.optionHighlighted = undefined;
        this.preventIncorrectTabOrder = false;
        this.activationType = "automatic";
        this.anchorEl = undefined;
        this.autoFocusOnSelected = true;
        this.fullWidth = false;
        this.inputEl = undefined;
        this.inputLabel = undefined;
        this.labelField = "label";
        this.menuId = undefined;
        this.open = undefined;
        this.parentEl = undefined;
        this.searchMode = "navigation";
        this.selectOnEnter = false;
        this.size = "default";
        this.small = false;
        this.options = undefined;
        this.value = undefined;
        this.valueField = "value";
    }
    watchOpenHandler() {
        if (!this.open && this.popperInstance) {
            this.popperInstance.destroy();
            this.popperInstance = null;
        }
    }
    watchOptionsHandler(newOptions) {
        this.hasTimedOut = newOptions.some((opt) => opt.timedOut);
        this.isLoading = newOptions.some((opt) => opt.loading);
        this.ungroupedOptions = [];
        this.loadUngroupedOptions();
    }
    watchValueHandler() {
        this.menuValueChange.emit({ value: this.value });
    }
    connectedCallback() {
        this.getParentEl(this.parentEl);
        if (this.isSearchBar) {
            if (this.searchMode === "navigation")
                this.setHighlightedOption(0);
            this.initialOptionsListRender = true;
        }
    }
    disconnectedCallback() {
        if (this.popperInstance) {
            this.popperInstance.destroy();
        }
        this.parentEl.removeEventListener("icClear", this.handleClearListener);
        this.parentEl.removeEventListener("icSubmitSearch", this.handleSubmitSearch);
    }
    componentWillLoad() {
        var _a, _b;
        this.loadUngroupedOptions();
        this.parentEl.addEventListener("icClear", this.handleClearListener);
        this.parentEl.addEventListener("icSubmitSearch", this.handleSubmitSearch);
        this.hasTimedOut = (_a = this.options) === null || _a === void 0 ? void 0 : _a.some((opt) => opt.timedOut);
        this.isLoading = (_b = this.options) === null || _b === void 0 ? void 0 : _b.some((opt) => opt.loading);
    }
    componentDidLoad() {
        if (this.isSearchBar &&
            this.parentEl.disableFilter) {
            this.focusFromSearchKeypress = true;
        }
        onComponentRequiredPropUndefined([
            { prop: this.open, propName: "open" },
            { prop: this.options, propName: "options" },
            { prop: this.menuId, propName: "menu-id" },
            { prop: this.inputLabel, propName: "input-label" },
            //NOTE: no check for value, input-el or anchor-el as otherwise get console errors on first load of select component
        ], "Menu");
    }
    componentDidUpdate() {
        const inputValueInOptions = this.options.some((option) => option[this.valueField] === this.value);
        if (this.open && this.options.length !== 0) {
            if (this.value &&
                this.keyboardNav &&
                inputValueInOptions &&
                this.autoFocusOnSelected &&
                !this.isSearchableSelect) {
                this.scrollToSelected(this.menu);
            }
            else if (this.inputEl.tagName !== "IC-TEXT-FIELD" &&
                this.inputEl.tagName !== "INPUT") {
                this.menu.focus();
            }
            else if (!!this.optionHighlighted &&
                !this.focusFromSearchKeypress &&
                !this.preventIncorrectTabOrder) {
                const highlightedEl = this.host.querySelector(`li[data-value="${this.optionHighlighted}"]`);
                if (highlightedEl) {
                    highlightedEl.focus();
                }
            }
        }
        if (this.open && !this.value && this.selectOnEnter) {
            this.scrollToSelected(this.menu);
        }
    }
    componentDidRender() {
        if (this.open && !this.popperInstance && this.anchorEl) {
            this.initPopperJs(this.anchorEl);
        }
        if (this.open && !!this.options.length) {
            this.setMenuScrollbar();
        }
    }
    /**
     * @internal If menu is opened with the mouse, emit menuStateChange custom event.
     */
    async handleClickOpen() {
        if (!this.preventClickOpen) {
            this.menuStateChange.emit({ open: !this.open });
            this.keyboardNav = false;
        }
        this.preventClickOpen = false;
    }
    /**
     * Used alongside activationType
     * If menu is opened via keyboard navigation (i.e. Enter, ArrowUp or ArrowDown), emit optionSelect custom event.
     * @param {KeyboardEvent} event The keyboard event which is available when handleKeyboardOpen is invoked.
     */
    async handleKeyboardOpen(event) {
        if (this.activationType === "automatic") {
            this.autoSetInputValueKeyboardOpen(event);
        }
        else {
            this.manSetInputValueKeyboardOpen(event);
        }
    }
    /**
     * @internal Used to highlight the first option in the menu.
     */
    async handleSetFirstOption() {
        this.setHighlightedOption(0);
    }
    /**
     * @internal Used to initialize popperJS with an anchor element.
     * 5/12/2023: Tested with Floating UI, however, discovered inconsistent
     * boundary behaviour so sticking with PopperJS.
     */
    async initPopperJs(anchor) {
        this.popperInstance = createPopper(anchor, this.host, {
            placement: "bottom",
            modifiers: [
                {
                    name: "offset",
                    options: {
                        offset: [0, 7],
                    },
                },
                {
                    name: "flip",
                    options: {
                        fallbackPlacements: ["top"],
                        rootBoundary: "viewport",
                    },
                },
            ],
        });
    }
    focusOnSearchOrSelectInput(menuOptions, highlightedOptionIndex) {
        if (!menuOptions[highlightedOptionIndex])
            return;
        if (this.isSearchBar) {
            this.parentEl.setFocus();
            if (this.searchMode === "navigation")
                this.setHighlightedOption(0);
        }
        if (this.isSearchableSelect) {
            this.parentEl.setFocus();
        }
        this.focusFromSearchKeypress = true;
    }
    render() {
        const { inputLabel, options, menuId, value, fullWidth, hasTimedOut, isLoading, size, small, open, inputEl, keyboardNav, } = this;
        return (h(Host, { class: {
                "full-width": fullWidth,
                "no-focus": (inputEl === null || inputEl === void 0 ? void 0 : inputEl.tagName) === "INPUT" || hasTimedOut || isLoading,
                small: small,
                [size]: true,
                open: open,
            } }, options.length !== 0 && (h("ul", { id: menuId, class: "menu", role: "listbox", "aria-label": inputLabel, "aria-activedescendant": value != null && value !== "" ? this.getOptionId(value) : "", tabindex: open && !keyboardNav && (inputEl === null || inputEl === void 0 ? void 0 : inputEl.tagName) !== "INPUT" ? "0" : "-1", ref: (el) => (this.menu = el), onKeyDown: this.handleMenuKeyDown, onKeyUp: this.handleMenuKeyUp, onBlur: this.handleBlur }, this.getSortedOptions(options).map((option, index) => {
            if (option.children) {
                if (option.children.length > 0) {
                    return (h("div", null, h("ic-typography", { class: "option-group-title", role: "presentation", variant: "subtitle-small" }, h("p", null, option[this.labelField])), option.children.map((childOption) => this.displayOption(childOption, index, option))));
                }
                else {
                    return null;
                }
            }
            else {
                return this.displayOption(option, index);
            }
        })))));
    }
    static get is() { return "ic-menu"; }
    static get encapsulation() { return "scoped"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-menu.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-menu.css"]
        };
    }
    static get properties() {
        return {
            "activationType": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcActivationTypes",
                    "resolved": "\"automatic\" | \"manual\"",
                    "references": {
                        "IcActivationTypes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcActivationTypes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Determines whether options manually set as values (by pressing 'Enter') when they receive focus using keyboard navigation."
                },
                "attribute": "activation-type",
                "reflect": false,
                "defaultValue": "\"automatic\""
            },
            "anchorEl": {
                "type": "unknown",
                "mutable": false,
                "complexType": {
                    "original": "HTMLElement",
                    "resolved": "HTMLElement",
                    "references": {
                        "HTMLElement": {
                            "location": "global",
                            "id": "global::HTMLElement"
                        }
                    }
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The reference to an anchor element the menu will position itself from when rendered."
                }
            },
            "autoFocusOnSelected": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, autofocus will be applied on selected item when menu is open."
                        }],
                    "text": ""
                },
                "attribute": "auto-focus-on-selected",
                "reflect": false,
                "defaultValue": "true"
            },
            "fullWidth": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the menu will fill the width of the container."
                },
                "attribute": "full-width",
                "reflect": false,
                "defaultValue": "false"
            },
            "inputEl": {
                "type": "unknown",
                "mutable": false,
                "complexType": {
                    "original": "HTMLElement",
                    "resolved": "HTMLElement",
                    "references": {
                        "HTMLElement": {
                            "location": "global",
                            "id": "global::HTMLElement"
                        }
                    }
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The reference to the input element."
                }
            },
            "inputLabel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label for the input element."
                },
                "attribute": "input-label",
                "reflect": false
            },
            "labelField": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The custom name for the label field for IcMenuOption."
                },
                "attribute": "label-field",
                "reflect": false,
                "defaultValue": "\"label\""
            },
            "menuId": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The ID of the menu."
                },
                "attribute": "menu-id",
                "reflect": false
            },
            "open": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the menu will be displayed open."
                },
                "attribute": "open",
                "reflect": true
            },
            "parentEl": {
                "type": "unknown",
                "mutable": false,
                "complexType": {
                    "original": "HTMLElement",
                    "resolved": "HTMLElement",
                    "references": {
                        "HTMLElement": {
                            "location": "global",
                            "id": "global::HTMLElement"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "- The parent element if ic-menu is nested inside another component."
                        }],
                    "text": ""
                }
            },
            "searchMode": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSearchBarSearchModes",
                    "resolved": "\"navigation\" | \"query\"",
                    "references": {
                        "IcSearchBarSearchModes": {
                            "location": "import",
                            "path": "../ic-search-bar/ic-search-bar.types",
                            "id": "src/components/ic-search-bar/ic-search-bar.types.ts::IcSearchBarSearchModes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Specify the mode search bar uses to search. `navigation` allows for quick lookups of a set of values, `query` allows for more general searches."
                },
                "attribute": "search-mode",
                "reflect": false,
                "defaultValue": "\"navigation\""
            },
            "selectOnEnter": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, the icOptionSelect event will be fired on enter instead of ArrowUp and ArrowDown."
                        }],
                    "text": ""
                },
                "attribute": "select-on-enter",
                "reflect": false,
                "defaultValue": "false"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the menu component."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "options": {
                "type": "unknown",
                "mutable": false,
                "complexType": {
                    "original": "IcMenuOption[]",
                    "resolved": "IcMenuOption[]",
                    "references": {
                        "IcMenuOption": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcMenuOption"
                        }
                    }
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The possible menu selection options."
                }
            },
            "value": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The value of the currently selected option."
                },
                "attribute": "value",
                "reflect": false
            },
            "valueField": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The custom name for the value field for IcMenuOption."
                },
                "attribute": "value-field",
                "reflect": false,
                "defaultValue": "\"value\""
            }
        };
    }
    static get states() {
        return {
            "focusFromSearchKeypress": {},
            "initialOptionsListRender": {},
            "keyboardNav": {},
            "optionHighlighted": {},
            "preventIncorrectTabOrder": {}
        };
    }
    static get events() {
        return [{
                "method": "menuKeyPress",
                "name": "menuKeyPress",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when key is pressed while menu is open"
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "{ isNavKey: boolean; key: string }",
                    "resolved": "{ isNavKey: boolean; key: string; }",
                    "references": {}
                }
            }, {
                "method": "menuOptionId",
                "name": "menuOptionId",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when an option has been highlighted"
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcMenuOptionIdEventDetail",
                    "resolved": "IcMenuOptionIdEventDetail",
                    "references": {
                        "IcMenuOptionIdEventDetail": {
                            "location": "import",
                            "path": "./ic-menu.types",
                            "id": "src/components/ic-menu/ic-menu.types.ts::IcMenuOptionIdEventDetail"
                        }
                    }
                }
            }, {
                "method": "menuOptionSelect",
                "name": "menuOptionSelect",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when an option is selected."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcOptionSelectEventDetail",
                    "resolved": "IcOptionSelectEventDetail",
                    "references": {
                        "IcOptionSelectEventDetail": {
                            "location": "import",
                            "path": "./ic-menu.types",
                            "id": "src/components/ic-menu/ic-menu.types.ts::IcOptionSelectEventDetail"
                        }
                    }
                }
            }, {
                "method": "menuStateChange",
                "name": "menuStateChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when state of menu changes (i.e. open or close)."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcMenuChangeEventDetail",
                    "resolved": "IcMenuChangeEventDetail",
                    "references": {
                        "IcMenuChangeEventDetail": {
                            "location": "import",
                            "path": "./ic-menu.types",
                            "id": "src/components/ic-menu/ic-menu.types.ts::IcMenuChangeEventDetail"
                        }
                    }
                }
            }, {
                "method": "menuValueChange",
                "name": "menuValueChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when menu value changes."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcValueEventDetail",
                    "resolved": "IcValueEventDetail",
                    "references": {
                        "IcValueEventDetail": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcValueEventDetail"
                        }
                    }
                }
            }, {
                "method": "retryButtonClicked",
                "name": "retryButtonClicked",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when the retry button is clicked"
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcValueEventDetail",
                    "resolved": "IcValueEventDetail",
                    "references": {
                        "IcValueEventDetail": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcValueEventDetail"
                        }
                    }
                }
            }, {
                "method": "timeoutBlur",
                "name": "timeoutBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when the timeout menu loses focus"
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "{ ev: FocusEvent }",
                    "resolved": "{ ev: FocusEvent; }",
                    "references": {
                        "FocusEvent": {
                            "location": "global",
                            "id": "global::FocusEvent"
                        }
                    }
                }
            }, {
                "method": "ungroupedOptionsSet",
                "name": "ungroupedOptionsSet",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when the ungrouped options have been set."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "{ options: IcMenuOption[] }",
                    "resolved": "{ options: IcMenuOption[]; }",
                    "references": {
                        "IcMenuOption": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcMenuOption"
                        }
                    }
                }
            }];
    }
    static get methods() {
        return {
            "handleClickOpen": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": "If menu is opened with the mouse, emit menuStateChange custom event."
                        }]
                }
            },
            "handleKeyboardOpen": {
                "complexType": {
                    "signature": "(event: KeyboardEvent) => Promise<void>",
                    "parameters": [{
                            "name": "event",
                            "type": "KeyboardEvent",
                            "docs": "The keyboard event which is available when handleKeyboardOpen is invoked."
                        }],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "KeyboardEvent": {
                            "location": "global",
                            "id": "global::KeyboardEvent"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Used alongside activationType\nIf menu is opened via keyboard navigation (i.e. Enter, ArrowUp or ArrowDown), emit optionSelect custom event.",
                    "tags": [{
                            "name": "param",
                            "text": "event The keyboard event which is available when handleKeyboardOpen is invoked."
                        }]
                }
            },
            "handleSetFirstOption": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": "Used to highlight the first option in the menu."
                        }]
                }
            },
            "initPopperJs": {
                "complexType": {
                    "signature": "(anchor: HTMLElement) => Promise<void>",
                    "parameters": [{
                            "name": "anchor",
                            "type": "HTMLElement",
                            "docs": ""
                        }],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLElement": {
                            "location": "global",
                            "id": "global::HTMLElement"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": "Used to initialize popperJS with an anchor element.\n5/12/2023: Tested with Floating UI, however, discovered inconsistent\nboundary behaviour so sticking with PopperJS."
                        }]
                }
            }
        };
    }
    static get elementRef() { return "host"; }
    static get watchers() {
        return [{
                "propName": "open",
                "methodName": "watchOpenHandler"
            }, {
                "propName": "options",
                "methodName": "watchOptionsHandler"
            }, {
                "propName": "value",
                "methodName": "watchValueHandler"
            }];
    }
}
//# sourceMappingURL=ic-menu.js.map
