import { Host, h, forceUpdate, } from "@stencil/core";
import { getThemeForegroundColor, inheritAttributes, onComponentRequiredPropUndefined, isSlotUsed, } from "../../utils/helpers";
import { IC_INHERITED_ARIA } from "../../utils/constants";
import { IcThemeForegroundEnum, } from "../../utils/types";
const MUTABLE_ATTRIBUTES = [...IC_INHERITED_ARIA, "title"];
/**
 * @slot icon - Content will be placed to the left of the button label.
 * @slot badge - Badge component overlaying the top right of the button.
 */
export class NavigationButton {
    constructor() {
        this.inheritedAttributes = {};
        this.hostMutationObserver = null;
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName }) => {
                if (MUTABLE_ATTRIBUTES.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] =
                        this.el.getAttribute(attributeName);
                    forceComponentUpdate = true;
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.initialAppearance = getThemeForegroundColor();
        this.mode = "navbar";
        this.download = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.label = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.target = undefined;
    }
    componentWillLoad() {
        this.inheritedAttributes = inheritAttributes(this.el, MUTABLE_ATTRIBUTES);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Navigation Button");
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            attributes: true,
        });
    }
    componentWillRender() {
        const iconEl = this.el.querySelector(`[slot="icon"]`);
        iconEl !== null && iconEl.setAttribute("viewBox", "0 0 24 24");
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    navBarMenuOpenHandler() {
        this.mode = "menu";
    }
    navBarMenuCloseHandler() {
        this.mode = "navbar";
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.initialAppearance = theme.mode;
    }
    /**
     * Sets focus on the native `button`.
     */
    async setFocus() {
        if (this.buttonEl) {
            this.buttonEl.focus();
        }
    }
    render() {
        const { href, target, rel, download, referrerpolicy } = this;
        let label = "";
        let className = "";
        let variant = "icon";
        let appearance = this.initialAppearance;
        let size = "large";
        let fullWidth = false;
        let disableTooltip = false;
        if (this.mode === "menu") {
            label = this.label;
            variant = "tertiary";
            appearance = IcThemeForegroundEnum.Default;
            size = "default";
            fullWidth = true;
            className = "popout-menu-button";
            disableTooltip = true;
        }
        const buttonProps = {
            variant,
            appearance,
            size,
            href,
            target,
            rel,
            download,
            referrerpolicy,
            fullWidth,
            disableTooltip,
        };
        return (h(Host, { class: { ["in-side-menu"]: this.mode === "menu" } }, h("ic-button", Object.assign({ class: className, "aria-label": variant == "icon" ? this.label : null, ref: (el) => (this.buttonEl = el) }, buttonProps, this.inheritedAttributes), label, h("slot", { slot: "left-icon", name: "icon" }), isSlotUsed(this.el, "badge") && variant === "icon" && (h("slot", { name: "badge" })))));
    }
    static get is() { return "ic-navigation-button"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-navigation-button.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-navigation-button.css"]
        };
    }
    static get properties() {
        return {
            "download": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | boolean",
                    "resolved": "boolean | string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the user can save the linked URL instead of navigating to it."
                },
                "attribute": "download",
                "reflect": false,
                "defaultValue": "false"
            },
            "href": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The URL that the link points to. This will render the button as an \"a\" tag."
                },
                "attribute": "href",
                "reflect": false
            },
            "hreflang": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The human language of the linked URL."
                },
                "attribute": "hreflang",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label info to display."
                },
                "attribute": "label",
                "reflect": false
            },
            "referrerpolicy": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "ReferrerPolicy",
                    "resolved": "\"\" | \"no-referrer\" | \"no-referrer-when-downgrade\" | \"origin\" | \"origin-when-cross-origin\" | \"same-origin\" | \"strict-origin\" | \"strict-origin-when-cross-origin\" | \"unsafe-url\"",
                    "references": {
                        "ReferrerPolicy": {
                            "location": "global",
                            "id": "global::ReferrerPolicy"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "How much of the referrer to send when following the link."
                },
                "attribute": "referrerpolicy",
                "reflect": false
            },
            "rel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The relationship of the linked URL as space-separated link types."
                },
                "attribute": "rel",
                "reflect": false
            },
            "target": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe)."
                },
                "attribute": "target",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "initialAppearance": {},
            "mode": {}
        };
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the native `button`.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "icNavigationMenuOpened",
                "method": "navBarMenuOpenHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }, {
                "name": "icNavigationMenuClosed",
                "method": "navBarMenuCloseHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }, {
                "name": "themeChange",
                "method": "themeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-navigation-button.js.map
